/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.mainframe;

import java.awt.Desktop;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.aboutdialog.AboutBoxDialog;

public class DesktopSupport {
    public static void handleDesktop() {
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        if (Desktop.getDesktop().isSupported(Desktop.Action.APP_ABOUT)) {
            Desktop.getDesktop().setAboutHandler(new AboutHandler(){

                @Override
                public void handleAbout(AboutEvent e) {
                    AboutBoxDialog.showAboutBox();
                }
            });
        }
        if (Desktop.getDesktop().isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
            Desktop.getDesktop().setQuitHandler(new QuitHandler(){

                @Override
                public void handleQuitRequestWith(QuitEvent qe, QuitResponse qr) {
                    boolean disposeAllowed = Main.getApplication().getMainFrame().requestDispose();
                    if (disposeAllowed) {
                        Main.getApplication().getMainFrame().execDisposeNoQuestion();
                        qr.performQuit();
                    } else {
                        qr.cancelQuit();
                    }
                }
            });
        }
    }
}

