/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.mainframe;

import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.Version;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrame;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionUtil;
import net.sourceforge.squirrel_sql.client.session.event.SessionAdapter;
import net.sourceforge.squirrel_sql.client.session.event.SessionEvent;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class MainFrameTitleHandler {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MainFrameTitleHandler.class);
    private MainFrame _mainFrame;

    public MainFrameTitleHandler(MainFrame mainFrame) {
        this._mainFrame = mainFrame;
        this.updateMainFrameTitle();
        Main.getApplication().getSessionManager().addSessionListener(new SessionAdapter(){

            @Override
            public void allSessionsClosed() {
                MainFrameTitleHandler.this._updateMainFrameTitle(true);
            }

            @Override
            public void sessionActivated(SessionEvent evt) {
                MainFrameTitleHandler.this._updateMainFrameTitle(false);
            }
        });
    }

    public void updateMainFrameTitle() {
        this._updateMainFrameTitle(false);
    }

    private void _updateMainFrameTitle(boolean allClosed) {
        Object title = s_stringMgr.getString("MainFrame.title.version.userdir", Version.getVersion(), new ApplicationFiles().getUserSettingsDirectory());
        ISession activeSession = Main.getApplication().getSessionManager().getActiveSession();
        if (!allClosed && null != activeSession && null != activeSession.getSavedSession()) {
            title = (String)title + " / " + SavedSessionUtil.getMainFrameTitleString(activeSession.getSavedSession());
        }
        this._mainFrame.setTitle((String)title);
    }
}

