/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.pastefromhistory;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.pastefromhistory.PasteFromHistoryDialog;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.mainpanel.multiclipboard.PasteHistory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;

public class PasteFromHistoryController {
    private static final String PREF_KEY_PASTE_HIST_DIALOG_WIDTH = "Squirrel.paste.history.dialog.width";
    private static final String PREF_KEY_PASTE_HIST_DIALOG_HEIGHT = "Squirrel.paste.history.dialog.height";
    private final PasteFromHistoryDialog _dlg;
    private ISQLPanelAPI _sqlPanelAPI;

    public PasteFromHistoryController(ISQLPanelAPI sqlPanelAPI) {
        this._sqlPanelAPI = sqlPanelAPI;
        this._dlg = new PasteFromHistoryDialog();
        this._dlg.txtHistoryDetail.setEditable(false);
        PasteHistory pasteHistory = Main.getApplication().getPasteHistory();
        String[] history = pasteHistory.getHistory();
        this._dlg.lstHistoryItems.setListData(history);
        if (0 < history.length) {
            this._dlg.lstHistoryItems.setSelectedIndex(0);
            this._dlg.txtHistoryDetail.setText(history[0]);
        }
        this._dlg.setSize(this.getDimension());
        this._dlg.btnCancel.addActionListener(e -> this.close());
        this._dlg.btnOk.addActionListener(e -> this.onOk());
        this._dlg.lstHistoryItems.requestFocus();
        this._dlg.lstHistoryItems.addListSelectionListener(e -> this.onSelectionChanged(e));
        this._dlg.lstHistoryItems.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PasteFromHistoryController.this.onListMouseClicked(e);
            }
        });
        this._dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PasteFromHistoryController.this.onWindowClosing();
            }
        });
        this._dlg.setVisible(true);
        GUIUtils.centerWithinParent(this._dlg);
        SwingUtilities.invokeLater(() -> this._dlg.lstHistoryItems.requestFocus());
    }

    private void onListMouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.onOk();
        }
    }

    private void onOk() {
        String selected = (String)this._dlg.lstHistoryItems.getSelectedValue();
        if (null != selected) {
            this._sqlPanelAPI.getSQLEntryPanel().replaceSelection(selected);
        }
        StringSelection contents = new StringSelection(selected);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, contents);
        Main.getApplication().getPasteHistory().addToPasteHistory(selected);
        this.close();
    }

    private void close() {
        this.onWindowClosing();
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private Dimension getDimension() {
        return new Dimension(Props.getInt(PREF_KEY_PASTE_HIST_DIALOG_WIDTH, 800), Props.getInt(PREF_KEY_PASTE_HIST_DIALOG_HEIGHT, 500));
    }

    private void onSelectionChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        String selectedValue = (String)this._dlg.lstHistoryItems.getSelectedValue();
        if (null == selectedValue) {
            this._dlg.txtHistoryDetail.setText("");
        } else {
            this._dlg.txtHistoryDetail.setText(selectedValue);
        }
    }

    private void onWindowClosing() {
        Dimension size = this._dlg.getSize();
        Props.putInt(PREF_KEY_PASTE_HIST_DIALOG_WIDTH, size.width);
        Props.putInt(PREF_KEY_PASTE_HIST_DIALOG_HEIGHT, size.height);
    }
}

