/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.recentfiles;

import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.dnd.DropedFileExtractor;
import net.sourceforge.squirrel_sql.client.gui.recentfiles.RecentFileWrapper;
import net.sourceforge.squirrel_sql.client.gui.recentfiles.RecentFilesDialog;
import net.sourceforge.squirrel_sql.client.gui.recentfiles.RecentFilesTreeCellRenderer;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileHandler;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileManagementUtil;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.TreeDnDHandler;
import net.sourceforge.squirrel_sql.fw.gui.TreeDnDHandlerCallback;
import net.sourceforge.squirrel_sql.fw.gui.filechooser.PreviewFileChooser;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.DesktopUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class RecentFilesController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RecentFilesDialog.class);
    private static final ILogger s_log = LoggerController.createLogger(RecentFilesController.class);
    private static final String PREF_KEY_RECENT_FILES_EXPANDED = "Squirrel.recentFiles.expanded";
    private static final String PREF_KEY_FAVOURITE_FILES_EXPANDED = "Squirrel.favouriteFiles.expanded";
    private static final String PREF_KEY_RECENT_ALIAS_FILES_EXPANDED = "Squirrel.recentAliasFiles.expanded";
    private static final String PREF_KEY_FAVOURITE_ALIAS_FILES_EXPANDED = "Squirrel.favouriteAliasFiles.expanded";
    private static final String PREF_KEY_SHOW_PREVIEW = "Squirrel.recentFiles.showPreview";
    private static final String PREF_KEY_SPLIT_DIVIDER_LOCATION = "Squirrel.recentFiles.split.divider.location";
    private RecentFilesDialog _dialog;
    private IApplication _app;
    private Frame _parent;
    private SQLAlias _selectedAlias;
    private DefaultMutableTreeNode _recentFilesNode;
    private DefaultMutableTreeNode _favouriteFilesNode;
    private DefaultMutableTreeNode _recentFilesForAliasNode;
    private DefaultMutableTreeNode _favouriteFilesForAliasNode;
    private RecentFileWrapper _fileToOpen;
    private int standardSplitDividerSize;

    public RecentFilesController(IApplication app, SQLAlias selectedAlias) {
        this.init(app, app.getMainFrame(), selectedAlias, true);
    }

    public RecentFilesController(FileHandler fileHandler) {
        Frame parent = GUIUtils.getOwningFrame(fileHandler.getFileEditorAPI().getTextComponent());
        this.init(Main.getApplication(), parent, fileHandler.getFileEditorAPI().getSession().getAlias(), false);
    }

    private void init(IApplication app, Frame parent, SQLAlias alias, boolean isCalledFromAliasView) {
        this._app = app;
        this._parent = parent;
        this._selectedAlias = alias;
        this._dialog = new RecentFilesDialog(this._parent, isCalledFromAliasView, alias);
        this._dialog.btnClose.addActionListener(e -> this.onCloseButton());
        this.initAndLoadTree();
        this.standardSplitDividerSize = this._dialog.splitTreePreview.getDividerSize();
        this._dialog.chkShowPreview.setSelected(Props.getBoolean(PREF_KEY_SHOW_PREVIEW, false));
        this._dialog.chkShowPreview.addActionListener(e -> this.onShowPreview());
        this.onShowPreview();
        this._dialog.splitTreePreview.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                RecentFilesController.this.onSplitPaneResized();
            }
        });
        this._dialog.txtNumberRecentFiles.setInt(this._app.getRecentFilesManager().getMaxRecentFiles());
        this._dialog.txtNumberRecentFiles.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                RecentFilesController.this.updateRecentFilesCount();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RecentFilesController.this.updateRecentFilesCount();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RecentFilesController.this.updateRecentFilesCount();
            }
        });
        this._dialog.btnFavourites.addActionListener(e -> this.onAddToFavourites(null));
        this._dialog.btnAliasFavourites.addActionListener(e -> this.onAddToFavourites(alias));
        this._dialog.btnRemoveSeleted.addActionListener(e -> this.onRemoveSelected());
        this._dialog.btnOpenFile.addActionListener(e -> this.onOpenFile());
        this._dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RecentFilesController.this.onWindowClosing();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                RecentFilesController.this.onWindowClosing();
            }
        });
        this._dialog.setVisible(true);
    }

    private void onSplitPaneResized() {
        if (!this._dialog.chkShowPreview.isSelected()) {
            this.hideRightSplit();
        }
    }

    private void onCloseButton() {
        this.writeUiTreeToModel();
        this._dialog.dispose();
    }

    private void onOpenFile() {
        this._fileToOpen = this.findFileToOpen(null);
        if (null == this._fileToOpen) {
            return;
        }
        this._dialog.dispose();
    }

    private void onWindowClosing() {
        JTree tre = this._dialog.treFiles;
        tre.isCollapsed(new TreePath(this._recentFilesNode.getPath()));
        Props.putBoolean(PREF_KEY_RECENT_FILES_EXPANDED, tre.isExpanded(new TreePath(this._recentFilesNode.getPath())));
        Props.putBoolean(PREF_KEY_FAVOURITE_FILES_EXPANDED, tre.isExpanded(new TreePath(this._favouriteFilesNode.getPath())));
        Props.putBoolean(PREF_KEY_RECENT_ALIAS_FILES_EXPANDED, tre.isExpanded(new TreePath(this._recentFilesForAliasNode.getPath())));
        Props.putBoolean(PREF_KEY_FAVOURITE_ALIAS_FILES_EXPANDED, tre.isExpanded(new TreePath(this._favouriteFilesForAliasNode.getPath())));
        Props.putBoolean(PREF_KEY_SHOW_PREVIEW, this._dialog.chkShowPreview.isSelected());
        this.saveSpiltDividerLocation();
    }

    private void saveSpiltDividerLocation() {
        Props.putInt(PREF_KEY_SPLIT_DIVIDER_LOCATION, this._dialog.splitTreePreview.getDividerLocation());
    }

    private void onRemoveSelected() {
        HashSet<DefaultMutableTreeNode> changedParents = new HashSet<DefaultMutableTreeNode>();
        TreePath[] paths = this._dialog.treFiles.getSelectionPaths();
        DefaultTreeModel model = (DefaultTreeModel)this._dialog.treFiles.getModel();
        for (TreePath path : paths) {
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!(dmtn.getUserObject() instanceof RecentFileWrapper)) continue;
            model.removeNodeFromParent(dmtn);
            changedParents.add((DefaultMutableTreeNode)path.getParentPath().getLastPathComponent());
        }
        for (DefaultMutableTreeNode changedParent : changedParents) {
            model.nodeStructureChanged(changedParent);
        }
        this.writeUiTreeToModel();
    }

    private void writeUiTreeToModel() {
        this._app.getRecentFilesManager().setRecentFiles(this.getFileStringsFromNode(this._recentFilesNode));
        this._app.getRecentFilesManager().setFavouriteFiles(this.getFileStringsFromNode(this._favouriteFilesNode));
        this._app.getRecentFilesManager().setRecentFilesForAlias(this._selectedAlias, this.getFileStringsFromNode(this._recentFilesForAliasNode));
        this._app.getRecentFilesManager().setFavouriteFilesForAlias(this._selectedAlias, this.getFileStringsFromNode(this._favouriteFilesForAliasNode));
        this._app.getRecentFilesManager().setOpenAtStartupFile(this._selectedAlias, this.getOpenAtStartupFile(this._favouriteFilesForAliasNode));
    }

    private String getOpenAtStartupFile(DefaultMutableTreeNode parentNode) {
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            RecentFileWrapper fileWrapper = (RecentFileWrapper)((DefaultMutableTreeNode)parentNode.getChildAt(i)).getUserObject();
            if (!fileWrapper.isOpenAtSessionStart()) continue;
            return fileWrapper.getFile().getAbsolutePath();
        }
        return null;
    }

    private ArrayList<String> getFileStringsFromNode(DefaultMutableTreeNode parentNode) {
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            RecentFileWrapper fileWrapper = (RecentFileWrapper)((DefaultMutableTreeNode)parentNode.getChildAt(i)).getUserObject();
            files.add(fileWrapper.getFile().getAbsolutePath());
        }
        return files;
    }

    private void onAddToFavourites(SQLAlias alias) {
        ArrayList<String> listToAddTo;
        DefaultMutableTreeNode nodeToAddTo;
        JFileChooser fc = new JFileChooser(this._app.getSquirrelPreferences().getFilePreviousDir());
        fc.setFileSelectionMode(2);
        int returnVal = PreviewFileChooser.showOpenDialog(this._parent, fc);
        if (returnVal != 0) {
            return;
        }
        if (null == alias) {
            this._app.getRecentFilesManager().adjustFavouriteFiles(fc.getSelectedFile());
            nodeToAddTo = this._favouriteFilesNode;
            listToAddTo = this._app.getRecentFilesManager().getFavouriteFiles();
        } else {
            this._app.getRecentFilesManager().adjustFavouriteAliasFiles(alias, fc.getSelectedFile());
            nodeToAddTo = this._favouriteFilesForAliasNode;
            listToAddTo = this._app.getRecentFilesManager().getFavouriteFilesForAlias(alias);
        }
        nodeToAddTo.removeAllChildren();
        this.addFileKidsToNode(nodeToAddTo, listToAddTo, false);
        DefaultTreeModel dtm = (DefaultTreeModel)this._dialog.treFiles.getModel();
        dtm.nodeStructureChanged(nodeToAddTo);
        this._dialog.treFiles.expandPath(new TreePath(nodeToAddTo.getPath()));
        DefaultMutableTreeNode firstChild = (DefaultMutableTreeNode)nodeToAddTo.getFirstChild();
        this._dialog.treFiles.scrollPathToVisible(new TreePath(firstChild.getPath()));
    }

    private void updateRecentFilesCount() {
        int maxRecentFiles = this._dialog.txtNumberRecentFiles.getInt();
        if (0 < maxRecentFiles) {
            this._app.getRecentFilesManager().setMaxRecentFiles(maxRecentFiles);
        }
    }

    private void initAndLoadTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        this._dialog.treFiles.setCellRenderer(new RecentFilesTreeCellRenderer(this._app));
        this._recentFilesNode = GUIUtils.createFolderNode(s_stringMgr.getString("RecentFilesController.recentFiles.global"));
        this.addFileKidsToNode(this._recentFilesNode, this._app.getRecentFilesManager().getRecentFiles(), Props.getBoolean(PREF_KEY_RECENT_FILES_EXPANDED, true));
        root.add(this._recentFilesNode);
        this._favouriteFilesNode = GUIUtils.createFolderNode(s_stringMgr.getString("RecentFilesController.favouritFiles.global"));
        this.addFileKidsToNode(this._favouriteFilesNode, this._app.getRecentFilesManager().getFavouriteFiles(), Props.getBoolean(PREF_KEY_FAVOURITE_FILES_EXPANDED, true));
        root.add(this._favouriteFilesNode);
        this._recentFilesForAliasNode = GUIUtils.createFolderNode(s_stringMgr.getString("RecentFilesController.recentFiles.alias", this._selectedAlias.getName()));
        this.addFileKidsToNode(this._recentFilesForAliasNode, this._app.getRecentFilesManager().getRecentFilesForAlias(this._selectedAlias), Props.getBoolean(PREF_KEY_RECENT_ALIAS_FILES_EXPANDED, true));
        root.add(this._recentFilesForAliasNode);
        this._favouriteFilesForAliasNode = GUIUtils.createFolderNode(s_stringMgr.getString("RecentFilesController.favouritFiles.alias", this._selectedAlias.getName()));
        this.addFileKidsToNode(this._favouriteFilesForAliasNode, this._app.getRecentFilesManager().getFavouriteFilesForAlias(this._selectedAlias), Props.getBoolean(PREF_KEY_FAVOURITE_ALIAS_FILES_EXPANDED, true));
        root.add(this._favouriteFilesForAliasNode);
        String openAtStartupFileForAlias = this._app.getRecentFilesManager().getOpenAtStartupFileForAlias(this._selectedAlias);
        if (null != openAtStartupFileForAlias) {
            boolean found = false;
            for (int i = 0; i < this._favouriteFilesForAliasNode.getChildCount(); ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)this._favouriteFilesForAliasNode.getChildAt(i);
                RecentFileWrapper fileWrapper = (RecentFileWrapper)child.getUserObject();
                if (!openAtStartupFileForAlias.equals(fileWrapper.getFile().getAbsolutePath())) continue;
                fileWrapper.setOpenAtSessionStart(true);
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalStateException("The open at Session start up file is not one of the Alias's favourite files.");
            }
        }
        this._dialog.treFiles.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RecentFilesController.this.onMouseClickedTree(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                RecentFilesController.this.maybeShowTreePopup(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                RecentFilesController.this.maybeShowTreePopup(evt);
            }
        });
        this._dialog.treFiles.addTreeSelectionListener(e -> this.onTreeSelectionChanged());
        this._dialog.treFiles.setModel(new DefaultTreeModel(root));
        this._dialog.treFiles.setRootVisible(false);
        this.initDnD();
    }

    private void onShowPreview() {
        if (this._dialog.chkShowPreview.isSelected()) {
            int preferredDividerLocation;
            this._dialog.splitTreePreview.setDividerSize(this.standardSplitDividerSize);
            int dividerLocation = preferredDividerLocation = this._app.getPropsImpl().getInt(PREF_KEY_SPLIT_DIVIDER_LOCATION, this._dialog.getWidthPreference() / 2);
            if (0 < this._dialog.splitTreePreview.getWidth()) {
                dividerLocation = Math.min(this._dialog.splitTreePreview.getMaximumDividerLocation(), preferredDividerLocation);
            }
            this._dialog.splitTreePreview.setDividerLocation(dividerLocation);
        } else {
            this.saveSpiltDividerLocation();
            this.hideRightSplit();
        }
        this.onTreeSelectionChanged();
    }

    private void hideRightSplit() {
        this._dialog.splitTreePreview.setDividerLocation(Integer.MAX_VALUE);
        this._dialog.splitTreePreview.setDividerSize(0);
    }

    private void onTreeSelectionChanged() {
        String text;
        this._dialog.txtPreview.setText("");
        if (!this._dialog.chkShowPreview.isSelected()) {
            return;
        }
        TreePath selectionPath = this._dialog.treFiles.getSelectionPath();
        if (null == selectionPath) {
            return;
        }
        Object userObject = ((DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject();
        if (!(userObject instanceof RecentFileWrapper)) {
            return;
        }
        RecentFileWrapper fileWrapper = (RecentFileWrapper)userObject;
        if (null == fileWrapper.getFile()) {
            return;
        }
        if (!fileWrapper.getFile().exists()) {
            text = s_stringMgr.getString("RecentFilesController.preview.doesNotExist", fileWrapper.getFile().getAbsolutePath());
        } else if (fileWrapper.getFile().isDirectory()) {
            text = s_stringMgr.getString("RecentFilesController.preview.isADirectory", fileWrapper.getFile().getAbsolutePath());
        } else if (!fileWrapper.getFile().canRead()) {
            text = s_stringMgr.getString("RecentFilesController.preview.canNotRead", fileWrapper.getFile().getAbsolutePath());
        } else {
            try {
                text = FileManagementUtil.readFileAsString(fileWrapper.getFile(), 15000);
            }
            catch (Exception e) {
                String errMsg = s_stringMgr.getString("RecentFilesController.preview.errorReadingFile", fileWrapper.getFile().getAbsolutePath(), e.toString());
                Main.getApplication().getMessageHandler().showErrorMessage(errMsg);
                text = errMsg;
                s_log.error(errMsg, e);
            }
        }
        this._dialog.txtPreview.setText(text);
        SwingUtilities.invokeLater(() -> this._dialog.txtPreview.scrollRectToVisible(new Rectangle(0, 0)));
    }

    private void initDnD() {
        TreeDnDHandlerCallback treeDnDHandlerCallback = new TreeDnDHandlerCallback(){

            @Override
            public boolean nodeAcceptsKids(DefaultMutableTreeNode selNode) {
                return RecentFilesController.this.onNodeAcceptsKids(selNode);
            }

            @Override
            public void dndExecuted() {
                RecentFilesController.this.onDndExecuted();
            }

            @Override
            public ArrayList<DefaultMutableTreeNode> getPasteTreeNodesFromExternalTransfer(DropTargetDropEvent dtde, TreePath targetPath) {
                return RecentFilesController.this.onCreatePasteTreeNodesFromExternalTransfer(dtde, targetPath);
            }
        };
        new TreeDnDHandler(this._dialog.treFiles, treeDnDHandlerCallback, true);
    }

    private ArrayList<DefaultMutableTreeNode> onCreatePasteTreeNodesFromExternalTransfer(DropTargetDropEvent dtde, TreePath targetPath) {
        List<File> files = DropedFileExtractor.getFiles(dtde);
        ArrayList<DefaultMutableTreeNode> ret = new ArrayList<DefaultMutableTreeNode>();
        DefaultMutableTreeNode parent = this.findParent(targetPath);
        for (File file : files) {
            if (this.parentContainsFile(parent, file)) continue;
            ret.add(new DefaultMutableTreeNode(new RecentFileWrapper(file)));
        }
        return ret;
    }

    private boolean parentContainsFile(DefaultMutableTreeNode parentNode, File fileToCheck) {
        if (null == parentNode) {
            return false;
        }
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            RecentFileWrapper fileWrapper = (RecentFileWrapper)((DefaultMutableTreeNode)parentNode.getChildAt(i)).getUserObject();
            if (!fileWrapper.getFile().equals(fileToCheck)) continue;
            return true;
        }
        return false;
    }

    private DefaultMutableTreeNode findParent(TreePath targetPath) {
        if (((DefaultMutableTreeNode)targetPath.getLastPathComponent()).getUserObject() instanceof RecentFileWrapper) {
            targetPath = targetPath.getParentPath();
        }
        if (targetPath.getLastPathComponent() == this._recentFilesNode) {
            return this._recentFilesNode;
        }
        if (targetPath.getLastPathComponent() == this._recentFilesForAliasNode) {
            return this._recentFilesForAliasNode;
        }
        if (targetPath.getLastPathComponent() == this._favouriteFilesNode) {
            return this._favouriteFilesNode;
        }
        if (targetPath.getLastPathComponent() == this._favouriteFilesForAliasNode) {
            return this._favouriteFilesForAliasNode;
        }
        return null;
    }

    private void onDndExecuted() {
        this.writeUiTreeToModel();
    }

    private boolean onNodeAcceptsKids(DefaultMutableTreeNode selNode) {
        return this._recentFilesNode == selNode || this._recentFilesForAliasNode == selNode || this._favouriteFilesNode == selNode || this._favouriteFilesForAliasNode == selNode;
    }

    private void onMouseClickedTree(MouseEvent evt) {
        this._fileToOpen = this.findFileToOpen(evt);
        if (null != this._fileToOpen) {
            this._dialog.dispose();
        }
    }

    private void maybeShowTreePopup(MouseEvent evt) {
        if (!evt.isPopupTrigger()) {
            return;
        }
        TreePath clickedPath = this._dialog.treFiles.getPathForLocation(evt.getX(), evt.getY());
        if (null == clickedPath) {
            return;
        }
        this._dialog.treFiles.setSelectionPath(clickedPath);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)clickedPath.getLastPathComponent();
        if (!(node.getUserObject() instanceof RecentFileWrapper)) {
            return;
        }
        RecentFileWrapper fileWrapper = (RecentFileWrapper)node.getUserObject();
        JPopupMenu popUp = new JPopupMenu();
        popUp.add(this.createOpenInFileManagerItem(fileWrapper.getFile()));
        if (fileWrapper.getFile().isFile()) {
            JMenuItem mnuCopyFileName = new JMenuItem(s_stringMgr.getString("RecentFilesController.copy.filename"));
            mnuCopyFileName.addActionListener(e -> this.onCopyFileName(fileWrapper));
            popUp.add(mnuCopyFileName);
        }
        JMenuItem mnuCopyPath = new JMenuItem(s_stringMgr.getString("RecentFilesController.copy.path"));
        mnuCopyPath.addActionListener(e -> this.onCopyPath(fileWrapper));
        popUp.add(mnuCopyPath);
        JMenuItem mnuRemove = new JMenuItem(s_stringMgr.getString("RecentFilesController.remove.from.recent"));
        mnuRemove.addActionListener(e -> this.onRemoveSelected());
        popUp.add(mnuRemove);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        if (fileWrapper.getFile().isFile() && parent == this._favouriteFilesForAliasNode) {
            popUp.add(this.createOpenAtSessionStartupItem(node));
        }
        popUp.show(evt.getComponent(), evt.getX(), evt.getY());
    }

    private void onCopyPath(RecentFileWrapper fileWrapper) {
        StringSelection ss = new StringSelection(fileWrapper.getFile().getPath());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
    }

    private void onCopyFileName(RecentFileWrapper fileWrapper) {
        StringSelection ss = new StringSelection(fileWrapper.getFile().getName());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
    }

    private JMenuItem createOpenAtSessionStartupItem(DefaultMutableTreeNode node) {
        JMenuItem menuItem = new JMenuItem(s_stringMgr.getString("RecentFilesController.toggle.open.at.session.connect"));
        menuItem.addActionListener(e -> this.onOpenFileAtSessionConnect(node));
        return menuItem;
    }

    private void onOpenFileAtSessionConnect(DefaultMutableTreeNode node) {
        if (((RecentFileWrapper)node.getUserObject()).isOpenAtSessionStart()) {
            ((RecentFileWrapper)node.getUserObject()).setOpenAtSessionStart(false);
            ((DefaultTreeModel)this._dialog.treFiles.getModel()).nodeChanged(node);
            return;
        }
        TreeNode aliasFavouritesNode = node.getParent();
        for (int i = 0; i < aliasFavouritesNode.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)aliasFavouritesNode.getChildAt(i);
            ((RecentFileWrapper)child.getUserObject()).setOpenAtSessionStart(false);
        }
        ((RecentFileWrapper)node.getUserObject()).setOpenAtSessionStart(true);
        ((DefaultTreeModel)this._dialog.treFiles.getModel()).nodeStructureChanged(aliasFavouritesNode);
    }

    private JMenuItem createOpenInFileManagerItem(File file) {
        JMenuItem menuItem = file.isDirectory() ? new JMenuItem(s_stringMgr.getString("RecentFilesController.open.in.file.manager")) : new JMenuItem(s_stringMgr.getString("RecentFilesController.open.parent.in.file.manager"));
        menuItem.addActionListener(e -> this.onOpenInFileManager(file));
        return menuItem;
    }

    private void onOpenInFileManager(File file) {
        DesktopUtil.openInFileManager(file);
    }

    private RecentFileWrapper findFileToOpen(MouseEvent evt) {
        DefaultMutableTreeNode tn = this.getSelectedFileNode(evt);
        if (tn == null) {
            if (null == evt) {
                JOptionPane.showMessageDialog(this._dialog, s_stringMgr.getString("RecentFilesController.pleaseSelectFile"));
            }
            return null;
        }
        RecentFileWrapper fileWrapper = (RecentFileWrapper)tn.getUserObject();
        if (!fileWrapper.getFile().exists()) {
            if (0 == JOptionPane.showConfirmDialog(this._dialog, s_stringMgr.getString("RecentFilesController.fileDoesNotExist"))) {
                DefaultTreeModel model = (DefaultTreeModel)this._dialog.treFiles.getModel();
                TreeNode parent = tn.getParent();
                model.removeNodeFromParent(tn);
                model.nodeStructureChanged(parent);
                if (parent == this._recentFilesNode) {
                    this._app.getRecentFilesManager().setRecentFiles(this.getFileStringsFromNode(this._recentFilesNode));
                } else if (parent == this._favouriteFilesNode) {
                    this._app.getRecentFilesManager().setFavouriteFiles(this.getFileStringsFromNode(this._favouriteFilesNode));
                } else if (parent == this._recentFilesForAliasNode) {
                    this._app.getRecentFilesManager().setRecentFilesForAlias(this._selectedAlias, this.getFileStringsFromNode(this._recentFilesForAliasNode));
                } else {
                    this._app.getRecentFilesManager().setFavouriteFilesForAlias(this._selectedAlias, this.getFileStringsFromNode(this._favouriteFilesForAliasNode));
                }
            }
            return null;
        }
        if (fileWrapper.getFile().isDirectory()) {
            JFileChooser fc = new JFileChooser(fileWrapper.getFile());
            fc.setFileSelectionMode(0);
            int returnVal = PreviewFileChooser.showOpenDialog(this._parent, fc);
            if (returnVal != 0) {
                return null;
            }
            fileWrapper = new RecentFileWrapper(fc.getSelectedFile());
        }
        if (!fileWrapper.getFile().canRead()) {
            JOptionPane.showMessageDialog(this._dialog, s_stringMgr.getString("RecentFilesController.fileIsNotReadable"));
            return null;
        }
        return fileWrapper;
    }

    private DefaultMutableTreeNode getSelectedFileNode(MouseEvent evt) {
        DefaultMutableTreeNode tn;
        TreePath path = this._dialog.treFiles.getSelectionPath();
        if (null == path) {
            return null;
        }
        if (null != evt) {
            if (evt.getClickCount() < 2) {
                return null;
            }
            if (!this._dialog.treFiles.getPathBounds(path).contains(evt.getPoint())) {
                return null;
            }
        }
        if (!((tn = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof RecentFileWrapper)) {
            return null;
        }
        return tn;
    }

    private void addFileKidsToNode(final DefaultMutableTreeNode parentNode, ArrayList<String> filePaths, final boolean expand) {
        for (String filePath : filePaths) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new RecentFileWrapper(new File(filePath)));
            parentNode.add(node);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (expand) {
                    RecentFilesController.this._dialog.treFiles.expandPath(new TreePath(parentNode.getPath()));
                }
            }
        });
    }

    public File getFileToOpen() {
        if (null == this._fileToOpen) {
            return null;
        }
        return this._fileToOpen.getFile();
    }

    public boolean isAppend() {
        return this._dialog.chkAppend.isSelected();
    }
}

