/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.recentfiles;

import java.io.File;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.recentfiles.AliasFileXmlBean;
import net.sourceforge.squirrel_sql.client.gui.recentfiles.RecentFilesJsonBean;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.util.JsonMarshalUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class RecentFilesManager {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RecentFilesManager.class);
    private RecentFilesJsonBean _recentFilesJsonBean = new RecentFilesJsonBean();

    public void fileTouched(String absolutePath, SQLAlias alias) {
        ArrayList<String> recentFiles = this._recentFilesJsonBean.getRecentFiles();
        this.adjustFileArray(absolutePath, recentFiles);
        ArrayList<String> recentAliasFiles = this.findOrCreateAliasFile(alias).getRecentFiles();
        this.adjustFileArray(absolutePath, recentAliasFiles);
    }

    private void adjustFileArray(String newAbsolutePath, ArrayList<String> fileArray) {
        fileArray.remove(newAbsolutePath);
        fileArray.add(0, newAbsolutePath);
        while (this._recentFilesJsonBean.getMaxRecentFiles() < fileArray.size()) {
            fileArray.remove(fileArray.size() - 1);
        }
    }

    private AliasFileXmlBean findOrCreateAliasFile(SQLAlias alias) {
        AliasFileXmlBean ret = this.findAliasFile(alias);
        if (null == ret) {
            ret = new AliasFileXmlBean();
            ret.setAlisaIdentifierString(alias.getIdentifier().toString());
            this._recentFilesJsonBean.getAliasFileXmlBeans().add(ret);
        }
        return ret;
    }

    private AliasFileXmlBean findAliasFile(SQLAlias alias) {
        AliasFileXmlBean ret = null;
        ArrayList<AliasFileXmlBean> aliasFileXmlBeans = this._recentFilesJsonBean.getAliasFileXmlBeans();
        for (AliasFileXmlBean aliasFileXmlBean : aliasFileXmlBeans) {
            if (!aliasFileXmlBean.getAlisaIdentifierString().equals(alias.getIdentifier().toString())) continue;
            ret = aliasFileXmlBean;
            break;
        }
        return ret;
    }

    public void saveJsonBean(File recentFilesBeanFile) {
        JsonMarshalUtil.writeObjectToFile(recentFilesBeanFile, this._recentFilesJsonBean);
    }

    public void initJSonBean(File recentFilesJsonBeanFile) {
        this.checkIfOlderVersionWarningIsNeeded();
        if (!recentFilesJsonBeanFile.exists()) {
            return;
        }
        this._recentFilesJsonBean = JsonMarshalUtil.readObjectFromFileSave(recentFilesJsonBeanFile, RecentFilesJsonBean.class, new RecentFilesJsonBean());
    }

    private void checkIfOlderVersionWarningIsNeeded() {
        File oldVersionFile = new ApplicationFiles().getRecentFilesXmlBeanFile_oldXmlVersion();
        if (oldVersionFile.exists()) {
            Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("RecentFilesManager.old.version.warning", oldVersionFile.getPath()));
        }
    }

    public ArrayList<String> getRecentFiles() {
        return this._recentFilesJsonBean.getRecentFiles();
    }

    public ArrayList<String> getFavouriteFiles() {
        return this._recentFilesJsonBean.getFavouriteFiles();
    }

    public ArrayList<String> getRecentFilesForAlias(SQLAlias selectedAlias) {
        return this.findOrCreateAliasFile(selectedAlias).getRecentFiles();
    }

    public ArrayList<String> getFavouriteFilesForAlias(SQLAlias selectedAlias) {
        return this.findOrCreateAliasFile(selectedAlias).getFavouriteFiles();
    }

    public int getMaxRecentFiles() {
        return this._recentFilesJsonBean.getMaxRecentFiles();
    }

    public void setMaxRecentFiles(int n) {
        this._recentFilesJsonBean.setMaxRecentFiles(n);
    }

    public void adjustFavouriteFiles(File selectedFile) {
        this.adjustFileArray(selectedFile.getAbsolutePath(), this._recentFilesJsonBean.getFavouriteFiles());
    }

    public void adjustFavouriteAliasFiles(SQLAlias alias, File selectedFile) {
        this.adjustFileArray(selectedFile.getAbsolutePath(), this.findOrCreateAliasFile(alias).getFavouriteFiles());
    }

    public void setRecentFiles(ArrayList<String> files) {
        this._recentFilesJsonBean.setRecentFiles(files);
    }

    public void setFavouriteFiles(ArrayList<String> files) {
        this._recentFilesJsonBean.setFavouriteFiles(files);
    }

    public void setRecentFilesForAlias(SQLAlias alias, ArrayList<String> files) {
        this.findOrCreateAliasFile(alias).setRecentFiles(files);
    }

    public void setFavouriteFilesForAlias(SQLAlias alias, ArrayList<String> files) {
        this.findOrCreateAliasFile(alias).setFavouriteFiles(files);
    }

    public void setOpenAtStartupFile(SQLAlias alias, String openAtStartupFile) {
        AliasFileXmlBean aliasFile = this.findOrCreateAliasFile(alias);
        if (null != openAtStartupFile) {
            boolean found = false;
            for (String favouriteFile : aliasFile.getFavouriteFiles()) {
                if (!openAtStartupFile.equals(favouriteFile)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalStateException("The startup file \"" + openAtStartupFile + " \"is not one of the Alias favourite files.");
            }
        }
        aliasFile.setOpenAtStartupFile(openAtStartupFile);
    }

    public String getOpenAtStartupFileForAlias(SQLAlias alias) {
        AliasFileXmlBean aliasFile = this.findAliasFile(alias);
        if (null == aliasFile) {
            return null;
        }
        return aliasFile.getOpenAtStartupFile();
    }

    public void removeFromRecentFiles(File toRemove) {
        this._recentFilesJsonBean.getRecentFiles().removeIf(f -> f.equals(toRemove.getAbsolutePath()));
        this._recentFilesJsonBean.getAliasFileXmlBeans().forEach(af -> af.getRecentFiles().removeIf(f -> f.equals(toRemove.getAbsolutePath())));
    }
}

