/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session;

import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class CurrentSchemaModel {
    private static final ILogger s_log = LoggerController.createLogger(CurrentSchemaModel.class);
    private ISession _session;
    private String _currentSchemaString;
    private boolean _noCurrentSchemaAvailable;
    private boolean _failedToLoadSchema;
    private boolean _initialized;

    public CurrentSchemaModel(ISession session) {
        this._session = session;
    }

    public void setCurrentSchema(String schemaName) {
        try {
            this._session.getSQLConnection().setSchema(schemaName);
            if (schemaName.equalsIgnoreCase(this._session.getSQLConnection().getSchema())) {
                this._session.getConnectionPool().setSessionSchema(schemaName);
                this.refreshSchema(true);
            } else {
                s_log.error("Setting schema didn't take effect.");
            }
        }
        catch (Throwable e) {
            s_log.error("Failed to set schema", e);
        }
    }

    public String refreshSchema(boolean logException) {
        block4: {
            this._initialized = true;
            this._currentSchemaString = null;
            this._noCurrentSchemaAvailable = false;
            this._failedToLoadSchema = false;
            try {
                String buf = this._session.getSQLConnection().getSchema();
                if (StringUtilities.isEmpty(buf, true)) {
                    this._currentSchemaString = "<None>";
                    this._noCurrentSchemaAvailable = true;
                } else {
                    this._currentSchemaString = buf;
                }
            }
            catch (Throwable e) {
                this._currentSchemaString = "<Not accessible>";
                this._failedToLoadSchema = true;
                if (!logException) break block4;
                s_log.error("Failed to load current schema name", e);
            }
        }
        return this._currentSchemaString;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public boolean isJDBCConnectionProvidesCurrentSchema() {
        if (!this._initialized) {
            throw new IllegalStateException("Needs to be initialized by calling refreshSchema() first.");
        }
        return false == this._failedToLoadSchema && false == this._noCurrentSchemaAvailable;
    }

    public String getCurrentSchemaString() {
        return this._currentSchemaString;
    }
}

