/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.FocusEvent;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SessionTabWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.gui.session.SchemaPanel;
import net.sourceforge.squirrel_sql.client.gui.session.SessionColoringUtil;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.ObjectTreePosition;
import net.sourceforge.squirrel_sql.client.session.action.FindColumnsAction;
import net.sourceforge.squirrel_sql.client.session.action.RefreshSchemaInfoAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.fw.gui.ToolBar;
import net.sourceforge.squirrel_sql.fw.gui.statusbar.SessionStatusBar;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ObjectTreeInternalFrame
extends SessionTabWidget
implements IObjectTreeInternalFrame {
    private ObjectTreePanel _objTreePanel;
    private ObjectTreeToolBar _toolBar;
    private SessionStatusBar _sessionStatusBar = new SessionStatusBar();
    private boolean _hasBeenVisible = false;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ObjectTreeInternalFrame.class);

    public ObjectTreeInternalFrame(ISession session) {
        super(session.getTitleModificationAware(), true, true, true, true, session);
        this.setVisible(false);
        this.createGUI(session);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this._hasBeenVisible) {
            this._hasBeenVisible = true;
            this._objTreePanel.refreshTree();
        }
    }

    public ObjectTreePanel getObjectTreePanel() {
        return this._objTreePanel;
    }

    @Override
    public IObjectTreeAPI getObjectTreeAPI() {
        return this._objTreePanel;
    }

    private void createGUI(ISession session) {
        this.setVisible(false);
        IApplication app = session.getApplication();
        ImageIcon icon = app.getResources().getIcon(this.getClass(), "frameIcon");
        if (icon != null) {
            this.setFrameIcon(icon);
        }
        this.addWidgetListener(new WidgetAdapter(){

            @Override
            public void widgetActivated(WidgetEvent evt) {
                Component focusOwner;
                Window window = SwingUtilities.windowForComponent(ObjectTreeInternalFrame.this.getObjectTreePanel());
                Component component = focusOwner = window != null ? window.getFocusOwner() : null;
                if (focusOwner != null) {
                    FocusEvent lost = new FocusEvent(focusOwner, 1005);
                    FocusEvent gained = new FocusEvent(focusOwner, 1004);
                    window.dispatchEvent(lost);
                    window.dispatchEvent(gained);
                    window.dispatchEvent(lost);
                    focusOwner.requestFocus();
                }
            }
        });
        this._objTreePanel = new ObjectTreePanel(this.getSession(), ObjectTreePosition.OBJECT_TREE_INTERNAL_FRAME);
        this._toolBar = new ObjectTreeToolBar(this.getSession(), this._objTreePanel);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)this._toolBar, "North");
        contentPanel.add((Component)this._objTreePanel, "Center");
        this.setContentPane(contentPanel);
        app.getFontInfoStore().setUpStatusBarFont(this._sessionStatusBar);
        contentPanel.add((Component)this._sessionStatusBar, "South");
        this._sessionStatusBar.addJComponent(new SchemaPanel(session));
        SessionColoringUtil.colorStatusbar(session, this._sessionStatusBar);
        this.validate();
    }

    @Override
    public boolean hasSQLPanelAPI() {
        return false;
    }

    private static class ObjectTreeToolBar
    extends ToolBar {
        ObjectTreeToolBar(ISession session, ObjectTreePanel panel) {
            this.createGUI(session, panel);
            SessionColoringUtil.colorToolbar(session, this);
        }

        private void createGUI(ISession session, ObjectTreePanel panel) {
            ActionCollection actions = session.getApplication().getActionCollection();
            this.setUseRolloverButtons(true);
            this.setFloatable(false);
            this.add(actions.get(RefreshSchemaInfoAction.class));
            this.add(actions.get(FindColumnsAction.class));
        }
    }
}

