/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.JScrollPopupMenu;
import net.sourceforge.squirrel_sql.fw.gui.JScrollPopupMenuPosition;
import net.sourceforge.squirrel_sql.fw.gui.buttontabcomponent.SmallTabButton;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SchemaPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SchemaPanel.class);
    private static final ILogger s_log = LoggerController.createLogger(SchemaPanel.class);
    private SmallTabButton _btnRefresh;
    private SmallTabButton _btnChooseSchema;
    private ISession _session;
    private JTextField _txtSchema = new JTextField();

    public SchemaPanel(ISession session) {
        this._session = session;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        JLabel label = new JLabel(s_stringMgr.getString("SchemaPanel.refresh.current.schema.label"));
        this.add((Component)label, gbc);
        JPanel txtSizer = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = SchemaPanel.this._txtSchema.getFont().getSize() * 10;
                return size;
            }
        };
        txtSizer.add(this._txtSchema);
        gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 0, 0), 0, 0);
        this.add((Component)txtSizer, gbc);
        this._txtSchema.setEditable(false);
        this._txtSchema.setMargin(new Insets(0, 0, 0, 0));
        gbc = new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0);
        this._btnRefresh = new SmallTabButton(s_stringMgr.getString("SchemaPanel.refresh.current.schema"), Main.getApplication().getResources().getIcon("smallRefresh"), 4);
        this.add((Component)this._btnRefresh, gbc);
        gbc = new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0);
        this._btnChooseSchema = new SmallTabButton(s_stringMgr.getString("SchemaPanel.refresh.choose.schema"), Main.getApplication().getResources().getIcon("smallChooseSchema"), 4);
        this.add((Component)this._btnChooseSchema, gbc);
        this._btnRefresh.addActionListener(e -> this.onRefreshSchema(true));
        this._btnChooseSchema.addActionListener(e -> this.onChooseSchema());
        this._txtSchema.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SchemaPanel.this.onTxtSchemaClicked(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SchemaPanel.this.onTxtSchemaClicked(e);
            }
        });
        this.onRefreshSchema(false);
    }

    private void onTxtSchemaClicked(MouseEvent me) {
        if (!me.isPopupTrigger()) {
            return;
        }
        JPopupMenu popupTxtSchemas = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(s_stringMgr.getString("SchemaPanel.txtschema.copy"));
        menuItem.addActionListener(e -> this.onCopyTxtSchema());
        popupTxtSchemas.add(menuItem);
        popupTxtSchemas.show(this._txtSchema, me.getX(), me.getY());
    }

    private void onCopyTxtSchema() {
        StringSelection ss = new StringSelection(this._txtSchema.getText());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
    }

    private void onChooseSchema() {
        try {
            JScrollPopupMenu popupSchemas = new JScrollPopupMenu();
            int menuCount = 0;
            popupSchemas.setMaximumVisibleRows(20);
            for (String schema : Main.getApplication().getSessionManager().getAllSchemas(this._session)) {
                if (StringUtilities.isEmpty(schema, true)) continue;
                JMenuItem menuItem = new JMenuItem(schema);
                menuItem.addActionListener(e -> this.onSchemaSelected(menuItem));
                popupSchemas.add(menuItem);
                ++menuCount;
            }
            popupSchemas.positionPopRelativeTo(this._btnChooseSchema, menuCount, JScrollPopupMenuPosition.NORTH_WEST);
        }
        catch (SQLException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void onSchemaSelected(JMenuItem menuItem) {
        this._session.getCurrentSchemaModel().setCurrentSchema(menuItem.getText());
        this.onRefreshSchema(false);
    }

    private void onRefreshSchema(boolean logException) {
        String schema = this._session.getCurrentSchemaModel().refreshSchema(logException);
        this._txtSchema.setText(schema);
        this.invalidate();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (null != this._txtSchema) {
            this._txtSchema.setBackground(bg);
        }
    }
}

