/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session;

import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SessionTabWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.gui.session.SessionPanel;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.session.ISQLInternalFrame;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.filemanager.IFileEditorAPI;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.BaseSQLTab;

public class SessionInternalFrame
extends SessionTabWidget
implements ISQLInternalFrame,
IObjectTreeInternalFrame {
    private final IApplication _app;
    private SessionPanel _sessionPanel;

    public SessionInternalFrame(ISession session) {
        super(session.getTitleModificationAware(), true, true, true, true, session);
        this._app = session.getApplication();
        this.setVisible(false);
        this.createGUI(session);
    }

    public SessionPanel getSessionPanel() {
        return this._sessionPanel;
    }

    @Override
    public ISQLPanelAPI getMainSQLPanelAPI() {
        return this._sessionPanel.getMainSQLPaneAPI();
    }

    public ISQLPanelAPI getSelectedOrMainSQLPanelAPI() {
        return this._sessionPanel.getSelectedOrMainSQLPanelAPI();
    }

    @Override
    public IObjectTreeAPI getObjectTreeAPI() {
        return this._sessionPanel.getObjectTreePanel();
    }

    void addToToolbar(Action action) {
        this._sessionPanel.addToToolbar(action);
    }

    public void addSeparatorToToolbar() {
        this._sessionPanel.addSeparatorToToolbar();
    }

    public void addToToolsPopUp(String selectionString, Action action) {
        this._sessionPanel.addToToolsPopUp(selectionString, action);
    }

    private void createGUI(final ISession session) {
        this.setVisible(false);
        this.setDefaultCloseOperation(0);
        IApplication app = session.getApplication();
        ImageIcon icon = app.getResources().getIcon(this.getClass(), "frameIcon");
        if (icon != null) {
            this.setFrameIcon(icon);
        }
        this.addWidgetListener(new WidgetAdapter(){

            @Override
            public boolean widgetClosing(WidgetEvent evt) {
                return SessionInternalFrame.this.onWindowClosing(session);
            }
        });
        this._sessionPanel = new SessionPanel(session, this.getTitleFileHandler());
        this._sessionPanel.initialize(session);
        this.setContentPane(this._sessionPanel);
        this.validate();
    }

    private boolean onWindowClosing(ISession session) {
        if (!session.isfinishedLoading()) {
            return false;
        }
        ISession mySession = this.getSession();
        if (mySession != null) {
            boolean success = this._app.getSessionManager().closeSession(mySession, true);
            if (success) {
                this._sessionPanel.sessionWindowClosing();
            }
            return success;
        }
        return true;
    }

    public void requestFocus() {
        if (this._sessionPanel.getSelectedMainTab() instanceof BaseSQLTab) {
            SwingUtilities.invokeLater(() -> this.requestFocusOnSqlEditor());
        } else if (0 == this.getSession().getSelectedMainTabIndex()) {
            SwingUtilities.invokeLater(() -> this._sessionPanel.getObjectTreePanel().requestFocus());
        }
    }

    @Override
    public boolean hasSQLPanelAPI() {
        return true;
    }

    @Override
    public void moveToFront() {
        super.moveToFront();
        this.requestFocus();
    }

    private void requestFocusOnSqlEditor() {
        ((BaseSQLTab)this._sessionPanel.getSelectedMainTab()).getSQLPanel().getSQLEntryPanel().requestFocus();
    }

    public IFileEditorAPI getActiveIFileEditorAPIOrNull() {
        return this.getSessionPanel().getActiveIFileEditorAPIOrNull();
    }
}

