/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.session.MainPanel;
import net.sourceforge.squirrel_sql.client.gui.session.SchemaPanel;
import net.sourceforge.squirrel_sql.client.gui.session.SessionColoringUtil;
import net.sourceforge.squirrel_sql.client.gui.session.SessionPanelToolBar;
import net.sourceforge.squirrel_sql.client.gui.session.StatusBarHtml;
import net.sourceforge.squirrel_sql.client.gui.session.ToolbarItem;
import net.sourceforge.squirrel_sql.client.gui.session.rowcolumnlabel.RowColumnLabel;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFilePathHandler;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.connectionpool.SessionConnectionPoolStatusBarCtrl;
import net.sourceforge.squirrel_sql.client.session.filemanager.IFileEditorAPI;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IMainPanelTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.SQLTab;
import net.sourceforge.squirrel_sql.client.session.objecttreesearch.ObjectTreeSearch;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.gui.ClipboardUtil;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.statusbar.SessionStatusBar;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SessionPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SessionPanel.class);
    private final IApplication _app;
    private IIdentifier _sessionId;
    private PropertyChangeListener _propsListener;
    private MainPanel _mainPanel;
    private SessionPanelToolBar _sessionPanelToolBar;
    private ArrayList<ToolbarItem> _externallyAddedToolbarActionsAndSeparators = new ArrayList();
    private SessionStatusBar _sessionStatusBar = new SessionStatusBar();
    private TitleFilePathHandler _titleFileHandler = null;

    public SessionPanel(ISession session, TitleFilePathHandler titleFileHandler) {
        super(new BorderLayout());
        this._titleFileHandler = titleFileHandler;
        this._app = session.getApplication();
        this._sessionId = session.getIdentifier();
        SessionColoringUtil.colorStatusbar(session, this._sessionStatusBar);
        this._sessionStatusBar.setHrefListener((linkDescription, hrefReferenceObject) -> this.onHrefClicked(linkDescription, hrefReferenceObject));
        JMenuItem mnuCopyLast = new JMenuItem(s_stringMgr.getString("SessionPanel.statusbar.rightMouseMenu.copyLast"));
        mnuCopyLast.addActionListener(e -> this.onStatusBarRightMouseMenuCopyLast());
        this._sessionStatusBar.setAdditionalRightMouseMenuItem(mnuCopyLast);
    }

    private void onStatusBarRightMouseMenuCopyLast() {
        TreePath refTreePath = (TreePath)this._sessionStatusBar.getHrefReferenceObject();
        if (null == refTreePath) {
            return;
        }
        ObjectTreeNode node = (ObjectTreeNode)refTreePath.getLastPathComponent();
        ClipboardUtil.copyToClip(node.getDatabaseObjectInfo().getSimpleName(), true);
    }

    private void onHrefClicked(String linkDescription, Object hrefReferenceObject) {
        TreePath treePathForLink = StatusBarHtml.getTreePathForLink(linkDescription, (TreePath)hrefReferenceObject);
        new ObjectTreeSearch().viewInObjectTree(treePathForLink, this.getSession().getObjectTreeAPIOfActiveSessionWindow());
    }

    protected void initialize(ISession session) {
        this.createGUI(session);
        this.propertiesHaveChanged(null);
        this._propsListener = evt -> this.propertiesHaveChanged(evt.getPropertyName());
        this.getObjectTreePanel().addTreeSelectionListener(e -> this.onObjectTreeSelectionChanged(e));
        session.getProperties().addPropertyChangeListener(this._propsListener);
    }

    public void addToToolsPopUp(String selectionString, Action action) {
        this.getMainSQLPaneAPI().addToToolsPopUp(selectionString, action);
    }

    public ISession getSession() {
        return this._app.getSessionManager().getSession(this._sessionId);
    }

    public void sessionHasClosed() {
        ISession session = this.getSession();
        if (session != null) {
            if (this._propsListener != null) {
                session.getProperties().removePropertyChangeListener(this._propsListener);
                this._propsListener = null;
            }
            this._mainPanel.sessionClosing(session);
            this._sessionId = null;
        }
    }

    public void setStatusBarProgress(String msg, int minimum, int maximum, int value) {
        this.setStatusBarProgress(msg, minimum, maximum, value, null);
    }

    public void setStatusBarProgress(String msg, int minimum, int maximum, int value, ActionListener stopAction) {
        GUIUtils.processOnSwingEventThread(() -> this._sessionStatusBar.setStatusBarProgress(msg, minimum, maximum, value, stopAction));
    }

    public void setStatusBarProgressFinished() {
        GUIUtils.processOnSwingEventThread(() -> this._sessionStatusBar.setStatusBarProgressFinished());
    }

    public synchronized void addToToolbar(Action action) {
        this._externallyAddedToolbarActionsAndSeparators.add(new ToolbarItem(action));
        if (null != this._sessionPanelToolBar) {
            this._sessionPanelToolBar.add(action);
        }
    }

    public synchronized void addSeparatorToToolbar() {
        this._externallyAddedToolbarActionsAndSeparators.add(new ToolbarItem());
        if (null != this._sessionPanelToolBar) {
            this._sessionPanelToolBar.addSeparator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propertiesHaveChanged(String propertyName) {
        ISession session = this.getSession();
        SessionProperties props = session.getProperties();
        if (propertyName == null || propertyName.equals("commitOnClosingConnection")) {
            this._app.getThreadPool().addTask(() -> session.getConnectionPool().setSessionCommitOnClose(props.getCommitOnClosingConnection()));
        }
        if (propertyName == null || propertyName.equals("showToolBar")) {
            SessionPanel sessionPanel = this;
            synchronized (sessionPanel) {
                boolean show = props.getShowToolBar();
                if (show != (this._sessionPanelToolBar != null)) {
                    if (show) {
                        if (this._sessionPanelToolBar == null) {
                            this._sessionPanelToolBar = new SessionPanelToolBar(session, this.getObjectTreePanel());
                            for (int i = 0; i < this._externallyAddedToolbarActionsAndSeparators.size(); ++i) {
                                ToolbarItem toolbarItem = this._externallyAddedToolbarActionsAndSeparators.get(i);
                                if (toolbarItem.isSeparator()) {
                                    this._sessionPanelToolBar.addSeparator();
                                    continue;
                                }
                                this._sessionPanelToolBar.add(toolbarItem.getAction());
                            }
                            this.add((Component)this._sessionPanelToolBar, "North");
                        }
                    } else if (this._sessionPanelToolBar != null) {
                        this.remove(this._sessionPanelToolBar);
                        this._sessionPanelToolBar = null;
                    }
                }
            }
        }
    }

    private void createGUI(ISession session) {
        IApplication app = session.getApplication();
        this._mainPanel = new MainPanel(session, this._titleFileHandler);
        this.add((Component)this._mainPanel, "Center");
        app.getFontInfoStore().setUpStatusBarFont(this._sessionStatusBar);
        this.add((Component)this._sessionStatusBar, "South");
        this._sessionStatusBar.addJComponent(new SessionConnectionPoolStatusBarCtrl(session, this._sessionStatusBar).getStatusBarPanel());
        this._sessionStatusBar.addJComponent(new SchemaPanel(session));
        this._sessionStatusBar.addJComponent(new RowColumnLabel(this._mainPanel));
        this.validate();
    }

    public boolean isObjectTreeTabSelected() {
        return 0 == this._mainPanel.getSelectedMainTabIndex();
    }

    public int getTabCount() {
        return this._mainPanel.getMainTabCount();
    }

    public int getMainPanelTabIndex(IMainPanelTab mainPanelTab) {
        return this._mainPanel.getTabIndex(mainPanelTab);
    }

    public String getSelectedCatalogFromCatalogsComboBox() {
        if (null == this._sessionPanelToolBar) {
            return null;
        }
        return this._sessionPanelToolBar.getCatalogsPanelController().getSelectedCatalog();
    }

    public IMainPanelTab getMainPanelTabAt(int tabIndex) {
        return this._mainPanel.getMainPanelTabAt(tabIndex);
    }

    public ISQLPanelAPI getMainSQLPaneAPI() {
        return this._mainPanel.getMainSQLPanel().getSQLPanelAPI();
    }

    public ISQLPanelAPI getSelectedOrMainSQLPanelAPI() {
        return this._mainPanel.getSelectedOrMainSQLPanel().getSQLPanelAPI();
    }

    public ISQLEntryPanel getMainSQLEntryPanel() {
        return this.getMainSQLPanel().getSQLEntryPanel();
    }

    public SQLPanel getMainSQLPanel() {
        return this._mainPanel.getMainSQLPanel();
    }

    public List<SQLPanel> getAllSQLPanels() {
        return this._mainPanel.getAllSQLPanels();
    }

    public List<AdditionalSQLTab> getAdditionalSQLTabs() {
        return this._mainPanel.getAdditionalSQLTabs();
    }

    public SQLPanel getSelectedSQLPanel() {
        return this._mainPanel.getSelectedSQLPanel();
    }

    public SQLPanel getSelectedOrMainSQLPanel() {
        return this._mainPanel.getSelectedOrMainSQLPanel();
    }

    public boolean isAnSQLTabSelected() {
        return this._mainPanel.getSelectedMainTab() instanceof SQLTab || this._mainPanel.getSelectedMainTab() instanceof AdditionalSQLTab;
    }

    public void sessionWindowClosing() {
        this._mainPanel.sessionWindowClosing();
    }

    public ObjectTreePanel getObjectTreePanel() {
        return this._mainPanel.getObjectTreePanel();
    }

    public void selectMainTab(int tabIndex) {
        if (tabIndex >= this._mainPanel.getMainTabCount()) {
            throw new IllegalArgumentException(tabIndex + " is not a valid index into the main tabbed pane.");
        }
        if (this._mainPanel.getSelectedMainTabIndex() != tabIndex) {
            this._mainPanel.selectMainTab(tabIndex);
        }
    }

    public void selectMainTab(IMainPanelTab mainPanelTab) {
        int mainTabIndex = this.getMainPanelTabIndex(mainPanelTab);
        if (-1 == mainTabIndex) {
            throw new IllegalStateException("Couldn't find index for IMainPanelTab: " + mainPanelTab);
        }
        this.selectMainTab(mainTabIndex);
    }

    public int getSelectedMainTabIndex() {
        return this._mainPanel.getSelectedMainTabIndex();
    }

    public IMainPanelTab getSelectedMainTab() {
        return this._mainPanel.getSelectedMainTab();
    }

    public int addMainTab(IMainPanelTab tab) {
        if (tab == null) {
            throw new IllegalArgumentException("IMainPanelTab == null");
        }
        return this._mainPanel.addMainPanelTab(tab);
    }

    public void insertMainTab(IMainPanelTab tab, int idx) {
        this.insertMainTab(tab, idx, true);
    }

    public void insertMainTab(IMainPanelTab tab, int idx, boolean selectInsertedTab) {
        if (tab == null) {
            throw new IllegalArgumentException("Null IMainPanelTab passed");
        }
        if (idx == 1 || idx == 0) {
            throw new IllegalArgumentException("Index " + idx + "conflicts with standard tabs");
        }
        this._mainPanel.insertMainPanelTab(tab, idx, selectInsertedTab);
    }

    public int removeMainTab(IMainPanelTab tab) {
        if (tab == null) {
            throw new IllegalArgumentException("Null IMainPanelTab passed");
        }
        return this._mainPanel.removeMainPanelTab(tab);
    }

    public IFileEditorAPI getActiveIFileEditorAPIOrNull() {
        return this.getSelectedMainTab().getActiveFileEditorAPIOrNull();
    }

    public void performStateChanged() {
        this._mainPanel.performStateChanged();
    }

    public void onObjectTreeSelectionChanged(TreeSelectionEvent evt) {
        TreePath selPath = evt.getNewLeadSelectionPath();
        if (selPath == null) {
            GUIUtils.processOnSwingEventThread(() -> this._sessionStatusBar.clearText());
            return;
        }
        TreePath newBreadCrumbPath = selPath;
        TreePath currentBreadCrumbPath = (TreePath)this._sessionStatusBar.getHrefReferenceObject();
        if (null != currentBreadCrumbPath && currentBreadCrumbPath.getPathCount() > selPath.getPathCount() && selPath.getLastPathComponent() == currentBreadCrumbPath.getPathComponent(selPath.getPathCount() - 1)) {
            newBreadCrumbPath = currentBreadCrumbPath;
        }
        String text = StatusBarHtml.createStatusBarHtml(newBreadCrumbPath);
        TreePath finalNewBreadCrumbPath = newBreadCrumbPath;
        GUIUtils.processOnSwingEventThread(() -> this._sessionStatusBar.setText(text, finalNewBreadCrumbPath));
    }
}

