/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session.catalogspanel;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collections;
import javax.swing.DefaultListModel;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.session.catalogspanel.AdditionalCatalogsDlg;
import net.sourceforge.squirrel_sql.client.gui.session.catalogspanel.AliasCatalogLoadModelJsonBean;
import net.sourceforge.squirrel_sql.client.gui.session.catalogspanel.CatalogChecked;
import net.sourceforge.squirrel_sql.client.gui.session.catalogspanel.CheckListRenderer;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import org.apache.commons.lang3.StringUtils;

public class AdditionalCatalogsController {
    private final AdditionalCatalogsDlg _dlg;
    private boolean _ok;

    public AdditionalCatalogsController(ISession session) {
        try {
            this._dlg = new AdditionalCatalogsDlg(GUIUtils.getOwningWindow(session.getSessionPanel()));
            String[] catalogs = session.getSQLConnection().getSQLMetaData().getCatalogs();
            AliasCatalogLoadModelJsonBean bean = Main.getApplication().getCatalogLoadModelManager().getAliasCatalogLoadModelJsonBean(session.getAlias());
            DefaultListModel<CatalogChecked> listModel = new DefaultListModel<CatalogChecked>();
            for (String catalog : catalogs) {
                listModel.addElement(AdditionalCatalogsController.createCatalogChecked(catalog, bean));
            }
            this._dlg.chkLstCatalogs.setModel(listModel);
            this._dlg.chkLstCatalogs.setCellRenderer(new CheckListRenderer());
            this._dlg.chkLstCatalogs.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    AdditionalCatalogsController.this.onMouseClicked(event);
                }
            });
            this._dlg.btnSelectAll.addActionListener(e -> this.onSelectAll());
            this._dlg.btnInvertSelection.addActionListener(e -> this.onInvertSelection());
            this._dlg.btnOk.addActionListener(e -> this.onOk(session));
            GUIUtils.initLocation(this._dlg, 400, 600);
            GUIUtils.enableCloseByEscape(this._dlg);
            this._dlg.setVisible(true);
        }
        catch (SQLException e2) {
            throw Utilities.wrapRuntime(e2);
        }
    }

    private void onInvertSelection() {
        for (int i = 0; i < this._dlg.chkLstCatalogs.getModel().getSize(); ++i) {
            CatalogChecked catalogChecked;
            catalogChecked.setChecked(!(catalogChecked = this._dlg.chkLstCatalogs.getModel().getElementAt(i)).isChecked());
        }
        this._dlg.chkLstCatalogs.repaint();
    }

    private void onSelectAll() {
        for (int i = 0; i < this._dlg.chkLstCatalogs.getModel().getSize(); ++i) {
            this._dlg.chkLstCatalogs.getModel().getElementAt(i).setChecked(true);
        }
        this._dlg.chkLstCatalogs.repaint();
    }

    private void onMouseClicked(MouseEvent event) {
        int index = this._dlg.chkLstCatalogs.locationToIndex(event.getPoint());
        if (index >= 0 && index < this._dlg.chkLstCatalogs.getModel().getSize() && this._dlg.chkLstCatalogs.getCellBounds(index, index).contains(event.getPoint())) {
            CatalogChecked catalogChecked;
            catalogChecked.setChecked(!(catalogChecked = this._dlg.chkLstCatalogs.getModel().getElementAt(index)).isChecked());
            this._dlg.chkLstCatalogs.repaint(this._dlg.chkLstCatalogs.getCellBounds(index, index));
        }
    }

    public boolean isOk() {
        return this._ok;
    }

    private void onOk(ISession session) {
        AliasCatalogLoadModelJsonBean bean = Main.getApplication().getCatalogLoadModelManager().getAliasCatalogLoadModelJsonBean(session.getAlias());
        bean.getAdditionalUserChosenCatalogs().clear();
        for (CatalogChecked catalogChecked : Collections.list(((DefaultListModel)this._dlg.chkLstCatalogs.getModel()).elements())) {
            if (!catalogChecked.isChecked()) continue;
            bean.getAdditionalUserChosenCatalogs().add(catalogChecked.getCatalog());
        }
        this._ok = true;
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private static CatalogChecked createCatalogChecked(String catalog, AliasCatalogLoadModelJsonBean bean) {
        boolean checked = bean.getAdditionalUserChosenCatalogs().stream().anyMatch(c -> StringUtils.equalsIgnoreCase((CharSequence)c, (CharSequence)catalog));
        return new CatalogChecked(catalog, checked);
    }
}

