/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session.catalogspanel;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.gui.session.catalogspanel.AliasCatalogLoadModelJsonBean;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class AliasCatalogLoadModel {
    private static final ILogger s_log = LoggerController.createLogger(AliasCatalogLoadModel.class);
    private List<String> _catalogNamesToLoad;
    private AliasCatalogLoadModelJsonBean _modelJson;
    private String _catalogRepresentingDefaultLoad;

    private AliasCatalogLoadModel() {
    }

    public AliasCatalogLoadModel(AliasCatalogLoadModelJsonBean modelJson, ISession session) {
        try {
            if (!session.getMetaData().supportsCatalogs()) {
                this._catalogNamesToLoad = new ArrayList<String>();
                this._catalogNamesToLoad.add(null);
                return;
            }
            this._modelJson = modelJson;
            this._catalogRepresentingDefaultLoad = null;
            if (DialectFactory.isMSSQLServer(session.getMetaData())) {
                try {
                    this._catalogRepresentingDefaultLoad = session.getSQLConnection().getCatalog();
                }
                catch (Exception e) {
                    s_log.error("Error getting the current catalog from MSSQL-Server to workaround Sourceforge bug #1508.", e);
                }
            }
            this._catalogNamesToLoad = new ArrayList<String>();
            this._catalogNamesToLoad.add(this._catalogRepresentingDefaultLoad);
            for (String catalog : this._modelJson.getAdditionalUserChosenCatalogs()) {
                if (this._catalogNamesToLoad.contains(catalog)) continue;
                this._catalogNamesToLoad.add(catalog);
            }
            if (this._catalogNamesToLoad.contains(null) && null != session.getSQLConnection().getCatalog()) {
                this._catalogNamesToLoad.remove(session.getSQLConnection().getCatalog());
            }
        }
        catch (SQLException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    public List<String> getCatalogStringsToLoad() {
        return this._catalogNamesToLoad;
    }

    public static AliasCatalogLoadModel of(String catalogName) {
        AliasCatalogLoadModel ret = new AliasCatalogLoadModel();
        ret._catalogNamesToLoad = new ArrayList<String>();
        ret._catalogNamesToLoad.add(catalogName);
        return ret;
    }
}

