/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session.catalogspanel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class CatalogsPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CatalogsPanel.class);
    JLabel lblCatalogs;
    JComboBox catalogsCmb;
    JButton btnConfiCatalogLoading;

    public CatalogsPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0);
        this.lblCatalogs = new JLabel(s_stringMgr.getString("CatalogsPanel.catalog"));
        this.add((Component)this.lblCatalogs, gbc);
        this.catalogsCmb = new JComboBox();
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 2), 0, 0);
        this.add((Component)this.catalogsCmb, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0);
        this.btnConfiCatalogLoading = GUIUtils.styleAsToolbarButton(new JButton(Main.getApplication().getResources().getIcon("threedots")));
        Dimension configButtonSize = new Dimension(this.catalogsCmb.getPreferredSize().height + 1, this.catalogsCmb.getPreferredSize().height + 1);
        this.btnConfiCatalogLoading.setPreferredSize(configButtonSize);
        this.btnConfiCatalogLoading.setToolTipText(s_stringMgr.getString("CatalogsPanel.configure.catalogs.to.load"));
        this.add((Component)this.btnConfiCatalogLoading, gbc);
    }

    public void initSizeAndBackgroundAfterCatalogsComboFilled() {
        int preferredWidth = this.lblCatalogs.getPreferredSize().width + this.catalogsCmb.getPreferredSize().width + this.btnConfiCatalogLoading.getPreferredSize().width + 20;
        GUIUtils.setPreferredWidth(this, preferredWidth);
        GUIUtils.setMinimumWidth(this, preferredWidth);
        GUIUtils.setMaximumWidth(this, preferredWidth);
        GUIUtils.inheritBackground(this);
    }

    public void setHasAdditionalCatalogs(boolean hasAdditionalCatalogs) {
        if (hasAdditionalCatalogs) {
            this.btnConfiCatalogLoading.setIcon(Main.getApplication().getResources().getIcon("threedots_checked"));
        } else {
            this.btnConfiCatalogLoading.setIcon(Main.getApplication().getResources().getIcon("threedots"));
        }
    }
}

