/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session.catalogspanel;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.session.catalogspanel.AdditionalCatalogsController;
import net.sourceforge.squirrel_sql.client.gui.session.catalogspanel.CatalogsPanel;
import net.sourceforge.squirrel_sql.client.gui.session.catalogspanel.NoCatalogPlaceHolder;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.treefinder.ObjectTreeFinderGoToNextResultHandle;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.treefinder.ObjectTreeSearchResultFuture;
import net.sourceforge.squirrel_sql.client.session.schemainfo.FilterMatcher;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.apache.commons.lang3.StringUtils;

public class CatalogsPanelController {
    private static final ILogger s_log = LoggerController.createLogger(CatalogsPanelController.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CatalogsPanelController.class);
    private final JComponent _parentComponent;
    private ISession _session;
    private CatalogsPanel _catalogsPanel;
    private PropertyChangeListener _connectionPropetryListener;
    private ActionListener _catalogsComboListener;

    public CatalogsPanelController(ISession session, JComponent parentComponent) {
        this._session = session;
        this._parentComponent = parentComponent;
        this._catalogsPanel = new CatalogsPanel();
        this.updateAdditionalCatalogsIcon();
        this._catalogsComboListener = e -> this.onCatalogSelected();
        this._connectionPropetryListener = evt -> GUIUtils.processOnSwingEventThread(() -> this.onConnectionPropertyChanged(evt));
        this.init();
    }

    private void updateAdditionalCatalogsIcon() {
        boolean hasAdditionalCatalogs = !Main.getApplication().getCatalogLoadModelManager().getAliasCatalogLoadModelJsonBean(this._session.getAlias()).getAdditionalUserChosenCatalogs().isEmpty();
        this._catalogsPanel.setHasAdditionalCatalogs(hasAdditionalCatalogs);
    }

    private void init() {
        try {
            this._catalogsPanel.setVisible(false);
            this._catalogsPanel.catalogsCmb.removeActionListener(this._catalogsComboListener);
            this._session.getSQLConnection().removePropertyChangeListener(this._connectionPropetryListener);
            if (!this._session.getSQLConnection().getSQLMetaData().supportsCatalogs()) {
                return;
            }
            String[] catalogs = this._session.getSQLConnection().getSQLMetaData().getCatalogs();
            if (null == catalogs || 0 == catalogs.length) {
                return;
            }
            String selected = this._session.getSQLConnection().getCatalog();
            this.setCatalogs(catalogs, selected);
            this._catalogsPanel.catalogsCmb.addActionListener(this._catalogsComboListener);
            this._catalogsPanel.btnConfiCatalogLoading.addActionListener(e -> this.onConfigureCatalogLoading());
            this._catalogsPanel.initSizeAndBackgroundAfterCatalogsComboFilled();
            this._catalogsPanel.setVisible(true);
            this._parentComponent.validate();
            this._session.getSQLConnection().addPropertyChangeListener(this._connectionPropetryListener);
        }
        catch (SQLException e2) {
            throw Utilities.wrapRuntime(e2);
        }
    }

    private void onConfigureCatalogLoading() {
        if (new AdditionalCatalogsController(this._session).isOk()) {
            this.updateAdditionalCatalogsIcon();
            this.refreshSchemaAndTree();
        }
    }

    private void onConnectionPropertyChanged(PropertyChangeEvent evt) {
        try {
            ISQLConnection conn;
            String propName = evt.getPropertyName();
            if ((propName == null || propName.equals("catalog")) && !StringUtils.equals((CharSequence)(conn = this._session.getSQLConnection()).getCatalog(), (CharSequence)this.getSelectedCatalog())) {
                this.setSelectedCatalog(conn.getCatalog());
            }
        }
        catch (SQLException e) {
            s_log.error("Error processing Property ChangeEvent", e);
        }
    }

    public void onCatalogSelected() {
        String selectedCatalog = this.getSelectedCatalog();
        if (selectedCatalog != null) {
            try {
                this._session.getConnectionPool().setSessionCatalog(selectedCatalog);
                this.refreshSchemaAndTree();
            }
            catch (Exception ex) {
                this._session.showErrorMessage(ex);
                this.refreshCatalogs();
            }
        }
    }

    private void refreshSchemaAndTree() {
        String selectedCatalog = this.getSelectedCatalog();
        IObjectTreeAPI api = this._session.getObjectTreeAPIOfActiveSessionWindow();
        api.refreshTree(true);
        String schema = null;
        if (DialectFactory.isMSSQLServer(this._session.getSQLConnection().getSQLMetaData())) {
            schema = "dbo";
        }
        ObjectTreeSearchResultFuture resultFuture = api.selectInObjectTree(selectedCatalog, schema, new FilterMatcher("TABLE", null), ObjectTreeFinderGoToNextResultHandle.DONT_GO_TO_NEXT_RESULT_HANDLE);
        resultFuture.addFinishedListenerOrdered(tn -> this.onFindFinished(tn, api));
    }

    private void onFindFinished(TreePath tn, IObjectTreeAPI api) {
        ObjectTreeNode[] nodes;
        if (tn != null && (nodes = api.getSelectedNodes()).length > 0) {
            ObjectTreeNode tableNode = nodes[0];
            api.expandNode(tableNode);
        }
    }

    public void setCatalogs(String[] catalogs, String selectedCatalog) {
        this._catalogsPanel.catalogsCmb.removeAllItems();
        if (catalogs != null) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            for (String catalog : catalogs) {
                if (StringUtilities.isEmpty(catalog)) continue;
                map.put(catalog, catalog);
            }
            if (StringUtilities.isEmpty(selectedCatalog)) {
                this._catalogsPanel.catalogsCmb.addItem(NoCatalogPlaceHolder.s_instance);
            }
            for (String catalog : map.values()) {
                this._catalogsPanel.catalogsCmb.addItem(catalog);
            }
            if (!StringUtilities.isEmpty(selectedCatalog)) {
                this.setSelectedCatalog(selectedCatalog);
            }
        }
    }

    public void setSelectedCatalog(String selectedCatalog) {
        if (selectedCatalog != null) {
            this._catalogsPanel.catalogsCmb.getModel().setSelectedItem(selectedCatalog);
        }
    }

    private void refreshCatalogs() {
        this.init();
    }

    public String getSelectedCatalog() {
        if (null == this._catalogsPanel.catalogsCmb || !(this._catalogsPanel.catalogsCmb.getSelectedItem() instanceof String)) {
            return null;
        }
        return (String)this._catalogsPanel.catalogsCmb.getSelectedItem();
    }

    public CatalogsPanel getPanel() {
        return this._catalogsPanel;
    }
}

