/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.titlefilepath;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFileCheckBoxesInitializer;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFilePathHandlerListener;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionUtil;
import net.sourceforge.squirrel_sql.fw.gui.buttontabcomponent.SmallTabButton;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.DesktopUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class TitleFilePathHandler {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TitleFilePathHandler.class);
    public static final String PREF_KEY_TITLE_FILE_PATH_HANDLER_SHOW_FILE_NAME = "Squirrel.TitleFilePathHandler.showFileName";
    public static final String PREF_KEY_TITLE_FILE_PATH_HANDLER_SHOW_PATH_NAME = "Squirrel.TitleFilePathHandler.showPathName";
    public static final String PREF_KEY_TITLE_FILE_PATH_HANDLER_SHOW_INTERNALLY_SAVED_SESSION_FILE_NAME = "Squirrel.TitleFilePathHandler.showInternallySavedSessionFileName";
    public static final String PREF_KEY_TITLE_FILE_PATH_HANDLER_SHOW_INTERNALLY_SAVED_SESSION_PATH_NAME = "Squirrel.TitleFilePathHandler.showInternallySavedSessionPathName";
    private File _sqlFile;
    private TitleFilePathHandlerListener _titleFilePathHandlerListener;
    private SmallTabButton _smallTabButton;
    private JCheckBoxMenuItem _chkMnuShowFileName;
    private JCheckBoxMenuItem _chkMnuShowFilePath;
    private TitleFileCheckBoxesInitializer _titleFileCheckBoxesInitializer = new TitleFileCheckBoxesInitializer();

    public TitleFilePathHandler(TitleFilePathHandlerListener titleFilePathHandlerListener) {
        SquirrelResources resources = Main.getApplication().getResources();
        this._titleFilePathHandlerListener = titleFilePathHandlerListener;
        String msg = s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.tooltip");
        this._smallTabButton = new SmallTabButton(msg, resources.getIcon("smallFile"));
        this._smallTabButton.addActionListener(e -> this.showPopup());
        this._chkMnuShowFileName = new JCheckBoxMenuItem();
        this._chkMnuShowFilePath = new JCheckBoxMenuItem();
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu popUp = new JPopupMenu();
        JMenuItem mnuOpenFilePath = SavedSessionUtil.isInSavedSessionsDir(this._sqlFile) ? new JMenuItem(s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.openInternallySavedSessionFilePath")) : new JMenuItem(s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.openFilePath"));
        popUp.add(mnuOpenFilePath);
        mnuOpenFilePath.addActionListener(e -> this.onOpenFilePath());
        JMenuItem mnuCopyFilePath = SavedSessionUtil.isInSavedSessionsDir(this._sqlFile) ? new JMenuItem(s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.copyInternallySavedSessionFilePath")) : new JMenuItem(s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.copyFilePath"));
        popUp.add(mnuCopyFilePath);
        mnuCopyFilePath.addActionListener(e -> this.onCopyFilePath());
        JMenuItem mnuCopyFileName = SavedSessionUtil.isInSavedSessionsDir(this._sqlFile) ? new JMenuItem(s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.copyInternallySavedSessionFileName")) : new JMenuItem(s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.copyFileName"));
        popUp.add(mnuCopyFileName);
        mnuCopyFileName.addActionListener(e -> this.onCopyFileName());
        popUp.addSeparator();
        if (SavedSessionUtil.isInSavedSessionsDir(this._sqlFile)) {
            this._chkMnuShowFileName.setText(s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.showInternallySavedSessionFileName"));
        } else {
            this._chkMnuShowFileName.setText(s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.showFileName"));
        }
        popUp.add(this._chkMnuShowFileName);
        this._chkMnuShowFileName.addActionListener(e -> this.onChkMnuShowFileName());
        if (SavedSessionUtil.isInSavedSessionsDir(this._sqlFile)) {
            this._chkMnuShowFilePath.setText(s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.showInternallySavedSessionFilePath"));
        } else {
            this._chkMnuShowFilePath.setText(s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.showFilePath"));
        }
        popUp.add(this._chkMnuShowFilePath);
        this._chkMnuShowFilePath.addActionListener(e -> this.onChkMnuShowFilePath());
        JMenuItem mnuRememberCheckboxes = new JMenuItem(s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.rememberCheckBoxes"));
        popUp.add(mnuRememberCheckboxes);
        mnuRememberCheckboxes.addActionListener(e -> this.onRememberCheckboxes());
        return popUp;
    }

    private void onRememberCheckboxes() {
        if (SavedSessionUtil.isInSavedSessionsDir(this._sqlFile)) {
            Props.putBoolean(PREF_KEY_TITLE_FILE_PATH_HANDLER_SHOW_INTERNALLY_SAVED_SESSION_FILE_NAME, this._chkMnuShowFileName.isSelected());
            Props.putBoolean(PREF_KEY_TITLE_FILE_PATH_HANDLER_SHOW_INTERNALLY_SAVED_SESSION_PATH_NAME, this._chkMnuShowFilePath.isSelected());
        } else {
            Props.putBoolean(PREF_KEY_TITLE_FILE_PATH_HANDLER_SHOW_FILE_NAME, this._chkMnuShowFileName.isSelected());
            Props.putBoolean(PREF_KEY_TITLE_FILE_PATH_HANDLER_SHOW_PATH_NAME, this._chkMnuShowFilePath.isSelected());
        }
    }

    private void onChkMnuShowFilePath() {
        this._chkMnuShowFileName.setSelected(false);
        this._titleFilePathHandlerListener.refreshFileDisplay();
    }

    private void onChkMnuShowFileName() {
        this._chkMnuShowFilePath.setSelected(false);
        this._titleFilePathHandlerListener.refreshFileDisplay();
    }

    private void onCopyFilePath() {
        this._onCopyFile(true);
    }

    private void onCopyFileName() {
        this._onCopyFile(false);
    }

    private void _onCopyFile(boolean fullPath) {
        if (this.hasFile()) {
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection data = fullPath ? new StringSelection(this._sqlFile.getAbsolutePath()) : new StringSelection(this._sqlFile.getName());
            clip.setContents(data, data);
        }
    }

    private void onOpenFilePath() {
        if (this.hasFile()) {
            DesktopUtil.openInFileManager(this._sqlFile);
        }
    }

    private void showPopup() {
        this.createPopupMenu().show(this._smallTabButton, 0, 0);
    }

    public void setSqlFile(File sqlFile) {
        this._sqlFile = sqlFile;
        if (null == this._sqlFile) {
            this._smallTabButton.setIcon(null);
            this._smallTabButton.setToolTipText("");
        } else if (SavedSessionUtil.isInSavedSessionsDir(this._sqlFile)) {
            this._smallTabButton.setToolTipText(s_stringMgr.getString("TitleFilePathHandler.internallySavedFile", this._sqlFile.getAbsolutePath()));
        } else {
            this._smallTabButton.setToolTipText(this._sqlFile.getAbsolutePath());
        }
        this._titleFileCheckBoxesInitializer.init(this._chkMnuShowFileName, this._chkMnuShowFilePath, this._sqlFile);
        this._titleFilePathHandlerListener.refreshFileDisplay();
    }

    public boolean hasFile() {
        return null != this._sqlFile;
    }

    public String getSqlFile() {
        if (this._chkMnuShowFilePath.isSelected()) {
            return "  " + s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.pathDisplayPrefix", this._sqlFile.getAbsolutePath());
        }
        if (this._chkMnuShowFileName.isSelected()) {
            return "  " + s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.fileDisplayPrefix", this._sqlFile.getName());
        }
        return "";
    }

    public SmallTabButton getFileMenuSmallButton() {
        return this._smallTabButton;
    }

    public void setUnsavedEdits(boolean unsavedEdits) {
        if (unsavedEdits) {
            if (SavedSessionUtil.isInSavedSessionsDir(this._sqlFile)) {
                this._smallTabButton.setIcon(Main.getApplication().getResources().getIcon("smallFileInternalChanged"));
            } else {
                this._smallTabButton.setIcon(Main.getApplication().getResources().getIcon("smallFileChanged"));
            }
        } else if (SavedSessionUtil.isInSavedSessionsDir(this._sqlFile)) {
            this._smallTabButton.setIcon(Main.getApplication().getResources().getIcon("smallFileInternal"));
        } else {
            this._smallTabButton.setIcon(Main.getApplication().getResources().getIcon("smallFile"));
        }
    }
}

