/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action;

import java.awt.event.ActionEvent;
import java.io.File;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.gui.db.IAliasesList;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.recentfiles.RecentFilesController;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SessionStartupMainSQLTabContentLoader;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class AliasFileOpenAction
extends SquirrelAction {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AliasFileOpenAction.class);
    private IAliasesList _aliasList;

    public AliasFileOpenAction(IApplication app, IAliasesList al) {
        super(app);
        this._aliasList = al;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SQLAlias selectedAlias = this._aliasList.getSelectedAlias(null);
        if (null == selectedAlias) {
            this.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("AliasFileOpenAction.noAliasSelected"));
            return;
        }
        File fileToOpen = new RecentFilesController(this.getApplication(), selectedAlias).getFileToOpen();
        if (null == fileToOpen) {
            return;
        }
        SessionStartupMainSQLTabContentLoader.startSessionWithFile(selectedAlias, fileToOpen);
    }
}

