/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action;

import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.ConnectCompletionCallback;
import net.sourceforge.squirrel_sql.client.gui.db.ConnectToAliasCallBack;
import net.sourceforge.squirrel_sql.client.gui.db.ConnectionInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ConnectToAliasCommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ConnectToAliasCommand.class);
    private static final ILogger s_log = LoggerController.createLogger(ConnectToAliasCommand.class);
    private SQLAlias _sqlAlias;
    private boolean _createSession;
    private ConnectCompletionCallback _callback;

    public ConnectToAliasCommand(SQLAlias sqlAlias) {
        this(sqlAlias, true, null);
    }

    public ConnectToAliasCommand(SQLAlias sqlAlias, boolean createSession, ConnectCompletionCallback callback) {
        if (sqlAlias == null) {
            throw new IllegalArgumentException("Null SQLAlias passed");
        }
        this._sqlAlias = sqlAlias;
        this._createSession = createSession;
        this._callback = callback != null ? callback : new ConnectToAliasCallBack(this._sqlAlias);
    }

    public void executeConnect() {
        try {
            if (this._createSession) {
                Main.getApplication().getWindowManager().getRecentAliasesListCtrl().startingCreateSession(this._sqlAlias);
            }
            GUIUtils.processOnSwingEventThread(() -> this.createConnectionInternalFrame());
        }
        catch (Exception ex) {
            Main.getApplication().showErrorDialog(ex);
        }
    }

    private void createConnectionInternalFrame() {
        ConnectionInternalFrame sheet = new ConnectionInternalFrame(this._sqlAlias, this._createSession, this._callback);
        Main.getApplication().getMainFrame().addWidget(sheet);
        DialogWidget.centerWithinDesktop(sheet);
        sheet.moveToFront();
    }
}

