/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action;

import java.awt.Frame;
import java.util.Iterator;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.AliasesAndDriversManager;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.fw.gui.Dialogs;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DeleteDriverCommand
implements ICommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DeleteDriverCommand.class);
    private final IApplication _app;
    private Frame _frame;
    private ISQLDriver _sqlDriver;

    public DeleteDriverCommand(IApplication app, Frame frame, ISQLDriver sqlDriver) {
        if (sqlDriver == null) {
            throw new IllegalArgumentException("Null ISQLDriver passed");
        }
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        this._app = app;
        this._frame = frame;
        this._sqlDriver = sqlDriver;
    }

    @Override
    public void execute() {
        Object[] args = new Object[]{this._sqlDriver.getName()};
        AliasesAndDriversManager cache = this._app.getAliasesAndDriversManager();
        Iterator<SQLAlias> it = cache.getAliasesForDriver(this._sqlDriver);
        if (it.hasNext()) {
            StringBuffer aliasList = new StringBuffer();
            while (it.hasNext()) {
                SQLAlias alias = it.next();
                aliasList.append("\n");
                aliasList.append(alias.getName());
            }
            Object[] args2 = new Object[]{this._sqlDriver.getName(), aliasList};
            String msg = s_stringMgr.getString("DeleteDriverCommand.used", args2);
            Dialogs.showOk(this._frame, msg);
        } else if (Dialogs.showYesNo(this._frame, s_stringMgr.getString("DeleteDriverCommand.comfirm", args))) {
            cache.removeDriver(this._sqlDriver);
        }
    }
}

