/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action;

import java.io.IOException;
import java.net.URL;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.AliasesAndDriversManager;
import net.sourceforge.squirrel_sql.client.mainframe.action.ShowLoadedDriversOnlyCommand;
import net.sourceforge.squirrel_sql.fw.util.BaseException;
import net.sourceforge.squirrel_sql.fw.util.ICommand;

public class InstallDefaultDriversCommand
implements ICommand {
    private final IApplication _app;
    private final URL _url;

    public InstallDefaultDriversCommand(IApplication app, URL url) {
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        if (url == null) {
            throw new IllegalArgumentException("URL == null");
        }
        this._app = app;
        this._url = url;
    }

    @Override
    public void execute() throws BaseException {
        try {
            AliasesAndDriversManager aliasesAndDriversManager = this._app.getAliasesAndDriversManager();
            aliasesAndDriversManager.loadDefaultDrivers(this._url);
            new ShowLoadedDriversOnlyCommand(this._app, false).execute();
            Main.getApplication().getWindowManager().getDriversListInternalFrame().updateDriverList(aliasesAndDriversManager.getDriverList());
        }
        catch (IOException ex) {
            throw new BaseException(ex);
        }
    }
}

