/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action.findaliases;

import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.squirrel_sql.client.gui.db.AliasFolder;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class AliasSearchWrapper {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AliasSearchWrapper.class);
    private SQLAlias _alias;
    private AliasFolder _aliasFolder;

    public AliasSearchWrapper(SQLAlias alias) {
        this._alias = alias;
    }

    public AliasSearchWrapper(AliasFolder aliasFolder) {
        this._aliasFolder = aliasFolder;
    }

    public SQLAlias getAlias() {
        return this._alias;
    }

    public AliasFolder getAliasFolder() {
        return this._aliasFolder;
    }

    public String getName() {
        if (null != this._alias) {
            return this._alias.getName();
        }
        return this._aliasFolder.getFolderName();
    }

    public static List<AliasSearchWrapper> wrapAliases(List<? extends SQLAlias> aliasList) {
        return aliasList.stream().map(a -> new AliasSearchWrapper((SQLAlias)a)).collect(Collectors.toList());
    }

    public static List<AliasSearchWrapper> wrapAliasFolders(List<AliasFolder> aliasFolders) {
        return aliasFolders.stream().map(f -> new AliasSearchWrapper((AliasFolder)f)).collect(Collectors.toList());
    }

    public String getSearchListDisplayString() {
        if (null != this._alias) {
            return this._alias.getName() + "\n  URL: " + this._alias.getUrl() + "\n  User: " + this._alias.getUserName() + "\n";
        }
        return s_stringMgr.getString("AliasSearchWrapper.aliasFolder", this._aliasFolder.getFolderName());
    }

    public int getColorRGB() {
        if (null != this._alias) {
            SQLAlias sqlAlias = this._alias;
            if (sqlAlias.getColorProperties().isOverrideAliasBackgroundColor()) {
                return sqlAlias.getColorProperties().getAliasBackgroundColorRgbValue();
            }
            return -1;
        }
        return this._aliasFolder.getColorRGB();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasSearchWrapper other = (AliasSearchWrapper)o;
        if (other._alias != null && this._alias != null) {
            return other._alias.equals(this._alias);
        }
        if (other._aliasFolder != null && this._aliasFolder != null) {
            return other._aliasFolder.equals(this._aliasFolder);
        }
        return false;
    }

    public int hashCode() {
        if (null != this._alias) {
            return this._alias.hashCode();
        }
        return this._aliasFolder.hashCode();
    }
}

