/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action.findaliases;

import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.AliasFolder;
import net.sourceforge.squirrel_sql.client.gui.db.AliasWindowManager;
import net.sourceforge.squirrel_sql.client.gui.db.ConnectToAliasCallBack;
import net.sourceforge.squirrel_sql.client.gui.db.IAliasesList;
import net.sourceforge.squirrel_sql.client.mainframe.action.ConnectToAliasCommand;
import net.sourceforge.squirrel_sql.client.mainframe.action.FindAliasListCellRenderer;
import net.sourceforge.squirrel_sql.client.mainframe.action.findaliases.AliasSearchWrapper;
import net.sourceforge.squirrel_sql.client.mainframe.action.findaliases.AliasesUtil;
import net.sourceforge.squirrel_sql.client.mainframe.action.findaliases.FindAliasesDialog;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class FindAliasesCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FindAliasesCtrl.class);
    public static final String PREF_KEY_FIND_ALIAS_SHEET_WIDTH = "Squirrel.findAliasSheet.width";
    public static final String PREF_KEY_FIND_ALIAS_SHEET_HEIGHT = "Squirrel.findAliasSheet.height";
    public static final String PREF_KEY_FIND_ALIAS_CHECK_LEAVE_OPEN = "Squirrel.findAliasSheet.check.leave.open";
    public static final String PREF_KEY_FIND_ALIAS_REMEMBER_LAST_SEARCH = "Squirrel.findAliasSheet.remember.last.search";
    public static final String PREF_KEY_FIND_ALIAS_INCLUDE_ALIAS_FOLDERS = "Squirrel.findAliasSheet.include.alias.folders";
    public static final String PREF_KEY_FIND_ALIAS_LAST_SEARCH_STRING = "Squirrel.findAliasSheet.last.search.string";
    private FindAliasesDialog _dlg = new FindAliasesDialog();
    private IAliasesList _aliasesList;

    public FindAliasesCtrl(IAliasesList aliasesList) {
        this._aliasesList = aliasesList;
        this._dlg.setSize(this.getDimension());
        GUIUtils.centerWithinParent(this._dlg);
        GUIUtils.enableCloseByEscape(this._dlg, dialog -> this.onClosing());
        this._dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FindAliasesCtrl.this.onClosing();
            }
        });
        this._dlg.lstResult.setCellRenderer(new FindAliasListCellRenderer());
        this._dlg.lstResult.setFocusable(false);
        this._dlg.lstResult.setSelectionMode(0);
        this._dlg.lstResult.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FindAliasesCtrl.this.onListClicked(e);
            }
        });
        this._dlg.chkLeaveOpen.setFocusable(false);
        this._dlg.chkLeaveOpen.setSelected(Props.getBoolean(PREF_KEY_FIND_ALIAS_CHECK_LEAVE_OPEN, false));
        this._dlg.btnConnect.addActionListener(e -> this.onConnect());
        this._dlg.btnModify.addActionListener(e -> this.onModify());
        this._dlg.btnGoto.addActionListener(e -> this.onGoto());
        this._dlg.btnClose.addActionListener(e -> this.onClose());
        this._dlg.txtToSearch.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FindAliasesCtrl.this.updateList();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FindAliasesCtrl.this.updateList();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FindAliasesCtrl.this.updateList();
            }
        });
        this._dlg.chkRememberLastSearch.setFocusable(false);
        this._dlg.chkRememberLastSearch.setSelected(Props.getBoolean(PREF_KEY_FIND_ALIAS_REMEMBER_LAST_SEARCH, false));
        this._dlg.chkIncludeAliasFolders.setFocusable(false);
        this._dlg.chkIncludeAliasFolders.setSelected(Props.getBoolean(PREF_KEY_FIND_ALIAS_INCLUDE_ALIAS_FOLDERS, false));
        this._dlg.chkIncludeAliasFolders.addActionListener(e -> this.updateList());
        if (this._dlg.chkRememberLastSearch.isSelected()) {
            String lastSearchString = Props.getString(PREF_KEY_FIND_ALIAS_LAST_SEARCH_STRING, null);
            this._dlg.txtToSearch.setText(lastSearchString);
            if (null != lastSearchString) {
                this._dlg.txtToSearch.selectAll();
            }
        }
        this._dlg.txtToSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                FindAliasesCtrl.this.onKeyPressed(e);
            }
        });
        SwingUtilities.invokeLater(() -> this._dlg.txtToSearch.requestFocus());
        this._dlg.getRootPane().setDefaultButton(this._dlg.btnConnect);
        this.updateList();
        this._dlg.setVisible(true);
    }

    private void onClose() {
        this.onClosing();
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private void onKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            int selIx = this._dlg.lstResult.getSelectedIndex();
            if (0 < selIx) {
                this._dlg.lstResult.setSelectedIndex(selIx - 1);
                this._dlg.lstResult.ensureIndexIsVisible(selIx - 1);
            }
        } else if (e.getKeyCode() == 40) {
            int selIx = this._dlg.lstResult.getSelectedIndex();
            if (this._dlg.lstResult.getModel().getSize() - 1 > selIx) {
                this._dlg.lstResult.setSelectedIndex(selIx + 1);
                this._dlg.lstResult.ensureIndexIsVisible(selIx + 1);
            }
        }
    }

    private void onConnect() {
        AliasSearchWrapper selectedWrapperAlias = this._dlg.lstResult.getSelectedValue();
        if (null == selectedWrapperAlias) {
            return;
        }
        if (null != selectedWrapperAlias.getAlias()) {
            ConnectToAliasCallBack completionCallback = null;
            if (this._dlg.chkLeaveOpen.isSelected()) {
                completionCallback = new ConnectToAliasCallBack(selectedWrapperAlias.getAlias()){

                    @Override
                    public void sessionCreated(ISession session) {
                        FindAliasesCtrl.this._dlg.requestFocus();
                        FindAliasesCtrl.this._dlg.txtToSearch.requestFocus();
                        super.sessionCreated(session);
                    }
                };
            }
            new ConnectToAliasCommand(selectedWrapperAlias.getAlias(), true, completionCallback).executeConnect();
            if (!this._dlg.chkLeaveOpen.isSelected()) {
                this.onClosing();
                this._dlg.setVisible(false);
                this._dlg.dispose();
            }
        } else {
            this.onGoto();
        }
    }

    private void onModify() {
        AliasSearchWrapper selectedWrapperAlias = this._dlg.lstResult.getSelectedValue();
        if (null == selectedWrapperAlias) {
            return;
        }
        AliasWindowManager.showModifyAliasInternalFrame(selectedWrapperAlias.getAlias());
        if (!this._dlg.chkLeaveOpen.isSelected()) {
            this.onClosing();
            this._dlg.setVisible(false);
            this._dlg.dispose();
        }
    }

    private void onGoto() {
        AliasSearchWrapper selectedAliasWrapper = this._dlg.lstResult.getSelectedValue();
        if (null == selectedAliasWrapper) {
            return;
        }
        AliasesUtil.viewInAliasesDockWidget(selectedAliasWrapper, this._aliasesList, (Object)this._dlg);
        if (!this._dlg.chkLeaveOpen.isSelected()) {
            this.onClosing();
            this._dlg.setVisible(false);
            this._dlg.dispose();
        } else {
            this._dlg.txtToSearch.requestFocus();
        }
    }

    private void updateList() {
        String filterText = this._dlg.txtToSearch.getText();
        AliasSearchWrapper formerSelectedValue = this._dlg.lstResult.getSelectedValue();
        Vector<AliasSearchWrapper> allAliasSearchWrappers = new Vector<AliasSearchWrapper>();
        allAliasSearchWrappers.addAll(AliasSearchWrapper.wrapAliases(Main.getApplication().getAliasesAndDriversManager().getAliasList()));
        if (this._dlg.chkIncludeAliasFolders.isSelected()) {
            List<AliasFolder> allAliasFolders = Main.getApplication().getWindowManager().getAliasesListInternalFrame().getAliasesList().getAliasTreeInterface().getAllAliasFolders();
            allAliasSearchWrappers.addAll(AliasSearchWrapper.wrapAliasFolders(allAliasFolders));
        }
        Vector<AliasSearchWrapper> matchingAliasSearchWrappers = new Vector<AliasSearchWrapper>();
        for (AliasSearchWrapper aliasSearchWrapper : allAliasSearchWrappers) {
            if (!this.matches(aliasSearchWrapper, filterText)) continue;
            matchingAliasSearchWrappers.add(aliasSearchWrapper);
        }
        Collections.sort(matchingAliasSearchWrappers, Comparator.comparing(AliasSearchWrapper::getName));
        this._dlg.lstResult.setListData(matchingAliasSearchWrappers);
        this._dlg.lstResult.setSelectedValue(formerSelectedValue, true);
        if (-1 == this._dlg.lstResult.getSelectedIndex()) {
            this._dlg.lstResult.setSelectedIndex(0);
            this._dlg.lstResult.ensureIndexIsVisible(0);
        }
    }

    private void onListClicked(MouseEvent e) {
        if (2 == e.getClickCount()) {
            this.onConnect();
        }
    }

    private boolean matches(AliasSearchWrapper aliasSearchWrapper, String filterText) {
        if (StringUtilities.isEmpty(filterText, true)) {
            return true;
        }
        if (null != aliasSearchWrapper.getAlias()) {
            return null != aliasSearchWrapper.getAlias().getName() && -1 < aliasSearchWrapper.getAlias().getName().toLowerCase().indexOf(filterText.toLowerCase()) || null != aliasSearchWrapper.getAlias().getUrl() && -1 < aliasSearchWrapper.getAlias().getUrl().toLowerCase().indexOf(filterText.toLowerCase()) || null != aliasSearchWrapper.getAlias().getUserName() && -1 < aliasSearchWrapper.getAlias().getUserName().toLowerCase().indexOf(filterText.toLowerCase());
        }
        return null != aliasSearchWrapper.getAliasFolder().getFolderName() && -1 < aliasSearchWrapper.getAliasFolder().getFolderName().toLowerCase().indexOf(filterText.toLowerCase());
    }

    private void onClosing() {
        Props.putInt(PREF_KEY_FIND_ALIAS_SHEET_WIDTH, this._dlg.getWidth());
        Props.putInt(PREF_KEY_FIND_ALIAS_SHEET_HEIGHT, this._dlg.getHeight());
        Props.putBoolean(PREF_KEY_FIND_ALIAS_CHECK_LEAVE_OPEN, this._dlg.chkLeaveOpen.isSelected());
        Props.putBoolean(PREF_KEY_FIND_ALIAS_REMEMBER_LAST_SEARCH, this._dlg.chkRememberLastSearch.isSelected());
        Props.putBoolean(PREF_KEY_FIND_ALIAS_INCLUDE_ALIAS_FOLDERS, this._dlg.chkIncludeAliasFolders.isSelected());
        if (this._dlg.chkRememberLastSearch.isSelected()) {
            Props.putString(PREF_KEY_FIND_ALIAS_LAST_SEARCH_STRING, this._dlg.txtToSearch.getText());
        }
    }

    private Dimension getDimension() {
        return new Dimension(Props.getInt(PREF_KEY_FIND_ALIAS_SHEET_WIDTH, 600), Props.getInt(PREF_KEY_FIND_ALIAS_SHEET_HEIGHT, 400));
    }
}

