/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action.findprefs;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.AliasPropertiesController;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.AliasPropertiesDialogFindInfo;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.DialogToOpen;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.GlobalPreferencesDialogFindInfo;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.PrefComponentInfo;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.PrefsFindInfo;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.PrefsPanelVisitor;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.SavedSessionMoreDialogFindInfo;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.SessionPropertiesDialogFindInfo;
import net.sourceforge.squirrel_sql.client.preferences.GlobalPreferencesSheet;
import net.sourceforge.squirrel_sql.client.preferences.NewSessionPropertiesSheet;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionMoreCtrlSingleton;

public class ComponentInfoByPathUtil {
    public static PrefsFindInfo createPrefsFindInfo() {
        return ComponentInfoByPathUtil.createPrefsFindInfo(DialogToOpen.NONE);
    }

    public static PrefsFindInfo createPrefsFindInfo(DialogToOpen dialogToOpen) {
        TreeMap<List<String>, List<PrefComponentInfo>> componentInfoByPath = new TreeMap<List<String>, List<PrefComponentInfo>>((p1, p2) -> ComponentInfoByPathUtil.comparePaths(p1, p2));
        GlobalPreferencesDialogFindInfo globalPreferencesDialogFindInfo = GlobalPreferencesSheet.getPreferencesFindSupport().createFindInfo(dialogToOpen == DialogToOpen.GLOBAL_PREFERENCES);
        for (Map.Entry<Integer, Component> entry : globalPreferencesDialogFindInfo.getTabComponentByTabIndex().entrySet()) {
            String string = globalPreferencesDialogFindInfo.getTabName(entry.getKey());
            PrefsPanelVisitor.visit(globalPreferencesDialogFindInfo, string, entry.getValue(), vi -> ComponentInfoByPathUtil.onVisitFindableComponent(vi, componentInfoByPath));
        }
        SessionPropertiesDialogFindInfo sessionPropertiesDialogFindInfo = NewSessionPropertiesSheet.getPreferencesFindSupport().createFindInfo(dialogToOpen == DialogToOpen.SESSION_PROPERTIES);
        for (Map.Entry<Integer, Component> entry : sessionPropertiesDialogFindInfo.getTabComponentByTabIndex().entrySet()) {
            String string = sessionPropertiesDialogFindInfo.getTabName(entry.getKey());
            PrefsPanelVisitor.visit(sessionPropertiesDialogFindInfo, string, entry.getValue(), vi -> ComponentInfoByPathUtil.onVisitFindableComponent(vi, componentInfoByPath));
        }
        AliasPropertiesDialogFindInfo aliasPropertiesDialogFindInfo = AliasPropertiesController.getPreferencesFindSupport().createFindInfo(dialogToOpen == DialogToOpen.ALIAS_PROPERTIES);
        if (null != aliasPropertiesDialogFindInfo) {
            for (Map.Entry<Integer, Component> entry : aliasPropertiesDialogFindInfo.getTabComponentByTabIndex().entrySet()) {
                String tabName = aliasPropertiesDialogFindInfo.getTabName(entry.getKey());
                PrefsPanelVisitor.visit(aliasPropertiesDialogFindInfo, tabName, entry.getValue(), vi -> ComponentInfoByPathUtil.onVisitFindableComponent(vi, componentInfoByPath));
            }
        }
        SavedSessionMoreDialogFindInfo savedSessionMoreDialogFindInfo = SavedSessionMoreCtrlSingleton.getPreferencesFindSupport().createFindInfo(dialogToOpen == DialogToOpen.SAVED_SESSION);
        PrefsPanelVisitor.visit(savedSessionMoreDialogFindInfo, null, savedSessionMoreDialogFindInfo.getContentPane(), vi -> ComponentInfoByPathUtil.onVisitFindableComponent(vi, componentInfoByPath));
        return new PrefsFindInfo(globalPreferencesDialogFindInfo, sessionPropertiesDialogFindInfo, aliasPropertiesDialogFindInfo, savedSessionMoreDialogFindInfo, componentInfoByPath);
    }

    private static void onVisitFindableComponent(PrefComponentInfo componentInfo, TreeMap<List<String>, List<PrefComponentInfo>> componentInfoByPath) {
        if (componentInfo.hasEmptyText()) {
            return;
        }
        List<String> path = componentInfo.getPath();
        List<PrefComponentInfo> buf = componentInfoByPath.get(path);
        if (null == buf) {
            buf = new ArrayList<PrefComponentInfo>();
            componentInfoByPath.put(path, buf);
        }
        buf.add(componentInfo);
    }

    private static int comparePaths(List<String> p1, List<String> p2) {
        for (int i = 0; i < Math.min(p1.size(), p2.size()); ++i) {
            int res = p1.get(i).compareTo(p2.get(i));
            if (0 == res) continue;
            return res;
        }
        return Integer.compare(p1.size(), p2.size());
    }
}

