/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action.findprefs;

import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrame;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.FindInPreferencesDlg;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.FindInPreferencesModel;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.FindPrefsTreeCellRenderer;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.GotoHandler;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.GotoPathResult;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.PathEntry;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.PrefsFindInfo;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import org.apache.commons.lang3.StringUtils;

public class FindInPreferencesCtrl {
    private StringManager s_stringMgr = StringManagerFactory.getStringManager(FindInPreferencesCtrl.class);
    private final FindInPreferencesDlg _dlg;
    private FindInPreferencesModel _model;

    public FindInPreferencesCtrl(PrefsFindInfo prefsFindInfo) {
        this._model = new FindInPreferencesModel(prefsFindInfo);
        MainFrame parent = Main.getApplication().getMainFrame();
        this._dlg = new FindInPreferencesDlg(parent);
        this._dlg.tree.addTreeSelectionListener(e -> this.onTreeSelectionChanged(e));
        this._dlg.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FindInPreferencesCtrl.this.onMaybeTriggerTreePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                FindInPreferencesCtrl.this.onMaybeTriggerTreePopup(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                FindInPreferencesCtrl.this.onTreeClicked(e);
            }
        });
        this._dlg.tree.setCellRenderer(new FindPrefsTreeCellRenderer());
        this._dlg.txtFind.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FindInPreferencesCtrl.this.updateTree();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FindInPreferencesCtrl.this.updateTree();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FindInPreferencesCtrl.this.updateTree();
            }
        });
        this._dlg.txtFind.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                FindInPreferencesCtrl.this.onKeyPressed(e);
            }
        });
        this._dlg.btnGoTo.addActionListener(e -> this.onGoTo());
        this.updateTree();
        SwingUtilities.invokeLater(() -> this._dlg.txtFind.requestFocus());
        GUIUtils.initLocation(this._dlg, 750, 600);
        this._dlg.setLocation(parent.getX() + 20, this._dlg.getLocation().y);
        GUIUtils.enableCloseByEscape(this._dlg);
        this._dlg.setVisible(true);
    }

    private void onTreeClicked(MouseEvent me) {
        if (2 == me.getClickCount()) {
            TreePath selectionPath = this._dlg.tree.getSelectionPath();
            TreePath pathForLocation = this._dlg.tree.getPathForLocation(me.getX(), me.getY());
            if (null == selectionPath || null == pathForLocation || pathForLocation.getLastPathComponent() != selectionPath.getLastPathComponent()) {
                return;
            }
            List<String> componentPath = this._model.treeNodeToComponentPath((DefaultMutableTreeNode)selectionPath.getLastPathComponent());
            GotoHandler gotoHandler = new GotoHandler();
            gotoHandler.gotoPath(componentPath, true);
        }
    }

    private void onMaybeTriggerTreePopup(MouseEvent me) {
        if (me.isPopupTrigger()) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem mnuItem = new JMenuItem(this.s_stringMgr.getString("FindInPreferencesCtrl.tree.popup.menu"));
            popup.add(mnuItem);
            mnuItem.addActionListener(e -> this.onGoTo());
            TreePath pathForLocation = this._dlg.tree.getPathForLocation(me.getX(), me.getY());
            if (null != pathForLocation) {
                this._dlg.tree.setSelectionPath(pathForLocation);
            }
            popup.show(this._dlg.tree, me.getX(), me.getY());
        }
    }

    private void onGoTo() {
        if (null == this._dlg.tree.getSelectionPath()) {
            this.s_stringMgr.getString("FindInPreferencesCtrl.no.tree.node.selected");
            return;
        }
        GotoHandler gotoHandler = new GotoHandler();
        List<String> componentPath = this._model.treeNodeToComponentPath((DefaultMutableTreeNode)this._dlg.tree.getSelectionPath().getLastPathComponent());
        if (GotoPathResult.NO_ACTION_BECAUSE_COMPONENT_NOT_FOUND == gotoHandler.gotoPath(componentPath, false)) {
            this._model = new FindInPreferencesModel(gotoHandler.getPrefsFindInfoUpdate());
            this.updateTree();
            this.tryRestorePreviousSelection(componentPath);
        }
    }

    private void tryRestorePreviousSelection(List<String> componentPath) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._dlg.tree.getModel().getRoot();
        for (int i = componentPath.size(); i > 0; --i) {
            List<String> path = componentPath.subList(0, i);
            DefaultMutableTreeNode toSelect = this.findTreePathByComponentPath(path, root);
            if (null == toSelect) continue;
            this._dlg.tree.setSelectionPath(new TreePath(toSelect.getPath()));
            break;
        }
    }

    private DefaultMutableTreeNode findTreePathByComponentPath(List<String> componentPath, DefaultMutableTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            PathEntry pe = (PathEntry)child.getUserObject();
            if (pe.getComponentInfoList().get(0).getPath().equals(componentPath)) {
                return child;
            }
            DefaultMutableTreeNode ret = this.findTreePathByComponentPath(componentPath, child);
            if (null == ret) continue;
            return ret;
        }
        return null;
    }

    private void updateTree() {
        String filterText = this._dlg.txtFind.getText();
        DefaultMutableTreeNode root = this._model.createFilteredTreeNodes(filterText);
        DefaultTreeModel dtm = new DefaultTreeModel(root);
        this._dlg.tree.setModel(dtm);
        this._dlg.tree.setRootVisible(false);
        this._dlg.tree.getSelectionModel().setSelectionMode(1);
        if (!StringUtilities.isEmpty(filterText, true)) {
            for (int i = 0; i < this._dlg.tree.getRowCount(); ++i) {
                this._dlg.tree.expandRow(i);
            }
        }
        this._dlg.tree.setSelectionRow(0);
    }

    private void onKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            int selIx = 0 == this._dlg.tree.getSelectionRows().length ? 0 : this._dlg.tree.getSelectionRows()[0];
            if (0 < selIx) {
                this._dlg.tree.setSelectionRow(selIx - 1);
                this._dlg.tree.scrollRowToVisible(selIx - 1);
            }
        } else if (e.getKeyCode() == 40) {
            int selIx = 0 == this._dlg.tree.getSelectionRows().length ? 0 : this._dlg.tree.getSelectionRows()[0];
            if (this._dlg.tree.getRowCount() - 1 > selIx) {
                this._dlg.tree.setSelectionRow(selIx + 1);
                this._dlg.tree.scrollRowToVisible(selIx + 1);
            }
        }
    }

    private void onTreeSelectionChanged(TreeSelectionEvent e) {
        this._dlg.txtDetails.setText("");
        if (null == e.getNewLeadSelectionPath()) {
            return;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
        this._dlg.txtDetails.setLineWrap(this._model.detailsTextNeedsLineWrap(selectedNode));
        String detailsText = this._model.getDetailsText(selectedNode);
        if (null == this.getFilterText()) {
            this._dlg.txtDetails.setText(detailsText);
        } else {
            String filterText = this.getFilterText();
            int startIx = 0;
            while (true) {
                int matchIx;
                if (-1 == (matchIx = StringUtils.indexOfIgnoreCase((CharSequence)detailsText, (CharSequence)filterText, (int)startIx))) {
                    this._dlg.txtDetails.appendToPane(detailsText.substring(startIx), false);
                    break;
                }
                this._dlg.txtDetails.appendToPane(detailsText.substring(startIx, matchIx), false);
                this._dlg.txtDetails.appendToPane(detailsText.substring(matchIx, matchIx + filterText.length()), true);
                startIx = matchIx + filterText.length();
            }
        }
        SwingUtilities.invokeLater(() -> this._dlg.txtDetails.scrollRectToVisible(new Rectangle(0, 0)));
    }

    private String getFilterText() {
        String text = this._dlg.txtFind.getText();
        if (StringUtilities.isEmpty(text, true)) {
            return null;
        }
        return text.trim();
    }
}

