/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action.findprefs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.PathEntry;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.PrefComponentInfo;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.PrefsFindInfo;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import org.apache.commons.lang3.StringUtils;

public class FindInPreferencesModel {
    private PrefsFindInfo _prefsFindInfo;

    public FindInPreferencesModel(PrefsFindInfo prefsFindInfo) {
        this._prefsFindInfo = prefsFindInfo;
    }

    public DefaultMutableTreeNode createFilteredTreeNodes(String filterText) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
        for (Map.Entry<List<String>, List<PrefComponentInfo>> entry : this._prefsFindInfo.getComponentInfoByPath().entrySet()) {
            DefaultMutableTreeNode parent = root;
            List<String> pathEntryStrings = entry.getKey();
            for (int i = 0; i < pathEntryStrings.size(); ++i) {
                DefaultMutableTreeNode child;
                if (!this.matches(pathEntryStrings.subList(i, pathEntryStrings.size()), filterText)) continue;
                String pathEntryString = pathEntryStrings.get(i);
                boolean found = false;
                for (int j = 0; j < parent.getChildCount(); ++j) {
                    child = (DefaultMutableTreeNode)parent.getChildAt(j);
                    PathEntry pathEntry = (PathEntry)child.getUserObject();
                    if (!pathEntry.isSame(pathEntryString)) continue;
                    parent = child;
                    found = true;
                    break;
                }
                if (found) continue;
                PathEntry newPathEntry = new PathEntry(pathEntryString, this.pathEntryMatchesFilter(filterText, pathEntryString));
                child = new DefaultMutableTreeNode(newPathEntry);
                parent.add(child);
                newPathEntry.setComponentInfoList(this.treeNodeToComponentInfoList(child));
                parent = child;
            }
        }
        return root;
    }

    private boolean pathEntryMatchesFilter(String filterText, String pathEntryString) {
        return false == StringUtilities.isEmpty(filterText, true) && this.matches(Collections.singletonList(pathEntryString), filterText);
    }

    private boolean matches(List<String> path, String filterText) {
        if (StringUtilities.isEmpty(filterText, true)) {
            return true;
        }
        filterText = filterText.trim();
        for (String pathEntry : path) {
            if (!StringUtils.containsIgnoreCase((CharSequence)pathEntry, (CharSequence)filterText)) continue;
            return true;
        }
        return false;
    }

    public List<String> treeNodeToComponentPath(DefaultMutableTreeNode node) {
        Object[] pathIncludingRoot = node.getUserObjectPath();
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 1; i < pathIncludingRoot.length; ++i) {
            String pathEntryString = ((PathEntry)pathIncludingRoot[i]).getPathEntryString();
            ret.add(pathEntryString);
        }
        return ret;
    }

    public List<PrefComponentInfo> treeNodeToComponentInfoList(DefaultMutableTreeNode node) {
        return this._prefsFindInfo.getPrefComponentInfoListByPath(this.treeNodeToComponentPath(node));
    }

    public String getDetailsText(DefaultMutableTreeNode node) {
        return ((PathEntry)node.getUserObject()).getPathEntryString();
    }

    public boolean detailsTextNeedsLineWrap(DefaultMutableTreeNode node) {
        PathEntry pathEntry = (PathEntry)node.getUserObject();
        return pathEntry.detailsTextNeedsLineWrap();
    }
}

