/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action.findprefs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.ComponentInfoByPathUtil;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.FindableComponentInfoType;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.GotoPathResult;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.PrefComponentInfo;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.PrefsFindInfo;
import net.sourceforge.squirrel_sql.fw.gui.ComponentIndicator;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.apache.commons.lang3.StringUtils;

public class GotoHandler {
    private StringManager s_stringMgr = StringManagerFactory.getStringManager(GotoHandler.class);
    private static final ILogger s_log = LoggerController.createLogger(GotoHandler.class);
    private PrefsFindInfo _prefsFindInfo;
    private ComponentIndicator _componentIndicator = new ComponentIndicator();

    public GotoPathResult gotoPath(List<String> path, boolean gotoLeafOnly) {
        if (gotoLeafOnly && !GotoHandler.isLeaf(path)) {
            return GotoPathResult.NO_ACTION_BECAUSE_NO_LEAF;
        }
        PrefsFindInfo prefsFindInfoPreview = ComponentInfoByPathUtil.createPrefsFindInfo();
        PrefComponentInfo showingComponentInfo = prefsFindInfoPreview.openDialogAndShowComponentAtPath(path);
        this._prefsFindInfo = prefsFindInfoPreview.getPrefsFindInfoUpdate();
        PrefComponentInfo showingComponentInfoToGoTo = this._prefsFindInfo.getComponentInfoByPath(path);
        if (null == showingComponentInfoToGoTo) {
            s_log.warn("Failed to find Component for path (search dialog was reloaded, try again):\n" + path);
            String pathNoNewLines = StringUtils.replace((String)("" + path), (String)"\n", (String)" ");
            String msg = this.s_stringMgr.getString("GotoHandler.component.not.found.try.again", pathNoNewLines);
            Main.getApplication().getMessageHandler().showWarningMessage(msg);
            return GotoPathResult.NO_ACTION_BECAUSE_COMPONENT_NOT_FOUND;
        }
        if (null == showingComponentInfo) {
            return GotoPathResult.NO_ACTION_BECAUSE_DIALOG_NODE_SELECTED_TO_GO_TO;
        }
        return this.blinkComponent(showingComponentInfo.getComponent(), showingComponentInfoToGoTo.getComponent());
    }

    private static boolean isLeaf(List<String> path) {
        PrefsFindInfo prefsFindInfoPreview = ComponentInfoByPathUtil.createPrefsFindInfo();
        PrefComponentInfo componentInfoToGoTo = prefsFindInfoPreview.getComponentInfoByPath(path);
        return null != componentInfoToGoTo && FindableComponentInfoType.LEAVE_COMPONENT == componentInfoToGoTo.getFindableComponentInfoType();
    }

    private GotoPathResult blinkComponent(Component containingTabComponent, Component componentToBlink) {
        Runnable runnableToScrollAndBlink = null;
        if (containingTabComponent instanceof JScrollPane && containingTabComponent != componentToBlink) {
            JComponent componentInScrollPane = (JComponent)((JScrollPane)containingTabComponent).getViewport().getView();
            int x = componentToBlink.getX();
            int y = componentToBlink.getY();
            for (Container parent = componentToBlink.getParent(); parent != componentInScrollPane; parent = parent.getParent()) {
                x += parent.getX();
                y += parent.getY();
            }
            Rectangle rect = new Rectangle(x, y, componentToBlink.getWidth(), componentToBlink.getHeight());
            runnableToScrollAndBlink = () -> GUIUtils.forceProperty(() -> {
                componentInScrollPane.scrollRectToVisible(rect);
                boolean contains = ((JScrollPane)containingTabComponent).getVisibleRect().contains(rect);
                return contains;
            }, () -> this.initBlinkComponent(componentToBlink));
        } else {
            runnableToScrollAndBlink = () -> this.initBlinkComponent(componentToBlink);
        }
        GUIUtils.executeDelayed(runnableToScrollAndBlink, 200);
        return GotoPathResult.WENT_TO_COMPONENT_AND_BLINKED;
    }

    private void initBlinkComponent(Component componentToIndicate) {
        this._componentIndicator.init(componentToIndicate);
    }

    public PrefsFindInfo getPrefsFindInfoUpdate() {
        if (null == this._prefsFindInfo) {
            throw new IllegalStateException("Call gotoPath() first");
        }
        return this._prefsFindInfo;
    }
}

