/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action.findprefs;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class NoWrapJTextPane
extends JTextPane {
    private final SimpleAttributeSet _matchAttributeSet;
    private final AttributeSet _defaultAttributeSet;
    private boolean _lineWrap;

    public NoWrapJTextPane() {
        StyleContext defaultStyleContext = StyleContext.getDefaultStyleContext();
        new SimpleAttributeSet(defaultStyleContext.getEmptySet());
        this._matchAttributeSet = new SimpleAttributeSet();
        StyleConstants.setBackground(this._matchAttributeSet, Color.green);
        this._defaultAttributeSet = new SimpleAttributeSet();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (!this._lineWrap) {
            return this.getUI().getPreferredSize((JComponent)this).width <= this.getParent().getSize().width;
        }
        return super.getScrollableTracksViewportWidth();
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this._lineWrap) {
            return this.getUI().getPreferredSize(this);
        }
        return super.getPreferredSize();
    }

    public void setLineWrap(boolean lineWrap) {
        this._lineWrap = lineWrap;
        this.repaint();
    }

    public void appendToPane(String text, boolean match) {
        try {
            if (match) {
                this.getStyledDocument().insertString(this.getStyledDocument().getLength(), text, this._matchAttributeSet);
            } else {
                this.getStyledDocument().insertString(this.getStyledDocument().getLength(), text, this._defaultAttributeSet);
            }
        }
        catch (BadLocationException e) {
            throw Utilities.wrapRuntime(e);
        }
    }
}

