/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action.findprefs;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.DialogFindInfo;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.FindableComponentInfoType;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class PrefComponentInfo {
    private DialogFindInfo _dialogFindInfo;
    private Component _component;
    private String _text;
    private PrefComponentInfo _parent;
    private FindableComponentInfoType _findableComponentInfoType;

    public PrefComponentInfo(Component component, String text, PrefComponentInfo parent) {
        this(component, text, parent, FindableComponentInfoType.LEAVE_COMPONENT);
    }

    public PrefComponentInfo(Component component, String text, PrefComponentInfo parent, FindableComponentInfoType findableComponentInfoType) {
        this._component = component;
        this._text = text;
        this._parent = parent;
        this._findableComponentInfoType = findableComponentInfoType;
    }

    public PrefComponentInfo(DialogFindInfo dialogFindInfo) {
        this(null, dialogFindInfo);
    }

    public PrefComponentInfo(Component component, DialogFindInfo dialogFindInfo) {
        this._component = component;
        this._dialogFindInfo = dialogFindInfo;
        this._text = dialogFindInfo.getDialogTitle();
        this._parent = null;
        this._findableComponentInfoType = FindableComponentInfoType.DIALOG;
    }

    public String getText() {
        return this._text;
    }

    public Component getComponent() {
        return this._component;
    }

    public DialogFindInfo getDialogFindInfo() {
        return this._dialogFindInfo;
    }

    public FindableComponentInfoType getFindableComponentInfoType() {
        return this._findableComponentInfoType;
    }

    public static PrefComponentInfo createParentForTabComponent(DialogFindInfo dialogFindInfo, String tabName, Component globalPrefTabComponent) {
        PrefComponentInfo dialogComponentInfo = new PrefComponentInfo(dialogFindInfo);
        return new PrefComponentInfo(globalPrefTabComponent, tabName, dialogComponentInfo, FindableComponentInfoType.PARENT_TAB_CONTAINER);
    }

    public static PrefComponentInfo createParentForDialog(DialogFindInfo dialogFindInfo, Component dialogContentComponent) {
        return new PrefComponentInfo(dialogContentComponent, dialogFindInfo);
    }

    public List<String> getPath() {
        ArrayList<String> path = new ArrayList<String>();
        this.fillPath(path);
        return path;
    }

    public PrefComponentInfo getParent() {
        return this._parent;
    }

    private void fillPath(ArrayList<String> path) {
        if (null != this._parent) {
            this._parent.fillPath(path);
        }
        if (!this.hasEmptyText()) {
            path.add(this._text);
        }
    }

    public boolean hasEmptyText() {
        return StringUtilities.isEmpty(this._text, true);
    }
}

