/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action.openconnection;

import java.sql.DriverManager;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.mainframe.action.openconnection.OpenConnectionCommandListener;
import net.sourceforge.squirrel_sql.client.mainframe.action.openconnection.OpenConnectionThreadPool;
import net.sourceforge.squirrel_sql.client.session.action.reconnect.ReconnectInfo;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverManager;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class OpenConnectionCommand {
    private SQLAlias _sqlAlias;
    private final String _userName;
    private final String _password;
    private final SQLDriverPropertyCollection _props;
    private SQLConnection _conn;
    private ReconnectInfo _reconnectInfo;

    public OpenConnectionCommand(SQLAlias sqlAlias, String userName, String password, SQLDriverPropertyCollection props) {
        this(sqlAlias, userName, password, props, null);
    }

    public OpenConnectionCommand(SQLAlias sqlAlias, String userName, String password, SQLDriverPropertyCollection props, ReconnectInfo reconnectInfo) {
        if (sqlAlias == null) {
            throw new IllegalArgumentException("Null SQLAlias passed");
        }
        this._sqlAlias = sqlAlias;
        this._userName = userName;
        this._password = password;
        this._props = props;
        this._reconnectInfo = reconnectInfo;
    }

    public void executeConnectAndWaitForResultInBackground(OpenConnectionCommandListener openConnectionCommandListener) {
        Future future = OpenConnectionThreadPool.submit(() -> this.executeConnect());
        OpenConnectionThreadPool.submit(() -> this.awaitConnection(future, openConnectionCommandListener, false));
    }

    public void executeAndWait() {
        Runnable taskConnect = () -> this.executeConnect();
        Future future = OpenConnectionThreadPool.submit(taskConnect);
        Throwable[] ref = new Throwable[1];
        this.awaitConnection(future, t -> {
            ref[0] = t;
        }, true);
        if (null != ref[0]) {
            throw Utilities.wrapRuntime(ref[0]);
        }
    }

    private void awaitConnection(Future future, OpenConnectionCommandListener openConnectionCommandListener, boolean processImmediately) {
        try {
            if (0 < DriverManager.getLoginTimeout()) {
                future.get(DriverManager.getLoginTimeout(), TimeUnit.SECONDS);
            } else {
                future.get();
            }
            if (processImmediately) {
                openConnectionCommandListener.openConnectionFinished(null);
            } else {
                SwingUtilities.invokeLater(() -> openConnectionCommandListener.openConnectionFinished(null));
            }
        }
        catch (Throwable t) {
            if (processImmediately) {
                openConnectionCommandListener.openConnectionFinished(t);
            }
            SwingUtilities.invokeLater(() -> openConnectionCommandListener.openConnectionFinished(t));
        }
    }

    private void executeConnect() {
        this._conn = null;
        IIdentifier driverID = this._sqlAlias.getDriverIdentifier();
        ISQLDriver sqlDriver = Main.getApplication().getAliasesAndDriversManager().getDriver(driverID);
        SQLDriverManager mgr = Main.getApplication().getSQLDriverManager();
        try {
            this._conn = mgr.getConnection(sqlDriver, this._sqlAlias, this._userName, this._password, this._props, this._reconnectInfo);
        }
        catch (Throwable th) {
            throw Utilities.wrapRuntime(th);
        }
    }

    public SQLConnection getSQLConnection() {
        return this._conn;
    }
}

