/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.plugin.IPluginManager;
import net.sourceforge.squirrel_sql.client.plugin.PluginInfo;
import net.sourceforge.squirrel_sql.client.plugin.PluginStatus;
import net.sourceforge.squirrel_sql.client.plugin.PluginSummaryTable;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class PluginSummaryDialog
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(PluginSummaryDialog.class);
    private final transient IApplication _app;
    private PluginSummaryTable _pluginPnl;

    public PluginSummaryDialog(IApplication app, Frame owner) throws DataSetException {
        super(owner, s_stringMgr.getString("PluginSummaryDialog.title"));
        this._app = app;
        this.createGUI();
    }

    private void saveSettings() {
        this._app.getPluginManager().setPluginStatuses(this._pluginPnl.getPluginStatus());
    }

    private void createGUI() throws DataSetException {
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JLabel pluginLoc = new JLabel(s_stringMgr.getString("PluginSummaryDialog.pluginloc", new ApplicationFiles().getPluginsDirectory().getAbsolutePath()));
        pluginLoc.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
        contentPane.add((Component)pluginLoc, "North");
        IPluginManager pmgr = this._app.getPluginManager();
        PluginInfo[] pluginInfo = pmgr.getPluginInformation();
        PluginStatus[] pluginStatus = pmgr.getPluginStatuses();
        this._pluginPnl = new PluginSummaryTable(pluginInfo, pluginStatus);
        contentPane.add((Component)new JScrollPane(this._pluginPnl), "Center");
        JPanel btnsPnl = new JPanel();
        JButton okBtn = new JButton(s_stringMgr.getString("PluginSummaryDialog.ok"));
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginSummaryDialog.this.saveSettings();
                PluginSummaryDialog.this.dispose();
            }
        });
        btnsPnl.add(okBtn);
        JButton unloadButton = new JButton(i18n.UNLOAD_LABEL);
        unloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int[] rows = PluginSummaryDialog.this._pluginPnl.getSelectedRows();
                if (rows.length == 0) {
                    return;
                }
                for (int row : rows) {
                    String internalName = (String)PluginSummaryDialog.this._pluginPnl.getModel().getValueAt(row, 1);
                    PluginSummaryDialog.this._app.getPluginManager().unloadPlugin(internalName);
                    PluginSummaryDialog.this._pluginPnl.setValueAt("false", row, 3);
                }
                PluginSummaryDialog.this._pluginPnl.repaint();
            }
        });
        btnsPnl.add(unloadButton);
        JButton closeBtn = new JButton(s_stringMgr.getString("PluginSummaryDialog.close"));
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginSummaryDialog.this.dispose();
            }
        });
        btnsPnl.add(closeBtn);
        contentPane.add((Component)btnsPnl, "South");
        GUIUtils.enableCloseByEscape(this);
        this.pack();
        this.setSize(655, 500);
        GUIUtils.centerWithinParent(this);
        this.setResizable(true);
    }

    static interface i18n {
        public static final String UNLOAD_LABEL = s_stringMgr.getString("PluginSummaryDialog.unload");
    }
}

