/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.gui.db.passwordaccess.PasswordAccessPrefsCtrl;
import net.sourceforge.squirrel_sql.client.preferences.LocaleWrapper;
import net.sourceforge.squirrel_sql.client.preferences.MaxColumnAdjustLengthCtrl;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.preferences.themes.ThemesController;
import net.sourceforge.squirrel_sql.client.session.messagepanel.MessagePrefsCtrl;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

final class GeneralPreferencesGUI
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GeneralPreferencesGUI.class);
    private JRadioButton _tabbedStyle = new JRadioButton(s_stringMgr.getString("GeneralPreferencesPanel.tabbedStyle"));
    private JRadioButton _internalFrameStyle = new JRadioButton(s_stringMgr.getString("GeneralPreferencesPanel.internalFrameStyle"));
    private JCheckBox _useScrollableTabbedPanesForSessionTabs = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.useScrollableTabbedPanesForSessionTabs"));
    private JCheckBox _showContents = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.showwindowcontents"));
    private JCheckBox _maximimizeSessionSheet = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.maxonopen"));
    private JCheckBox _showTabbedStyleHint = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.showTabbedStyleHint"));
    private JCheckBox _showAliasesToolBar = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.showaliasestoolbar"));
    private JCheckBox _showDriversToolBar = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.showdriverstoolbar"));
    private JCheckBox _showMainStatusBar = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.showmainwinstatusbar"));
    private JCheckBox _showMainToolBar = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.showmainwintoolbar"));
    private JCheckBox _showToolTips = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.showtooltips"));
    private JCheckBox _useScrollableTabbedPanes = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.usescrolltabs"));
    private JCheckBox _showColoriconsInToolbar = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.showcoloricons"));
    private JCheckBox _showPluginFilesInSplashScreen = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.showpluginfiles"));
    private JCheckBox _useShortSessionTitle = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.useShortSessionTitle"));
    private JCheckBox _rememberValueOfPopup = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.rememberValueOfPopup"));
    private JCheckBox _confirmSessionCloseChk = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.confirmSessionClose"));
    private JCheckBox _warnJreJdbcMismatch = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.warnJreJdbcMismatch"));
    private JCheckBox _warnForUnsavedFileEdits = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.warnForUnsavedFileEdits"));
    private JCheckBox _warnForUnsavedBufferEdits = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.warnForUnsavedBufferEdits"));
    private JCheckBox _showSessionStartupTimeHint = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.showSessionStartupTimeHint"));
    private JRadioButton _saveNoPreferencesImmediatelyNone = new JRadioButton(s_stringMgr.getString("GeneralPreferencesPanel.saveNoPreferencesImmediately"));
    private JRadioButton _saveAliasesAndDriversImmediately = new JRadioButton(s_stringMgr.getString("GeneralPreferencesPanel.saveAliasesAndDriversImmediately"));
    private JRadioButton _savePreferencesImmediately = new JRadioButton(s_stringMgr.getString("GeneralPreferencesPanel.savePreferencesImmediately_new"));
    private JCheckBox _selectOnRightMouseClick = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.selectOnRightMouseClick"));
    private JCheckBox _showPleaseWaitDialog = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.showPleaseWaitDialog"));
    private JComboBox _localeChooser = new JComboBox<LocaleWrapper>(LocaleWrapper.getAvailableLocaleWrappers());
    private MaxColumnAdjustLengthCtrl _maxColumnAdjustLengthCtrl = new MaxColumnAdjustLengthCtrl();
    private MessagePrefsCtrl _messagePrefsCtrl = new MessagePrefsCtrl();
    private PasswordAccessPrefsCtrl _passwordAccessPrefsCtrl = new PasswordAccessPrefsCtrl();

    GeneralPreferencesGUI() {
        super(new GridBagLayout());
        this.createUserInterface();
    }

    void loadData(SquirrelPreferences prefs) {
        this._tabbedStyle.setSelected(prefs.getTabbedStyle());
        this._useScrollableTabbedPanesForSessionTabs.setSelected(prefs.getUseScrollableTabbedPanesForSessionTabs());
        this._internalFrameStyle.setSelected(!prefs.getTabbedStyle());
        this.onStyleChanged();
        this._showTabbedStyleHint.setSelected(prefs.getShowTabbedStyleHint());
        this._showContents.setSelected(prefs.getShowContentsWhenDragging());
        this._maximimizeSessionSheet.setSelected(prefs.getMaximizeSessionSheetOnOpen());
        this._showToolTips.setSelected(prefs.getShowToolTips());
        this._useScrollableTabbedPanes.setSelected(prefs.getUseScrollableTabbedPanes());
        this._showMainStatusBar.setSelected(prefs.getShowMainStatusBar());
        this._showMainToolBar.setSelected(prefs.getShowMainToolBar());
        this._showAliasesToolBar.setSelected(prefs.getShowAliasesToolBar());
        this._showDriversToolBar.setSelected(prefs.getShowDriversToolBar());
        this._showColoriconsInToolbar.setSelected(prefs.getShowColoriconsInToolbar());
        this._showPluginFilesInSplashScreen.setSelected(prefs.getShowPluginFilesInSplashScreen());
        this._useShortSessionTitle.setSelected(prefs.getUseShortSessionTitle());
        this._rememberValueOfPopup.setSelected(prefs.isRememberValueOfPopup());
        this._confirmSessionCloseChk.setSelected(prefs.getConfirmSessionClose());
        this._warnJreJdbcMismatch.setSelected(prefs.getWarnJreJdbcMismatch());
        this._warnForUnsavedFileEdits.setSelected(prefs.getWarnForUnsavedFileEdits());
        this._warnForUnsavedBufferEdits.setSelected(prefs.getWarnForUnsavedBufferEdits());
        this._showSessionStartupTimeHint.setSelected(prefs.getShowSessionStartupTimeHint());
        this._saveNoPreferencesImmediatelyNone.setSelected(true);
        this._saveAliasesAndDriversImmediately.setSelected(prefs.getSaveAliasesAndDriversImmediately());
        this._savePreferencesImmediately.setSelected(prefs.getSavePreferencesImmediately());
        this._selectOnRightMouseClick.setSelected(prefs.getSelectOnRightMouseClick());
        this._showPleaseWaitDialog.setSelected(prefs.getShowPleaseWaitDialog());
        this._maxColumnAdjustLengthCtrl.init(prefs.getMaxColumnAdjustLengthDefined(), prefs.getMaxColumnAdjustLength());
        LocaleWrapper.setSelectedLocalePrefsString(this._localeChooser, prefs.getPreferredLocale());
        this._tabbedStyle.addActionListener(e -> this.onStyleChanged());
        this._internalFrameStyle.addActionListener(e -> this.onStyleChanged());
        this._messagePrefsCtrl.loadData(prefs);
        this._passwordAccessPrefsCtrl.loadData(prefs);
    }

    private void onStyleChanged() {
        this._useScrollableTabbedPanesForSessionTabs.setEnabled(this._tabbedStyle.isSelected());
        this._showContents.setEnabled(this._internalFrameStyle.isSelected());
        this._maximimizeSessionSheet.setEnabled(this._internalFrameStyle.isSelected());
        this._showTabbedStyleHint.setEnabled(this._internalFrameStyle.isSelected());
    }

    void applyChanges(SquirrelPreferences prefs) {
        prefs.setTabbedStyle(this._tabbedStyle.isSelected());
        prefs.setUseScrollableTabbedPanesForSessionTabs(this._useScrollableTabbedPanesForSessionTabs.isSelected());
        prefs.setShowContentsWhenDragging(this._showContents.isSelected());
        prefs.setShowTabbedStyleHint(this._showTabbedStyleHint.isSelected());
        prefs.setShowToolTips(this._showToolTips.isSelected());
        prefs.setUseScrollableTabbedPanes(this._useScrollableTabbedPanes.isSelected());
        prefs.setShowMainStatusBar(this._showMainStatusBar.isSelected());
        prefs.setShowMainToolBar(this._showMainToolBar.isSelected());
        prefs.setShowAliasesToolBar(this._showAliasesToolBar.isSelected());
        prefs.setShowDriversToolBar(this._showDriversToolBar.isSelected());
        prefs.setMaximizeSessionSheetOnOpen(this._maximimizeSessionSheet.isSelected());
        prefs.setShowColoriconsInToolbar(this._showColoriconsInToolbar.isSelected());
        prefs.setShowPluginFilesInSplashScreen(this._showPluginFilesInSplashScreen.isSelected());
        prefs.setUseShortSessionTitle(this._useShortSessionTitle.isSelected());
        prefs.setRememberValueOfPopup(this._rememberValueOfPopup.isSelected());
        prefs.setConfirmSessionClose(this._confirmSessionCloseChk.isSelected());
        prefs.setWarnJreJdbcMismatch(this._warnJreJdbcMismatch.isSelected());
        prefs.setWarnForUnsavedFileEdits(this._warnForUnsavedFileEdits.isSelected());
        prefs.setWarnForUnsavedBufferEdits(this._warnForUnsavedBufferEdits.isSelected());
        prefs.setShowSessionStartupTimeHint(this._showSessionStartupTimeHint.isSelected());
        prefs.setSaveAliasesAndDriversImmediately(this._saveAliasesAndDriversImmediately.isSelected());
        prefs.setSavePreferencesImmediately(this._savePreferencesImmediately.isSelected());
        prefs.setSelectOnRightMouseClick(this._selectOnRightMouseClick.isSelected());
        prefs.setShowPleaseWaitDialog(this._showPleaseWaitDialog.isSelected());
        prefs.setPreferredLocale(LocaleWrapper.getSelectedLocalePrefsString(this._localeChooser));
        prefs.setMaxColumnAdjustLengthDefined(this._maxColumnAdjustLengthCtrl.isMaxColumnAdjustLengthDefined());
        prefs.setMaxColumnAdjustLength(this._maxColumnAdjustLengthCtrl.getMaxColumnAdjustLength());
        this._messagePrefsCtrl.applyChanges(prefs);
        this._passwordAccessPrefsCtrl.applyChanges(prefs);
    }

    private void createUserInterface() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        this.add((Component)this.createAppearancePanel(), gbc);
        ++gbc.gridx;
        this.add((Component)this.createGeneralPanel(), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        this.add((Component)this.createLoggingPanel(), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        this.add((Component)this.createPathsPanel(), gbc);
    }

    private JPanel createAppearancePanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("GeneralPreferencesPanel.appearance")));
        pnl.setLayout(new GridBagLayout());
        ButtonGroup g = new ButtonGroup();
        g.add(this._tabbedStyle);
        g.add(this._internalFrameStyle);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(2, 4, 2, 4);
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.insets.top = 0;
        gbc.gridy = 0;
        this._tabbedStyle.setName("tabbedStyleRadioButton");
        pnl.add((Component)this._tabbedStyle, gbc);
        ++gbc.gridy;
        this._internalFrameStyle.setName("internalFrameStyleRadioButton");
        pnl.add((Component)this._internalFrameStyle, gbc);
        ++gbc.gridy;
        this._useScrollableTabbedPanesForSessionTabs.setName("useScrollableTabbedPanes");
        pnl.add((Component)this._useScrollableTabbedPanesForSessionTabs, gbc);
        ++gbc.gridy;
        this._showContents.setName("showContentsCheckBox");
        pnl.add((Component)this._showContents, gbc);
        ++gbc.gridy;
        this._maximimizeSessionSheet.setName("maximizeSessionSheetCheckBox");
        pnl.add((Component)this._maximimizeSessionSheet, gbc);
        ++gbc.gridy;
        this._showTabbedStyleHint.setName("showTabbedStyleHintCheckBox");
        pnl.add((Component)this._showTabbedStyleHint, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._showToolTips, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._useScrollableTabbedPanes, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._showMainToolBar, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._showMainStatusBar, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._showDriversToolBar, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._showAliasesToolBar, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._showColoriconsInToolbar, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._showPluginFilesInSplashScreen, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._useShortSessionTitle, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._rememberValueOfPopup, gbc);
        ++gbc.gridy;
        GridBagConstraints gbcThemes = (GridBagConstraints)gbc.clone();
        gbcThemes.fill = 0;
        gbcThemes.anchor = 18;
        pnl.add((Component)new ThemesController(this._messagePrefsCtrl).getPanel(), gbcThemes);
        ++gbc.gridy;
        GridBagConstraints gbcMessagePanel = (GridBagConstraints)gbc.clone();
        gbcMessagePanel.fill = 0;
        gbcMessagePanel.anchor = 18;
        pnl.add((Component)this._messagePrefsCtrl.getPanel(), gbcMessagePanel);
        return pnl;
    }

    private JPanel createGeneralPanel() {
        JPanel pnl = new JPanel();
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("GeneralPreferencesPanel.general")));
        pnl.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(2, 4, 2, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        pnl.add((Component)this._confirmSessionCloseChk, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        pnl.add((Component)this._warnJreJdbcMismatch, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        pnl.add((Component)this._warnForUnsavedFileEdits, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        pnl.add((Component)this._warnForUnsavedBufferEdits, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        pnl.add((Component)this._showSessionStartupTimeHint, gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        pnl.add((Component)this.getSavePreferencesImmediatelyPanel(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 6;
        pnl.add((Component)this._selectOnRightMouseClick, gbc);
        gbc.gridx = 0;
        gbc.gridy = 7;
        pnl.add((Component)this._showPleaseWaitDialog, gbc);
        gbc.gridx = 0;
        gbc.gridy = 8;
        pnl.add((Component)this.createLocalePanel(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 9;
        pnl.add((Component)this._maxColumnAdjustLengthCtrl.getPanel(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 10;
        pnl.add((Component)this._passwordAccessPrefsCtrl.getPanel(), gbc);
        return pnl;
    }

    private JPanel createLocalePanel() {
        JPanel localePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0);
        localePanel.add((Component)new JLabel(s_stringMgr.getString("GeneralPreferencesPanel.localeChooserLabel")), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0);
        GUIUtils.setPreferredWidth(this._localeChooser, 300);
        localePanel.add((Component)this._localeChooser, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0);
        localePanel.add((Component)new JPanel(), gbc);
        return localePanel;
    }

    private JPanel getSavePreferencesImmediatelyPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)new MultipleLineLabel(s_stringMgr.getString("GeneralPreferencesPanel.savePreferencesImmediatelyWarning_new")), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 0, 0, 0), 0, 0);
        ret.add((Component)this._saveNoPreferencesImmediatelyNone, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 0, 0, 0), 0, 0);
        ret.add((Component)this._saveAliasesAndDriversImmediately, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 0, 0, 0), 0, 0);
        ret.add((Component)this._savePreferencesImmediately, gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._saveNoPreferencesImmediatelyNone);
        bg.add(this._saveAliasesAndDriversImmediately);
        bg.add(this._savePreferencesImmediately);
        ret.setBorder(BorderFactory.createEtchedBorder());
        return ret;
    }

    private JPanel createLoggingPanel() {
        JPanel pnl = new JPanel();
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("GeneralPreferencesPanel.logging")));
        pnl.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 4, 2, 4);
        ApplicationFiles appFiles = new ApplicationFiles();
        String execLogFile = appFiles.getExecutionLogFile().getPath();
        gbc.gridx = 0;
        gbc.gridy = 0;
        JTextField execLogFileField = new JTextField(s_stringMgr.getString("GeneralPreferencesPanel.execlogfileNew", execLogFile));
        GUIUtils.styleTextFieldToCopyableLabel(execLogFileField);
        pnl.add((Component)execLogFileField, gbc);
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        ++gbc.gridx;
        pnl.add((Component)new JPanel(), gbc);
        return pnl;
    }

    private JPanel createPathsPanel() {
        JPanel pnl = new JPanel();
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("GeneralPreferencesPanel.paths")));
        pnl.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 4, 2, 4);
        ApplicationFiles appFiles = new ApplicationFiles();
        String userDir = appFiles.getUserSettingsDirectory().getPath();
        String homeDir = appFiles.getSquirrelHomeDir().getPath();
        gbc.gridx = 0;
        gbc.gridy = 0;
        JTextField homePathField = new JTextField(s_stringMgr.getString("GeneralPreferencesPanel.squirrelHomePath", homeDir));
        GUIUtils.styleTextFieldToCopyableLabel(homePathField);
        pnl.add((Component)homePathField, gbc);
        ++gbc.gridy;
        JTextField userPathField = new JTextField(s_stringMgr.getString("GeneralPreferencesPanel.squirrelUserPath", userDir));
        GUIUtils.styleTextFieldToCopyableLabel(userPathField);
        pnl.add((Component)userPathField, gbc);
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        ++gbc.gridx;
        pnl.add((Component)new JPanel(), gbc);
        ++gbc.gridy;
        pnl.add((Component)new JPanel(), gbc);
        return pnl;
    }
}

