/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.GlobalPreferencesDialogFindInfo;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.PreferencesFindSupport;
import net.sourceforge.squirrel_sql.client.plugin.PluginInfo;
import net.sourceforge.squirrel_sql.client.preferences.DataTypePreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.GeneralPreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.GlobalPrefTabInfo;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.PreferenceType;
import net.sourceforge.squirrel_sql.client.preferences.PrefrenceTabActvivationListener;
import net.sourceforge.squirrel_sql.client.preferences.ProxyPreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.SQLPreferencesController;
import net.sourceforge.squirrel_sql.client.preferences.WikiTablePreferencesTab;
import net.sourceforge.squirrel_sql.client.preferences.codereformat.FormatSqlConfigPrefsTab;
import net.sourceforge.squirrel_sql.client.preferences.shortcut.ShortcutPrefsTab;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.prefs.DBDiffPreferencesPanel;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.prefs.SQLScriptPreferencesTab;
import net.sourceforge.squirrel_sql.fw.gui.CursorChanger;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class GlobalPreferencesSheet
extends DialogWidget {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GlobalPreferencesSheet.class);
    private static final ILogger s_log = LoggerController.createLogger(GlobalPreferencesSheet.class);
    private static GlobalPreferencesSheet s_instance;
    private List<IGlobalPreferencesPanel> _globalPreferencesPanels = new ArrayList<IGlobalPreferencesPanel>();
    private JTabbedPane _tabPane;
    private JLabel _titleLbl = new JLabel();
    public static final String PREF_KEY_GLOBAL_PREFS_SHEET_WIDTH = "Squirrel.globalPrefsSheetWidth";
    public static final String PREF_KEY_GLOBAL_PREFS_SHEET_HEIGHT = "Squirrel.globalPrefsSheetHeight";

    private GlobalPreferencesSheet() {
        this(false);
    }

    private GlobalPreferencesSheet(boolean toUseByPreferencesFinderOnly) {
        super(s_stringMgr.getString("GlobalPreferencesSheet.title"), true);
        this.createGUI();
        for (IGlobalPreferencesPanel pnl : this._globalPreferencesPanels) {
            try {
                pnl.initialize(Main.getApplication());
            }
            catch (Throwable th) {
                String msg = s_stringMgr.getString("GlobalPreferencesSheet.error.loading", pnl.getTitle());
                s_log.error(msg, th);
                Main.getApplication().showErrorDialog(msg, th);
            }
        }
        this.setSize(this.getDimension());
        if (!toUseByPreferencesFinderOnly) {
            Main.getApplication().getMainFrame().addWidget(this);
            DialogWidget.centerWithinDesktop(this);
            this.setVisible(true);
        }
    }

    public static PreferencesFindSupport<GlobalPreferencesDialogFindInfo> getPreferencesFindSupport() {
        return ofOpenDialog -> GlobalPreferencesSheet.onCreateFindInfo(ofOpenDialog);
    }

    private static GlobalPreferencesDialogFindInfo onCreateFindInfo(boolean ofOpenDialog) {
        GlobalPreferencesSheet prefsFinderInstance;
        if (ofOpenDialog) {
            GlobalPreferencesSheet.showSheet(null);
        }
        if (null == (prefsFinderInstance = s_instance)) {
            prefsFinderInstance = new GlobalPreferencesSheet(true);
        }
        return new GlobalPreferencesDialogFindInfo(prefsFinderInstance.getTitle(), prefsFinderInstance._tabPane);
    }

    private Dimension getDimension() {
        return new Dimension(Props.getInt(PREF_KEY_GLOBAL_PREFS_SHEET_WIDTH, 650), Props.getInt(PREF_KEY_GLOBAL_PREFS_SHEET_HEIGHT, 600));
    }

    public static void showSheet(Class componentClassOfTabToSelect) {
        if (s_instance == null) {
            s_instance = new GlobalPreferencesSheet();
        } else {
            s_instance.moveToFront();
        }
        if (null != componentClassOfTabToSelect) {
            s_instance.selectTab(componentClassOfTabToSelect);
        }
    }

    private static GlobalPreferencesDialogFindInfo createPreferencesFinderInfo() {
        GlobalPreferencesSheet prefsFinderInstance = s_instance;
        if (null == prefsFinderInstance) {
            prefsFinderInstance = new GlobalPreferencesSheet(true);
        }
        return new GlobalPreferencesDialogFindInfo(prefsFinderInstance.getTitle(), prefsFinderInstance._tabPane);
    }

    private void selectTab(Class componentClassOfTabToSelect) {
        GlobalPrefTabInfo info = this.findTabInfoByComponentClass(componentClassOfTabToSelect);
        if (null != info) {
            this._tabPane.setSelectedIndex(info.getTabIndex());
        }
    }

    private GlobalPrefTabInfo findTabInfoByComponentClass(Class componentClass) {
        for (int i = 0; i < this._tabPane.getTabCount(); ++i) {
            JScrollPane wrappingScrollPane = null;
            Component comp = this._tabPane.getComponentAt(i);
            if (JScrollPane.class.equals(comp.getClass())) {
                wrappingScrollPane = (JScrollPane)comp;
                comp = ((JScrollPane)comp).getViewport().getView();
            }
            if (!componentClass.equals(comp.getClass())) continue;
            return new GlobalPrefTabInfo(i, componentClass, comp, wrappingScrollPane);
        }
        return null;
    }

    @Override
    public void dispose() {
        Dimension size = this.getSize();
        Props.putInt(PREF_KEY_GLOBAL_PREFS_SHEET_WIDTH, size.width);
        Props.putInt(PREF_KEY_GLOBAL_PREFS_SHEET_HEIGHT, size.height);
        for (IGlobalPreferencesPanel pnl : this._globalPreferencesPanels) {
            pnl.uninitialize(Main.getApplication());
        }
        s_instance = null;
        super.dispose();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this._titleLbl.setText(title);
    }

    private void performClose() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performOk() {
        CursorChanger cursorChg = new CursorChanger(Main.getApplication().getMainFrame());
        cursorChg.show();
        try {
            for (IGlobalPreferencesPanel pnl : this._globalPreferencesPanels) {
                try {
                    pnl.applyChanges();
                }
                catch (Throwable th) {
                    String msg = s_stringMgr.getString("GlobalPreferencesSheet.error.saving", pnl.getTitle());
                    s_log.error(msg, th);
                    Main.getApplication().showErrorDialog(msg, th);
                }
            }
        }
        finally {
            Main.getApplication().savePreferences(PreferenceType.DATATYPE_PREFERENCES);
            cursorChg.restore();
        }
        this.dispose();
    }

    private void createGUI() {
        this.setDefaultCloseOperation(2);
        this.makeToolWindow(true);
        PrefrenceTabActvivationListener prefrenceTabActvivationListener = new PrefrenceTabActvivationListener(){

            @Override
            public void activateTabForClass(Class<?> tabClass) {
                GlobalPreferencesSheet.this.selectTab(tabClass);
            }
        };
        this._globalPreferencesPanels.add(new GeneralPreferencesPanel());
        this._globalPreferencesPanels.add(new SQLPreferencesController());
        this._globalPreferencesPanels.add(new ProxyPreferencesPanel());
        this._globalPreferencesPanels.add(new DataTypePreferencesPanel());
        this._globalPreferencesPanels.add(new WikiTablePreferencesTab());
        this._globalPreferencesPanels.add(new FormatSqlConfigPrefsTab(Main.getApplication()));
        this._globalPreferencesPanels.add(new ShortcutPrefsTab());
        this._globalPreferencesPanels.add(new SQLScriptPreferencesTab());
        this._globalPreferencesPanels.add(new DBDiffPreferencesPanel());
        PluginInfo[] plugins = Main.getApplication().getPluginManager().getPluginInformation();
        for (int plugIdx = 0; plugIdx < plugins.length; ++plugIdx) {
            IGlobalPreferencesPanel[] pnls;
            PluginInfo pi = plugins[plugIdx];
            if (!pi.isLoaded() || (pnls = pi.getPlugin().getGlobalPreferencePanels()) == null || pnls.length <= 0) continue;
            for (int pnlIdx = 0; pnlIdx < pnls.length; ++pnlIdx) {
                this._globalPreferencesPanels.add(pnls[pnlIdx]);
            }
        }
        this._tabPane = UIFactory.getInstance().createTabbedPane();
        for (IGlobalPreferencesPanel pnl : this._globalPreferencesPanels) {
            String pnlTitle = pnl.getTitle();
            String hint = pnl.getHint();
            this._tabPane.addTab(pnlTitle, null, pnl.getPanelComponent(), hint);
        }
        JPanel contentPane = new JPanel();
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.setContentPane(contentPane);
        GridBagConstraints gbc = new GridBagConstraints();
        contentPane.setLayout(new GridBagLayout());
        gbc.gridwidth = 1;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        contentPane.add((Component)this._titleLbl, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        contentPane.add((Component)this._tabPane, gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        contentPane.add((Component)this.createButtonsPanel(), gbc);
        GUIUtils.enableCloseByEscape(this, dw -> this.performClose());
    }

    private JPanel createButtonsPanel() {
        JPanel pnl = new JPanel();
        JButton okBtn = new JButton(s_stringMgr.getString("GlobalPreferencesSheet.ok"));
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GlobalPreferencesSheet.this.performOk();
            }
        });
        JButton closeBtn = new JButton(s_stringMgr.getString("GlobalPreferencesSheet.close"));
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GlobalPreferencesSheet.this.performClose();
            }
        });
        GUIUtils.setJButtonSizesTheSame(okBtn, closeBtn);
        pnl.add(okBtn);
        pnl.add(closeBtn);
        this.getRootPane().setDefaultButton(okBtn);
        return pnl;
    }
}

