/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences;

import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JComboBox;
import net.sourceforge.squirrel_sql.client.preferences.LocaleWrapperType;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.fw.util.LocaleUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import org.apache.commons.lang3.StringUtils;

public class LocaleWrapper {
    private LocaleWrapperType _localeWrapperType = LocaleWrapperType.DONT_CHANGE;
    private String _localeString;

    private LocaleWrapper(String localeString) {
        this(localeString, LocaleWrapperType.LOCALE);
    }

    private LocaleWrapper(LocaleWrapperType localeWrapperType) {
        this(null, localeWrapperType);
    }

    private LocaleWrapper(String localeString, LocaleWrapperType localeWrapperType) {
        this._localeString = localeString;
        this._localeWrapperType = localeWrapperType;
    }

    public static Locale constructPreferredLocale(SquirrelPreferences prefs) {
        String[] parts;
        String langCountryPair = prefs.getPreferredLocale();
        if (LocaleWrapperType.isNewOrOldDontChangeString(langCountryPair)) {
            return null;
        }
        if (LocaleWrapper.shallBeInterpretedAsDefaultEnglishUS(langCountryPair)) {
            langCountryPair = "en_US";
        }
        if ((parts = langCountryPair.split("_")).length == 2) {
            return new Locale(parts[0], parts[1]);
        }
        return new Locale(parts[0]);
    }

    private static boolean shallBeInterpretedAsDefaultEnglishUS(String langCountryPair) {
        return StringUtils.isEmpty((CharSequence)langCountryPair);
    }

    public String toString() {
        switch (this._localeWrapperType) {
            case DONT_CHANGE: {
                return StringManagerFactory.getStringManager(LocaleWrapper.class).getString("preferences.dont.change.locale");
            }
            case LOCALE: {
                return this.getLocaleDisplayString();
            }
        }
        throw new IllegalStateException("Should not land here. Type is: " + this._localeWrapperType.name());
    }

    private String getLocaleDisplayString() {
        if (LocaleWrapper.shallBeInterpretedAsDefaultEnglishUS(this._localeString)) {
            return StringManagerFactory.getStringManager(LocaleWrapper.class).getString("preferences.default.locale.en_US");
        }
        return this._localeString;
    }

    public static LocaleWrapper[] getAvailableLocaleWrappers() {
        ArrayList<LocaleWrapper> ret = new ArrayList<LocaleWrapper>();
        ret.add(new LocaleWrapper(LocaleWrapperType.DONT_CHANGE));
        for (String localeString : LocaleUtils.getAvailableLocaleStrings()) {
            ret.add(new LocaleWrapper(localeString));
        }
        return ret.toArray(new LocaleWrapper[0]);
    }

    public static String getSelectedLocalePrefsString(JComboBox localeChooser) {
        String ret = LocaleWrapperType.DONT_CHANGE.name();
        LocaleWrapper selectedWrapper = (LocaleWrapper)localeChooser.getSelectedItem();
        if (null != selectedWrapper && selectedWrapper._localeWrapperType == LocaleWrapperType.LOCALE) {
            ret = selectedWrapper._localeString;
        }
        return ret;
    }

    public static void setSelectedLocalePrefsString(JComboBox localeChooser, String localePrefsString) {
        LocaleWrapper selectedWrapper = LocaleWrapper.getDontChangeWrapperFromModel(localeChooser);
        for (int i = 0; i < localeChooser.getModel().getSize(); ++i) {
            LocaleWrapper buf = (LocaleWrapper)localeChooser.getModel().getElementAt(i);
            if (buf._localeWrapperType != LocaleWrapperType.LOCALE || !LocaleWrapper.isSameLocale(localePrefsString, buf)) continue;
            selectedWrapper = buf;
            break;
        }
        localeChooser.setSelectedItem(selectedWrapper);
    }

    private static boolean isSameLocale(String localePrefsString, LocaleWrapper buf) {
        if (StringUtilities.isEmpty(localePrefsString, true) && StringUtilities.isEmpty(buf._localeString, true)) {
            return true;
        }
        return Utilities.equalsRespectNull(localePrefsString, buf._localeString);
    }

    private static LocaleWrapper getDontChangeWrapperFromModel(JComboBox localeChooser) {
        return (LocaleWrapper)localeChooser.getModel().getElementAt(0);
    }
}

