/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.PreferencesFindSupport;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.SessionPropertiesDialogFindInfo;
import net.sourceforge.squirrel_sql.client.plugin.PluginInfo;
import net.sourceforge.squirrel_sql.client.preferences.INewSessionPropertiesPanel;
import net.sourceforge.squirrel_sql.client.session.properties.GeneralSessionPropertiesPanel;
import net.sourceforge.squirrel_sql.client.session.properties.SessionObjectTreePropertiesPanel;
import net.sourceforge.squirrel_sql.client.session.properties.SessionSQLPropertiesPanel;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class NewSessionPropertiesSheet
extends DialogWidget {
    public static final String PREF_KEY_NEW_SESSION_PROPS_SHEET_WIDTH = "Squirrel.newSessionPropsSheetWidth";
    public static final String PREF_KEY_NEW_SESSION_PROPS_SHEET_HEIGHT = "Squirrel.newSessionPropsSheetHeight";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(NewSessionPropertiesSheet.class);
    private static final ILogger s_log = LoggerController.createLogger(NewSessionPropertiesSheet.class);
    private static NewSessionPropertiesSheet s_instance;
    private JLabel _titleLbl = new JLabel();
    private List<INewSessionPropertiesPanel> _panels = new ArrayList<INewSessionPropertiesPanel>();
    private JTabbedPane _tabbedPane;

    private NewSessionPropertiesSheet() {
        this(false);
    }

    private NewSessionPropertiesSheet(boolean toUseByPropertiesFinderOnly) {
        super(s_stringMgr.getString("NewSessionPropertiesSheet.title"), true);
        this.setDefaultCloseOperation(1);
        this.createGUI();
        for (INewSessionPropertiesPanel pnl : this._panels) {
            pnl.initialize(Main.getApplication());
        }
        this.setSize(this.getDimension());
        if (!toUseByPropertiesFinderOnly) {
            Main.getApplication().getMainFrame().addWidget(this);
            DialogWidget.centerWithinDesktop(this);
            this.setVisible(true);
        }
    }

    public static SessionPropertiesDialogFindInfo createPropertiesFinderInfo() {
        NewSessionPropertiesSheet newSessionPropertiesSheet = s_instance;
        if (null == newSessionPropertiesSheet) {
            newSessionPropertiesSheet = new NewSessionPropertiesSheet(true);
        }
        return new SessionPropertiesDialogFindInfo(newSessionPropertiesSheet.getTitle(), newSessionPropertiesSheet._tabbedPane);
    }

    public static PreferencesFindSupport<SessionPropertiesDialogFindInfo> getPreferencesFindSupport() {
        return new PreferencesFindSupport<SessionPropertiesDialogFindInfo>(){

            @Override
            public SessionPropertiesDialogFindInfo createFindInfo(boolean ofOpenDialog) {
                return NewSessionPropertiesSheet.onCreateFindInfo(ofOpenDialog);
            }
        };
    }

    private static SessionPropertiesDialogFindInfo onCreateFindInfo(boolean ofOpenDialog) {
        NewSessionPropertiesSheet newSessionPropertiesSheet;
        if (ofOpenDialog) {
            NewSessionPropertiesSheet.showSheet();
        }
        if (null == (newSessionPropertiesSheet = s_instance)) {
            newSessionPropertiesSheet = new NewSessionPropertiesSheet(true);
        }
        return new SessionPropertiesDialogFindInfo(newSessionPropertiesSheet.getTitle(), newSessionPropertiesSheet._tabbedPane);
    }

    private Dimension getDimension() {
        return new Dimension(Props.getInt(PREF_KEY_NEW_SESSION_PROPS_SHEET_WIDTH, 500), Props.getInt(PREF_KEY_NEW_SESSION_PROPS_SHEET_HEIGHT, 600));
    }

    public static void showSheet() {
        NewSessionPropertiesSheet.showSheet(null);
    }

    public static void showSheet(Integer tabIndexToSelect) {
        if (s_instance == null) {
            s_instance = new NewSessionPropertiesSheet();
        } else {
            s_instance.moveToFront();
        }
        if (null != tabIndexToSelect) {
            s_instance.selectTabIndex(tabIndexToSelect);
        }
    }

    public void selectTabIndex(int index) {
        int tabCount = this._tabbedPane.getTabCount();
        if (0 <= index && index < tabCount) {
            this._tabbedPane.setSelectedIndex(index);
        }
    }

    @Override
    public void dispose() {
        Dimension size = this.getSize();
        Props.putInt(PREF_KEY_NEW_SESSION_PROPS_SHEET_WIDTH, size.width);
        Props.putInt(PREF_KEY_NEW_SESSION_PROPS_SHEET_HEIGHT, size.height);
        s_instance = null;
        super.dispose();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this._titleLbl.setText(title);
    }

    private void performClose() {
        this.dispose();
    }

    private void performOk() {
        boolean isDebug = s_log.isDebugEnabled();
        long start = 0L;
        Iterator<INewSessionPropertiesPanel> it = this._panels.iterator();
        while (it.hasNext()) {
            if (isDebug) {
                start = System.currentTimeMillis();
            }
            INewSessionPropertiesPanel pnl = it.next();
            pnl.applyChanges();
            if (!isDebug) continue;
            s_log.debug("Panel " + pnl.getTitle() + " applied changes in " + (System.currentTimeMillis() - start) + "ms");
        }
        this.dispose();
    }

    private void createGUI() {
        this.setDefaultCloseOperation(2);
        this.makeToolWindow(true);
        this._panels.add(new GeneralSessionPropertiesPanel());
        this._panels.add(new SessionObjectTreePropertiesPanel(Main.getApplication()));
        this._panels.add(new SessionSQLPropertiesPanel(null));
        PluginInfo[] plugins = Main.getApplication().getPluginManager().getPluginInformation();
        for (int plugIdx = 0; plugIdx < plugins.length; ++plugIdx) {
            INewSessionPropertiesPanel[] pnls;
            PluginInfo pi = plugins[plugIdx];
            if (!pi.isLoaded() || (pnls = pi.getPlugin().getNewSessionPropertiesPanels()) == null || pnls.length <= 0) continue;
            for (int pnlIdx = 0; pnlIdx < pnls.length; ++pnlIdx) {
                this._panels.add(pnls[pnlIdx]);
            }
        }
        this._tabbedPane = UIFactory.getInstance().createTabbedPane();
        for (INewSessionPropertiesPanel pnl : this._panels) {
            String winTitle = pnl.getTitle();
            String hint = pnl.getHint();
            this._tabbedPane.addTab(winTitle, null, pnl.getPanelComponent(), hint);
        }
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.setContentPane(contentPane);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        contentPane.add((Component)this._titleLbl, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        contentPane.add((Component)this._tabbedPane, gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        contentPane.add((Component)this.createButtonsPanel(), gbc);
        GUIUtils.enableCloseByEscape(this);
    }

    private JPanel createButtonsPanel() {
        JPanel pnl = new JPanel();
        JButton okBtn = new JButton(s_stringMgr.getString("NewSessionPropertiesSheet.ok"));
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewSessionPropertiesSheet.this.performOk();
            }
        });
        JButton closeBtn = new JButton(s_stringMgr.getString("NewSessionPropertiesSheet.close"));
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewSessionPropertiesSheet.this.performClose();
            }
        });
        pnl.add(okBtn);
        pnl.add(closeBtn);
        GUIUtils.setJButtonSizesTheSame(okBtn, closeBtn);
        this.getRootPane().setDefaultButton(okBtn);
        return pnl;
    }
}

