/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.SQLPreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackPrefsPanelController;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SQLPreferencesController
implements IGlobalPreferencesPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLPreferencesController.class);
    private SQLPreferencesPanel _panel;
    private JScrollPane _scrollPane;
    private ChangeTrackPrefsPanelController _changeTrackPrefsPanelController = new ChangeTrackPrefsPanelController();

    @Override
    public void initialize(IApplication app) {
        this.getPanelComponent();
        this.loadData();
        this._panel.fileOpenInPreviousDir.addActionListener(e -> this.updateFilePanel(this._panel));
        this._panel.fileOpenInSpecifiedDir.addActionListener(e -> this.updateFilePanel(this._panel));
        this.updateFilePanel(this._panel);
        this._panel.fileChooseDir.addActionListener(e -> this.onChooseDir(this._panel));
    }

    void loadData() {
        SquirrelPreferences prefs = Main.getApplication().getSquirrelPreferences();
        this._panel.loginTimeout.setInt(prefs.getLoginTimeout());
        this._panel.largeScriptStmtCount.setInt(prefs.getLargeScriptStmtCount());
        this._panel.queryTimeout.setInt(prefs.getQueryTimeout());
        this._panel.chkCopyQuotedSqlsToClip.setSelected(prefs.getCopyQuotedSqlsToClip());
        this._panel.chkAllowRunAllSQLsInEditor.setSelected(prefs.getAllowRunAllSQLsInEditor());
        this._panel.chkMarkCurrentSql.setSelected(prefs.isMarkCurrentSql());
        this._panel.getCurrentSqlMarkColorIcon().setColor(new Color(prefs.getCurrentSqlMarkColorRGB()));
        this.initCurrentMarkGui();
        this._panel.chkUseStatementSeparatorAsSqlToExecuteBounds.setSelected(prefs.isUseStatementSeparatorAsSqlToExecuteBounds());
        this._panel.chkReloadSqlContentsSql.setSelected(prefs.isReloadSqlContents());
        this._panel.txtMaxTextOutputColumnWidth.setInt(prefs.getMaxTextOutputColumnWidth());
        this._panel.chkNotifyExternalFileChanges.setSelected(prefs.isNotifyExternalFileChanges());
        this._panel.debugJdbcStream.setSelected(prefs.isJdbcDebugToStream());
        this._panel.debugJdbcWriter.setSelected(prefs.isJdbcDebugToWriter());
        this._panel.debugJdbcDont.setSelected(prefs.isJdbcDebugDontDebug());
        this._panel.jdbcDebugLogFileNameLbl.setText(new ApplicationFiles().getJDBCDebugLogFile().getPath());
        this._panel.fileOpenInPreviousDir.setSelected(prefs.isFileOpenInPreviousDir());
        this._panel.fileOpenInSpecifiedDir.setSelected(prefs.isFileOpenInSpecifiedDir());
        this._panel.fileSpecifiedDir.setText(prefs.getFileSpecifiedDir());
        this._changeTrackPrefsPanelController.loadData(prefs);
    }

    @Override
    public void applyChanges() {
        SquirrelPreferences prefs = Main.getApplication().getSquirrelPreferences();
        prefs.setLoginTimeout(this._panel.loginTimeout.getInt());
        prefs.setLargeScriptStmtCount(this._panel.largeScriptStmtCount.getInt());
        prefs.setQueryTimeout(this._panel.queryTimeout.getInt());
        prefs.setCopyQuotedSqlsToClip(this._panel.chkCopyQuotedSqlsToClip.isSelected());
        prefs.setAllowRunAllSQLsInEditor(this._panel.chkAllowRunAllSQLsInEditor.isSelected());
        prefs.setMarkCurrentSql(this._panel.chkMarkCurrentSql.isSelected());
        prefs.setCurrentSqlMarkColorRGB(this._panel.getCurrentSqlMarkColorIcon().getColor().getRGB());
        prefs.setUseStatementSeparatorAsSqlToExecuteBounds(this._panel.chkUseStatementSeparatorAsSqlToExecuteBounds.isSelected());
        prefs.setReloadSqlContents(this._panel.chkReloadSqlContentsSql.isSelected());
        int maxTextOutputColumnWidth = this._panel.txtMaxTextOutputColumnWidth.getInt();
        if (3 <= maxTextOutputColumnWidth) {
            prefs.setMaxTextOutputColumnWidth(maxTextOutputColumnWidth);
        }
        prefs.setNotifyExternalFileChanges(this._panel.chkNotifyExternalFileChanges.isSelected());
        if (this._panel.debugJdbcStream.isSelected()) {
            prefs.doJdbcDebugToStream();
        } else if (this._panel.debugJdbcWriter.isSelected()) {
            prefs.doJdbcDebugToWriter();
        } else {
            prefs.dontDoJdbcDebug();
        }
        prefs.setFileOpenInPreviousDir(this._panel.fileOpenInPreviousDir.isSelected());
        prefs.setFileOpenInSpecifiedDir(this._panel.fileOpenInSpecifiedDir.isSelected());
        String specDir = this._panel.fileSpecifiedDir.getText();
        prefs.setFileSpecifiedDir(null == specDir ? "" : specDir);
        this._changeTrackPrefsPanelController.applyChanges(prefs);
    }

    private void initCurrentMarkGui() {
        this._panel.btnCurrentSqlMarkColorRGB.setEnabled(this._panel.chkMarkCurrentSql.isSelected());
        this._panel.chkMarkCurrentSql.addActionListener(e -> this._panel.btnCurrentSqlMarkColorRGB.setEnabled(this._panel.chkMarkCurrentSql.isSelected()));
        this._panel.btnCurrentSqlMarkColorRGB.addActionListener(e -> this.onChooseCurrentMarkColor());
    }

    private void onChooseCurrentMarkColor() {
        String title = s_stringMgr.getString("SQLPreferencesPanel.current.sql.mark.color.choose");
        Color color = JColorChooser.showDialog(this._panel, title, this._panel.getCurrentSqlMarkColorIcon().getColor());
        if (null != color) {
            this._panel.getCurrentSqlMarkColorIcon().setColor(color);
        }
    }

    @Override
    public void uninitialize(IApplication app) {
    }

    public void onChooseDir(SQLPreferencesPanel pnl) {
        JFileChooser chooser = new JFileChooser(pnl.fileSpecifiedDir.getText());
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showOpenDialog(Main.getApplication().getMainFrame());
        if (returnVal == 0) {
            pnl.fileSpecifiedDir.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void updateFilePanel(SQLPreferencesPanel pnl) {
        pnl.fileChooseDir.setEnabled(pnl.fileOpenInSpecifiedDir.isSelected());
        pnl.fileSpecifiedDir.setEnabled(pnl.fileOpenInSpecifiedDir.isSelected());
    }

    @Override
    public Component getPanelComponent() {
        if (this._panel == null) {
            this._panel = new SQLPreferencesPanel(this._changeTrackPrefsPanelController.getPanel());
            this._scrollPane = new JScrollPane(this._panel);
            GUIUtils.forceScrollToBegin(this._scrollPane);
        }
        return this._scrollPane;
    }

    @Override
    public String getTitle() {
        return s_stringMgr.getString("SQLPreferencesPanel.title");
    }

    @Override
    public String getHint() {
        return s_stringMgr.getString("SQLPreferencesPanel.hint");
    }
}

