/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.preferences.ColorIcon;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackPrefsPanel;
import net.sourceforge.squirrel_sql.fw.gui.IntegerField;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.gui.OutputLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public final class SQLPreferencesPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLPreferencesPanel.class);
    JRadioButton fileOpenInPreviousDir = new JRadioButton(s_stringMgr.getString("SQLPreferencesPanel.fileOpenInPreviousDir"));
    JRadioButton fileOpenInSpecifiedDir = new JRadioButton(s_stringMgr.getString("SQLPreferencesPanel.fileOpenInSpecifiedDir"));
    JTextField fileSpecifiedDir = new JTextField();
    JButton fileChooseDir = new JButton("...");
    IntegerField loginTimeout = new IntegerField();
    IntegerField largeScriptStmtCount = new IntegerField();
    IntegerField queryTimeout = new IntegerField();
    JCheckBox chkCopyQuotedSqlsToClip = new JCheckBox(s_stringMgr.getString("SQLPreferencesPanel.copy.quoted.sql.to.clip"));
    JCheckBox chkAllowRunAllSQLsInEditor = new JCheckBox(s_stringMgr.getString("SQLPreferencesPanel.allow.run.all.sqls.in.editor"));
    JCheckBox chkMarkCurrentSql = new JCheckBox(s_stringMgr.getString("SQLPreferencesPanel.mark.current.sql"));
    JButton btnCurrentSqlMarkColorRGB = new JButton();
    JCheckBox chkUseStatementSeparatorAsSqlToExecuteBounds = new JCheckBox(s_stringMgr.getString("SQLPreferencesPanel.use.statement.separator.as.current.bounds"));
    JCheckBox chkReloadSqlContentsSql = new JCheckBox(s_stringMgr.getString("SQLPreferencesPanel.reload.sql.contents"));
    IntegerField txtMaxTextOutputColumnWidth = new IntegerField();
    JCheckBox chkNotifyExternalFileChanges = new JCheckBox(s_stringMgr.getString("SQLPreferencesPanel.notify.external.file.changes"));
    JRadioButton debugJdbcDont = new JRadioButton(s_stringMgr.getString("SQLPreferencesPanel.jdbcdebugdont"));
    JRadioButton debugJdbcStream = new JRadioButton(s_stringMgr.getString("SQLPreferencesPanel.jdbcdebugstream"));
    JRadioButton debugJdbcWriter = new JRadioButton(s_stringMgr.getString("SQLPreferencesPanel.jdbcdebugwriter"));
    JLabel jdbcDebugLogFileNameLbl = new OutputLabel(" ");

    SQLPreferencesPanel(ChangeTrackPrefsPanel changeTrackPrefsPanel) {
        super(new GridBagLayout());
        this.createUserInterface(changeTrackPrefsPanel);
    }

    ColorIcon getCurrentSqlMarkColorIcon() {
        return (ColorIcon)this.btnCurrentSqlMarkColorRGB.getIcon();
    }

    private void createUserInterface(ChangeTrackPrefsPanel panel) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        this.add((Component)this.createGeneralPanel(), gbc);
        ++gbc.gridy;
        this.add(this.createFilePanel(), gbc);
        ++gbc.gridy;
        this.add((Component)panel, gbc);
        ++gbc.gridy;
        this.add((Component)this.createDebugPanel(), gbc);
    }

    private JPanel createGeneralPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("SQLPreferencesPanel.general")));
        this.loginTimeout.setColumns(4);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        pnl.add((Component)new JLabel(s_stringMgr.getString("SQLPreferencesPanel.logintimeout")), gbc);
        ++gbc.gridx;
        pnl.add((Component)this.loginTimeout, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        pnl.add((Component)new JLabel(s_stringMgr.getString("SQLPreferencesPanel.zerounlimited")), gbc);
        this.largeScriptStmtCount.setColumns(4);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 1;
        pnl.add((Component)new JLabel(s_stringMgr.getString("SQLPreferencesPanel.query.timeout")), gbc);
        ++gbc.gridx;
        this.queryTimeout.setColumns(4);
        pnl.add((Component)this.queryTimeout, gbc);
        ++gbc.gridx;
        pnl.add((Component)new JLabel(s_stringMgr.getString("SQLPreferencesPanel.query.timeout.zero.means.no.limit")), gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        pnl.add((Component)new JLabel(s_stringMgr.getString("SQLPreferencesPanel.largeScriptStmtCount")), gbc);
        ++gbc.gridx;
        pnl.add((Component)this.largeScriptStmtCount, gbc);
        ++gbc.gridx;
        gbc.fill = 2;
        pnl.add((Component)new MultipleLineLabel(s_stringMgr.getString("SQLPreferencesPanel.largeScriptStmtCount.note")), gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 0;
        pnl.add((Component)this.chkCopyQuotedSqlsToClip, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 0;
        pnl.add((Component)this.chkAllowRunAllSQLsInEditor, gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 0;
        gbc.fill = 0;
        pnl.add((Component)this.createCurrentSqlMarkPanel(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 0;
        gbc.fill = 0;
        pnl.add((Component)this.chkUseStatementSeparatorAsSqlToExecuteBounds, gbc);
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        pnl.add((Component)this.createReloadSQLContentsPanel(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.gridwidth = 0;
        gbc.fill = 0;
        pnl.add((Component)this.createMaxTextOutputColumnWidthPanel(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 9;
        gbc.gridwidth = 0;
        gbc.fill = 0;
        pnl.add((Component)this.chkNotifyExternalFileChanges, gbc);
        return pnl;
    }

    private JPanel createReloadSQLContentsPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0);
        ret.add((Component)this.chkReloadSqlContentsSql, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 3, 3, 3), 0, 0);
        ret.add((Component)new MultipleLineLabel(s_stringMgr.getString("SQLPreferencesPanel.reload.changetrack.hint")), gbc);
        ret.setBorder(BorderFactory.createEtchedBorder());
        return ret;
    }

    private JPanel createMaxTextOutputColumnWidthPanel() {
        JPanel ret = new JPanel(new BorderLayout(5, 0));
        ret.add((Component)new JLabel(s_stringMgr.getString("SQLPreferencesPanel.MaxTextOutputColumnWidthPanel.label", 3)), "West");
        ret.add((Component)this.txtMaxTextOutputColumnWidth, "Center");
        return ret;
    }

    private JPanel createCurrentSqlMarkPanel() {
        JPanel ret = new JPanel(new BorderLayout(5, 0));
        ret.add((Component)this.chkMarkCurrentSql, "West");
        ret.add((Component)this.btnCurrentSqlMarkColorRGB, "Center");
        this.btnCurrentSqlMarkColorRGB.setHorizontalTextPosition(2);
        this.btnCurrentSqlMarkColorRGB.setIcon(new ColorIcon(16, 16));
        this.btnCurrentSqlMarkColorRGB.setText(s_stringMgr.getString("SQLPreferencesPanel.current.sql.mark.color"));
        return ret;
    }

    private JPanel createDebugPanel() {
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.debugJdbcDont);
        btnGroup.add(this.debugJdbcStream);
        btnGroup.add(this.debugJdbcWriter);
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("SQLPreferencesPanel.debug")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 0;
        pnl.add((Component)this.debugJdbcDont, gbc);
        ++gbc.gridy;
        pnl.add((Component)this.debugJdbcStream, gbc);
        ++gbc.gridy;
        pnl.add((Component)this.debugJdbcWriter, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        pnl.add((Component)new JLabel(s_stringMgr.getString("SQLPreferencesPanel.jdbcdebugfile"), 4), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        pnl.add((Component)this.jdbcDebugLogFileNameLbl, gbc);
        return pnl;
    }

    private Component createFilePanel() {
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.fileOpenInPreviousDir);
        btnGroup.add(this.fileOpenInSpecifiedDir);
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("SQLPreferencesPanel.file")));
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)this.fileOpenInPreviousDir, gbc);
        gbc = new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)new JPanel(), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0);
        pnl.add((Component)this.fileOpenInSpecifiedDir, gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0);
        pnl.add((Component)this.fileSpecifiedDir, gbc);
        gbc = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0);
        pnl.add((Component)this.fileChooseDir, gbc);
        return pnl;
    }
}

