/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences.themes;

import java.awt.Color;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.preferences.themes.LAFPluginAccessor;
import net.sourceforge.squirrel_sql.client.preferences.themes.SyntaxPluginAccessor;
import net.sourceforge.squirrel_sql.client.preferences.themes.ThemesEnum;
import net.sourceforge.squirrel_sql.client.preferences.themes.ThemesPanel;
import net.sourceforge.squirrel_sql.client.session.messagepanel.MessagePrefsCtrl;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ThemesController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ThemesController.class);
    private final ThemesPanel _themesPanel;
    private MessagePrefsCtrl _messagePrefsCtrl;

    public ThemesController(MessagePrefsCtrl messagePrefsCtrl) {
        this._messagePrefsCtrl = messagePrefsCtrl;
        this._themesPanel = new ThemesPanel();
        this._themesPanel.cboThemes.setSelectedItem((Object)ThemesEnum.getCurrentTheme());
        this._themesPanel.btnApply.addActionListener(e -> this.onApply());
    }

    private void onApply() {
        ThemesEnum.saveCurrentTheme((ThemesEnum)((Object)this._themesPanel.cboThemes.getSelectedItem()));
        switch (ThemesEnum.getCurrentTheme()) {
            case LIGH: {
                if (0 != JOptionPane.showConfirmDialog(this._themesPanel, s_stringMgr.getString("ThemesController.apply.light.theme"))) {
                    return;
                }
                LAFPluginAccessor.applyMetalOcean();
                SyntaxPluginAccessor.applyDefaultTheme();
                Main.getApplication().getSquirrelPreferences().getSessionProperties().setNullValueColorRGB(SessionProperties.DEFAULT_NULL_VALUE_COLOR_RGB);
                this._messagePrefsCtrl.switchToLight();
                break;
            }
            case DARK: {
                if (0 != JOptionPane.showConfirmDialog(this._themesPanel, s_stringMgr.getString("ThemesController.apply.dark.theme"))) {
                    return;
                }
                LAFPluginAccessor.applyFlatLafDark();
                SyntaxPluginAccessor.applyDarkTheme();
                Main.getApplication().getSquirrelPreferences().getSessionProperties().setNullValueColorRGB(new Color(90, 100, 90).getRGB());
                this._messagePrefsCtrl.switchToDark();
            }
        }
    }

    public ThemesPanel getPanel() {
        return this._themesPanel;
    }
}

