/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.LastEditLocationHandler;
import net.sourceforge.squirrel_sql.client.session.PrioritizedCaretMouseListener;
import net.sourceforge.squirrel_sql.client.session.SQLEntryPanelUtil;
import net.sourceforge.squirrel_sql.client.session.action.ViewObjectAtCursorInObjectTreeAction;
import net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret.MultiCaretUtil;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IUndoHandler;
import net.sourceforge.squirrel_sql.client.session.menuattic.AtticHandler;
import net.sourceforge.squirrel_sql.client.session.menuattic.MenuOrigin;
import net.sourceforge.squirrel_sql.client.session.sqlbounds.BoundsOfSqlHandler;
import net.sourceforge.squirrel_sql.fw.gui.stdtextpopup.TextPopupMenu;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IntegerIdentifierFactory;

public abstract class BaseSQLEntryPanel
implements ISQLEntryPanel {
    protected static final String LINE_SEPARATOR = "\n";
    protected static final String SQL_STMT_SEP = "\n\n";
    public static final IntegerIdentifierFactory ENTRY_PANEL_IDENTIFIER_FACTORY = new IntegerIdentifierFactory();
    private IIdentifier _entryPanelIdentifier;
    private TextPopupMenu _textPopupMenu = new TextPopupMenu();
    private BoundsOfSqlHandler _boundsOfSqlHandler;
    private LastEditLocationHandler _lastEditLocationHandler;

    protected BaseSQLEntryPanel() {
        this._entryPanelIdentifier = ENTRY_PANEL_IDENTIFIER_FACTORY.createIdentifier();
        SwingUtilities.invokeLater(() -> this.initLater());
    }

    private void initLater() {
        this.getTextComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BaseSQLEntryPanel.this.onMouseClicked(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                BaseSQLEntryPanel.this.onMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                BaseSQLEntryPanel.this.onMouseReleased(e);
            }
        });
        this.setPrioritizedCaretMouseListener(new PrioritizedCaretMouseListener(){

            @Override
            public boolean mouseClicked(MouseEvent e) {
                return BaseSQLEntryPanel.this.onPrioritizedMouseClicked(e);
            }

            @Override
            public boolean mousePressed(MouseEvent e) {
                return BaseSQLEntryPanel.this.onPrioritizedMousePressed(e);
            }

            @Override
            public boolean mouseReleased(MouseEvent e) {
                return BaseSQLEntryPanel.this.onPrioritizedMouseReleased(e);
            }
        });
        this._boundsOfSqlHandler = new BoundsOfSqlHandler(this.getTextComponent(), this.getSession());
        this._lastEditLocationHandler = new LastEditLocationHandler(this.getTextComponent());
    }

    @Override
    public IIdentifier getIdentifier() {
        return this._entryPanelIdentifier;
    }

    @Override
    public String getSQLToBeExecuted() {
        if (null == this._boundsOfSqlHandler) {
            return null;
        }
        return this._boundsOfSqlHandler.getSQLToBeExecuted();
    }

    @Override
    public int[] getBoundsOfSQLToBeExecuted() {
        if (null == this._boundsOfSqlHandler) {
            return new int[]{0, 0};
        }
        return this._boundsOfSqlHandler.getBoundsOfSQLToBeExecuted();
    }

    @Override
    public void moveCaretToPreviousSQLBegin() {
        int iCaretPos;
        String sql = this.getText();
        int iLastIndex = sql.lastIndexOf(SQL_STMT_SEP, iCaretPos = this.getCaretPosition() - 1);
        if (-1 == iLastIndex) {
            return;
        }
        if (-1 == (iLastIndex = sql.lastIndexOf(SQL_STMT_SEP, iLastIndex - this.getWhiteSpaceCountBackwards(iLastIndex, sql)))) {
            iLastIndex = 0;
        }
        char c = sql.charAt(iLastIndex);
        while (Character.isWhitespace(c) && iLastIndex < sql.length()) {
            c = sql.charAt(++iLastIndex);
        }
        this.setCaretPosition(iLastIndex);
    }

    private int getWhiteSpaceCountBackwards(int iStartIx, String sql) {
        int count = 0;
        while (0 < iStartIx && Character.isWhitespace(sql.charAt(iStartIx))) {
            --iStartIx;
            ++count;
        }
        return count;
    }

    @Override
    public void moveCaretToNextSQLBegin() {
        int iCaretPos;
        String sql = this.getText();
        int iNextIndex = sql.indexOf(SQL_STMT_SEP, iCaretPos = this.getCaretPosition());
        if (-1 == iNextIndex) {
            return;
        }
        while (iNextIndex < sql.length() && Character.isWhitespace(sql.charAt(iNextIndex))) {
            ++iNextIndex;
        }
        if (iNextIndex < sql.length()) {
            this.setCaretPosition(iNextIndex);
        }
    }

    @Override
    public void selectCurrentSql() {
        int[] boundsOfSQLToBeExecuted = this._boundsOfSqlHandler.getSqlBoundsBySeparatorRule(this.getCaretPosition());
        if (boundsOfSQLToBeExecuted[0] != boundsOfSQLToBeExecuted[1]) {
            this.setSelectionStart(boundsOfSQLToBeExecuted[0]);
            this.setSelectionEnd(boundsOfSQLToBeExecuted[1]);
        }
    }

    @Override
    public void addToSQLEntryAreaMenu(JMenu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("Menu == null");
        }
        this._textPopupMenu.add(menu);
    }

    @Override
    public JMenuItem addToSQLEntryAreaMenu(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Action == null");
        }
        return this._textPopupMenu.add(action);
    }

    @Override
    public void addSeparatorToSQLEntryAreaMenu() {
        this._textPopupMenu.addSeparator();
    }

    @Override
    public void addUndoRedoActionsToSQLEntryAreaMenu(Action undo, Action redo) {
        this._textPopupMenu.addSeparator();
        JMenuItem buf = this.addToSQLEntryAreaMenu(undo);
        Main.getApplication().getResources().configureMenuItem(undo, buf);
        buf = this.addToSQLEntryAreaMenu(redo);
        Main.getApplication().getResources().configureMenuItem(redo, buf);
        this._textPopupMenu.addSeparator();
    }

    @Override
    public boolean hasOwnUndoableManager() {
        return false;
    }

    @Override
    public IUndoHandler createUndoHandler() {
        return null;
    }

    @Override
    public String getWordAtCursor() {
        int[] beginAndEndPos = SQLEntryPanelUtil.getWordBoundsAtCursor(this.getTextComponent(), true);
        return this.getTextComponent().getText().substring(beginAndEndPos[0], beginAndEndPos[1]).trim();
    }

    @Override
    public void triggerParser() {
    }

    @Override
    public void goToLastEditLocation() {
        this._lastEditLocationHandler.goToLastEditLocation();
    }

    private void onMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.displayPopupMenu(evt);
        }
    }

    private void onMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.displayPopupMenu(evt);
        }
    }

    private void onMouseClicked(MouseEvent e) {
        if (e.isControlDown() && !e.isAltDown() && !e.isShiftDown() && e.getClickCount() == 1) {
            Action a = Main.getApplication().getActionCollection().get(ViewObjectAtCursorInObjectTreeAction.class);
            a.actionPerformed(new ActionEvent(this, 1, "ViewObjectAtCursorInObjectTreeAction"));
        }
    }

    private boolean onPrioritizedMouseReleased(MouseEvent e) {
        return MultiCaretUtil.isAdditionalCaretMouseClickModifier(e);
    }

    private boolean onPrioritizedMousePressed(MouseEvent e) {
        return MultiCaretUtil.isAdditionalCaretMouseClickModifier(e);
    }

    private boolean onPrioritizedMouseClicked(MouseEvent e) {
        if (MultiCaretUtil.isAdditionalCaretMouseClickModifier(e)) {
            this.getTextAreaPaintHandler().getMultiCaretHandler().createNextCaretAtPoint(new Point(e.getX(), e.getY()));
            return true;
        }
        return false;
    }

    private void displayPopupMenu(MouseEvent evt) {
        this._textPopupMenu.setTextComponent(this.getTextComponent());
        AtticHandler.initAtticForMenu(this._textPopupMenu, MenuOrigin.SQL_EDITOR);
        this._textPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
    }
}

