/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import net.sourceforge.squirrel_sql.client.session.EditableSqlCheck;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.sql.tablenamefind.TableNameFindService;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class DataModelImplementationDetails {
    private ISession _session;
    private SQLExecutionInfo _exInfo;

    public DataModelImplementationDetails() {
    }

    public DataModelImplementationDetails(ISession session) {
        this._session = session;
    }

    public DataModelImplementationDetails(ISession session, SQLExecutionInfo exInfo) {
        this._session = session;
        this._exInfo = exInfo;
    }

    public String getTableName(ColumnDisplayDefinition colDef) {
        String tableNameFromSQL;
        if (null != this._exInfo && !StringUtilities.isEmpty(tableNameFromSQL = new EditableSqlCheck(this._exInfo, this._session).getTableNameFromSQL(), true)) {
            return tableNameFromSQL;
        }
        return TableNameFindService.findTableNameInColumnDisplayDefinition(colDef);
    }

    public String getStatementSeparator() {
        if (null == this._session) {
            return ";";
        }
        return this._session.getProperties().getSQLStatementSeparator();
    }

    public SQLExecutionInfo getSQLExecutionInfo() {
        return this._exInfo;
    }

    public ISession getSession() {
        return this._session;
    }
}

