/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.session.CountResult;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.IWhereClausePartUtil;
import net.sourceforge.squirrel_sql.client.session.WhereClausePartUtil;
import net.sourceforge.squirrel_sql.client.session.properties.EditWhereCols;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetUpdateableTableModelListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.LimitReadLengthFeatureUnstable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils2;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DataSetUpdateableTableModelImpl
implements IDataSetUpdateableTableModel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataSetUpdateableTableModelImpl.class);
    private final String TI_ERROR_MESSAGE = s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.tablenotfound");
    private static final ILogger s_log = LoggerController.createLogger(DataSetUpdateableTableModelImpl.class);
    private String _fullTableName = null;
    private ITableInfo _tableInfo;
    private ISession _session;
    private boolean editModeForced = false;
    String sqlOutputClassNameAtTimeOfForcedEdit = "";
    private Vector<DataSetUpdateableTableModelListener> _dataSetUpdateableTableModelListener = new Vector();
    int _rowIDcol = -1;
    private IWhereClausePartUtil whereClausePartUtil = new WhereClausePartUtil();

    public void setTableInfo(ITableInfo ti) {
        this._tableInfo = ti;
        this._fullTableName = null;
    }

    public void setSession(ISession session) {
        this._session = session;
    }

    public static String getUnambiguousTableName(ISession session, String name) {
        return session.getAlias().getUrl() + ":" + name;
    }

    public String getFullTableName() {
        if (this._fullTableName == null) {
            try {
                String name = this._tableInfo.getQualifiedName();
                this._fullTableName = DataSetUpdateableTableModelImpl.getUnambiguousTableName(this._session, name);
            }
            catch (Exception e) {
                s_log.error("getFullTableName: Unexpected exception - " + e.getMessage(), e);
            }
        }
        return this._fullTableName;
    }

    @Override
    public void forceEditMode(boolean mode) {
        this.editModeForced = mode;
        this.sqlOutputClassNameAtTimeOfForcedEdit = this._session.getProperties().getTableContentsOutputClassName();
        DataSetUpdateableTableModelListener[] listeners = this._dataSetUpdateableTableModelListener.toArray(new DataSetUpdateableTableModelListener[0]);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].forceEditMode(mode);
        }
    }

    @Override
    public boolean editModeIsForced() {
        return this.editModeForced;
    }

    public String getDestinationClassName() {
        if (this.editModeForced) {
            if (this._session.getProperties().getTableContentsOutputClassName().equals(this.sqlOutputClassNameAtTimeOfForcedEdit)) {
                return this._session.getProperties().getEditableTableOutputClassName();
            }
            this.editModeForced = false;
        }
        return this._session.getProperties().getTableContentsOutputClassName();
    }

    @Override
    public String getWarningOnCurrentData(Object[] values, ColumnDisplayDefinition[] colDefs, int col, Object oldValue) {
        if (this._tableInfo == null) {
            return this.TI_ERROR_MESSAGE;
        }
        List<IWhereClausePart> whereClauseParts = this.getWhereClause(values, colDefs, col, oldValue);
        if (!this.whereClausePartUtil.hasUsableWhereClause(whereClauseParts)) {
            return s_stringMgr.getString("DataSetUpdateableTableModelImpl.confirmupdateallrows");
        }
        ISession session = this._session;
        ISQLConnection conn = session.getSQLConnection();
        int count = -1;
        CountResult countResult = null;
        countResult = this.count(whereClauseParts, conn);
        count = countResult.getCount();
        if (null != countResult.getErr()) {
            s_log.error("Error when executing count-SQL\n" + countResult.getSql(), countResult.getErr());
            return s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.exceptionduringcheck", countResult.getErr());
        }
        if (count == -1) {
            this.reportUpdateFail(countResult);
            return s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.unknownerror");
        }
        if (count == 0) {
            this.reportUpdateFail(countResult);
            return s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.staleupdaterow");
        }
        if (count > 1) {
            this.reportUpdateFail(countResult);
            return s_stringMgr.getString("DataSetUpdateableTableModelImpl.info.updateidenticalrows", count);
        }
        return null;
    }

    private void reportUpdateFail(CountResult countResult) {
        if (null == countResult) {
            return;
        }
        String msg = "Editing led to a warning message because the number of rows that would be updated was found to be " + countResult.getCount() + " instead of 1.\nHere's some information about the query that was used to predict the number of rows that would be affected:\n" + countResult.getCheckSQLDetails();
        this._session.getApplication().getMessageHandler().showWarningMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CountResult count(List<IWhereClausePart> whereClauseParts, ISQLConnection conn) {
        CountResult countResult;
        block5: {
            countResult = new CountResult();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            String countSql = null;
            try {
                String whereClause = this.whereClausePartUtil.createWhereClause(whereClauseParts);
                countSql = "select count(*) from " + this._tableInfo.getQualifiedName() + whereClause;
                countResult.setSql(countSql);
                pstmt = conn.prepareStatement(countSql);
                this.whereClausePartUtil.setParameters(pstmt, whereClauseParts, 1, countResult);
                rs = pstmt.executeQuery();
                rs.next();
                countResult.setCount(rs.getInt(1));
                SQLUtilities.closeResultSet(rs);
            }
            catch (Exception e) {
                countResult.setError(e);
                break block5;
            }
            finally {
                SQLUtilities.closeResultSet(rs);
                SQLUtilities.closeStatement(pstmt);
            }
            SQLUtilities.closeStatement(pstmt);
        }
        return countResult;
    }

    @Override
    public String getWarningOnProjectedUpdate(Object[] values, ColumnDisplayDefinition[] colDefs, int col, Object newValue) {
        try {
            ISession session;
            ISQLConnection conn;
            if (this._tableInfo == null) {
                return this.TI_ERROR_MESSAGE;
            }
            List<IWhereClausePart> whereClauseParts = this.getWhereClause(values, colDefs, col, newValue);
            CountResult countResult = this.count(whereClauseParts, conn = (session = this._session).getSQLConnection());
            if (null != countResult.getErr()) {
                s_log.error("Error when executing count-SQL\n" + countResult.getSql(), countResult.getErr());
                return s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.exceptionduringcheck", countResult.getErr());
            }
            if (countResult.getCount() == -1) {
                return s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.unknownerror");
            }
            if (countResult.getCount() > 1) {
                return s_stringMgr.getString("DataSetUpdateableTableModelImpl.info.identicalrows", countResult.getCount());
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object reReadDatum(Object[] values, ColumnDisplayDefinition[] colDefs, int col, StringBuffer message) {
        if (this._tableInfo == null) {
            LimitReadLengthFeatureUnstable.unknownTable();
            return this.TI_ERROR_MESSAGE;
        }
        List<IWhereClausePart> whereClauseParts = this.getWhereClause(values, colDefs, -1, null);
        String whereClause = this.whereClausePartUtil.createWhereClause(whereClauseParts);
        ISession session = this._session;
        ISQLConnection conn = session.getSQLConnection();
        Object wholeDatum = null;
        try {
            String queryString = "SELECT " + colDefs[col].getColumnName() + " FROM " + this._tableInfo.getQualifiedName() + whereClause;
            PreparedStatement pstmt = conn.prepareStatement(queryString);
            this.whereClausePartUtil.setParameters(pstmt, whereClauseParts, 1, null);
            try {
                ResultSet rs = pstmt.executeQuery();
                if (!rs.next()) {
                    throw new SQLException(s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.nomatchingrow"));
                }
                wholeDatum = CellComponentFactory.readResultSet(colDefs[col], rs, 1, false);
                if (rs.next()) {
                    wholeDatum = null;
                    throw new SQLException(s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.multimatchingrows"));
                }
            }
            finally {
                pstmt.close();
            }
        }
        catch (Exception ex) {
            message.append(s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.rereadingdb", Utilities.getExceptionStringSave(ex)));
            LimitReadLengthFeatureUnstable.someErrorReReading(ex);
        }
        return wholeDatum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateTableComponent(Object[] values, ColumnDisplayDefinition[] colDefs, int col, Object oldValue, Object newValue) {
        if (this._tableInfo == null) {
            return this.TI_ERROR_MESSAGE;
        }
        List<IWhereClausePart> whereClauseParts = this.getWhereClause(values, colDefs, col, oldValue);
        String whereClause = this.whereClausePartUtil.createWhereClause(whereClauseParts);
        if (s_log.isDebugEnabled()) {
            s_log.debug("updateTableComponent: whereClause = " + whereClause);
        }
        ISession session = this._session;
        ISQLConnection conn = session.getSQLConnection();
        int count = -1;
        String sql = this.constructUpdateSql(this._tableInfo.getQualifiedName(), DialectUtils2.checkColumnDoubleQuotes(colDefs[col].getDialectType(), colDefs[col].getColumnName()), whereClause);
        if (s_log.isDebugEnabled()) {
            s_log.debug("updateTableComponent: executing SQL - " + sql);
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            CellComponentFactory.setPreparedStatementValue(colDefs[col], pstmt, newValue, 1);
            this.whereClausePartUtil.setParameters(pstmt, whereClauseParts, 2, null);
            count = pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            String errMsg;
            s_log.error("updateTableComponent: unexpected exception - " + ex.getMessage() + " while executing SQL: " + sql, ex);
            String string = errMsg = s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.updateproblem", Utilities.getExceptionStringSave(ex));
            return string;
        }
        finally {
            SQLUtilities.closeStatement(pstmt);
        }
        if (count == -1) {
            return s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.unknownupdateerror");
        }
        if (count == 0) {
            return s_stringMgr.getString("DataSetUpdateableTableModelImpl.info.norowsupdated");
        }
        return null;
    }

    private String constructUpdateSql(String table, String column, String whereClause) {
        StringBuilder result = new StringBuilder();
        result.append("UPDATE ");
        result.append(table);
        result.append(" SET ");
        result.append(column);
        result.append(" = ? ");
        result.append(whereClause);
        return result.toString();
    }

    @Override
    public int getRowidCol() {
        return this._rowIDcol;
    }

    private List<IWhereClausePart> getWhereClause(Object[] values, ColumnDisplayDefinition[] colDefs, int col, Object colValue) {
        try {
            HashMap<String, String> colNames = EditWhereCols.get(this.getFullTableName());
            ColumnDisplayDefinition editedCol = null;
            if (-1 != col) {
                editedCol = colDefs[col];
            }
            ArrayList<IWhereClausePart> clauseParts = new ArrayList<IWhereClausePart>();
            for (int i = 0; i < colDefs.length; ++i) {
                ISQLDatabaseMetaData md;
                IWhereClausePart clausePart;
                if (i != col && null != editedCol && colDefs[i].getFullTableColumnName().equalsIgnoreCase(editedCol.getFullTableColumnName()) || colNames != null && colNames.get(colDefs[i].getColumnName()) == null) continue;
                Object value = values[i];
                if (i == col) {
                    value = colValue;
                }
                if (value != null && value.toString().equals("<null>")) {
                    value = null;
                }
                if (!(clausePart = CellComponentFactory.getWhereClauseValue(colDefs[i], value, md = this._session.getMetaData())).shouldBeUsed()) continue;
                clauseParts.add(clausePart);
            }
            return clauseParts;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String deleteRows(Object[][] rowData, ColumnDisplayDefinition[] colDefs) {
        String msg;
        int option;
        int i;
        if (this._tableInfo == null) {
            return this.TI_ERROR_MESSAGE;
        }
        ISession session = this._session;
        ISQLConnection conn = session.getSQLConnection();
        Object rowCountErrorMessage = "";
        for (i = 0; i < rowData.length; ++i) {
            List<IWhereClausePart> whereClauseParts = this.getWhereClause(rowData[i], colDefs, -1, null);
            try {
                CountResult countResult = this.count(whereClauseParts, conn);
                if (null != countResult.getErr()) {
                    s_log.error("Error when executing count-SQL\n" + countResult.getSql(), countResult.getErr());
                    return s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.exceptionduringcheck", countResult.getErr());
                }
                if (countResult.getCount() == 1) continue;
                if (countResult.getCount() == 0) {
                    rowCountErrorMessage = (String)rowCountErrorMessage + s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.rownotmatch", i + 1);
                    continue;
                }
                rowCountErrorMessage = (String)rowCountErrorMessage + s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.rowmatched", i + 1, countResult.getCount());
                continue;
            }
            catch (Exception e) {
                return s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.preparingdelete", e);
            }
        }
        if (((String)rowCountErrorMessage).length() > 0 && (option = JOptionPane.showConfirmDialog(null, msg = s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.tabledbmismatch", rowCountErrorMessage), "Warning", 0, 2)) != 0) {
            return s_stringMgr.getString("DataSetUpdateableTableModelImpl.info.deletecancelled");
        }
        for (i = 0; i < rowData.length; ++i) {
            List<IWhereClausePart> whereClauseParts = this.getWhereClause(rowData[i], colDefs, -1, null);
            String whereClause = this.whereClausePartUtil.createWhereClause(whereClauseParts);
            try {
                String sql = "DELETE FROM " + this._tableInfo.getQualifiedName() + whereClause;
                PreparedStatement pstmt = conn.prepareStatement(sql);
                this.whereClausePartUtil.setParameters(pstmt, whereClauseParts, 1, null);
                try {
                    pstmt.executeUpdate();
                    continue;
                }
                finally {
                    pstmt.close();
                }
            }
            catch (Exception e) {
                return s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.deleteFailed", e);
            }
        }
        return null;
    }

    @Override
    public String[] getDefaultValues(ColumnDisplayDefinition[] colDefs) {
        String[] defaultValues = new String[colDefs.length];
        if (this._tableInfo == null) {
            return defaultValues;
        }
        ISession session = this._session;
        ISQLConnection conn = session.getSQLConnection();
        try {
            SQLDatabaseMetaData md = conn.getSQLMetaData();
            TableColumnInfo[] infos = md.getColumnInfo(this._tableInfo);
            int expectedColDefIndex = 0;
            for (int idx = 0; idx < infos.length; ++idx) {
                String colName = infos[idx].getColumnName();
                String defValue = infos[idx].getDefaultValue();
                if (defValue != null && defValue.length() > 0) {
                    if (colDefs[expectedColDefIndex].getColumnName().equals(colName)) {
                        defaultValues[expectedColDefIndex] = defValue;
                    } else {
                        for (int i = 0; i < colDefs.length; ++i) {
                            if (!colDefs[i].getColumnName().equals(colName)) continue;
                            defaultValues[i] = defValue;
                            break;
                        }
                    }
                }
                ++expectedColDefIndex;
            }
        }
        catch (Exception ex) {
            s_log.error(s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.retrievingdefaultvalues"), ex);
        }
        return defaultValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String insertRow(Object[] values, ColumnDisplayDefinition[] colDefs) {
        if (this._tableInfo == null) {
            return this.TI_ERROR_MESSAGE;
        }
        ISession session = this._session;
        ISQLConnection conn = session.getSQLConnection();
        int count = -1;
        try {
            int i;
            StringBuilder buf = new StringBuilder("INSERT INTO ");
            buf.append(this._tableInfo.getQualifiedName());
            buf.append(" ( ");
            for (i = 0; i < colDefs.length; ++i) {
                if (i == this._rowIDcol) continue;
                if (colDefs[i].isAutoIncrement()) {
                    if (!s_log.isInfoEnabled()) continue;
                    s_log.info("insertRow: skipping auto-increment column " + colDefs[i].getColumnName());
                    continue;
                }
                buf.append(DialectUtils2.checkColumnDoubleQuotes(colDefs[i].getDialectType(), colDefs[i].getColumnName()));
                buf.append(",");
            }
            buf.setCharAt(buf.length() - 1, ')');
            buf.append(" VALUES (");
            for (i = 0; i < colDefs.length; ++i) {
                if (i == this._rowIDcol || colDefs[i].isAutoIncrement()) continue;
                buf.append(" ?,");
            }
            buf.setCharAt(buf.length() - 1, ')');
            String pstmtSQL = buf.toString();
            if (s_log.isInfoEnabled()) {
                s_log.info("insertRow: pstmt sql = " + pstmtSQL);
            }
            try (PreparedStatement pstmt = conn.prepareStatement(pstmtSQL);){
                int bindVarIdx = 1;
                for (int i2 = 0; i2 < colDefs.length; ++i2) {
                    if (i2 == this._rowIDcol || colDefs[i2].isAutoIncrement()) continue;
                    CellComponentFactory.setPreparedStatementValue(colDefs[i2], pstmt, values[i2], bindVarIdx);
                    ++bindVarIdx;
                }
                count = pstmt.executeUpdate();
            }
        }
        catch (SQLException ex) {
            s_log.error(ex);
            return s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.duringInsert", Utilities.getExceptionStringSave(ex));
        }
        if (count != 1) {
            return s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.unknownerrorupdate");
        }
        try {
            IObjectTreeAPI api = this._session.getObjectTreeAPIOfActiveSessionWindow();
            api.refreshSelectedTab();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void addListener(DataSetUpdateableTableModelListener l) {
        this._dataSetUpdateableTableModelListener.add(l);
    }

    @Override
    public void removeListener(DataSetUpdateableTableModelListener l) {
        this._dataSetUpdateableTableModelListener.remove(l);
    }

    public void setEditModeForced(boolean b) {
        this.editModeForced = b;
    }

    public void setRowIDCol(int rowIDCol) {
        this._rowIDcol = rowIDCol;
    }

    public void setWhereClausePartUtil(IWhereClausePartUtil whereClausePartUtil) {
        this.whereClausePartUtil = whereClausePartUtil;
    }

    @Override
    public ITableInfo getTableInfo() {
        return this._tableInfo;
    }

    @Override
    public ISession getSession() {
        return this._session;
    }
}

