/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.sourceforge.squirrel_sql.client.session.ModificationAwareSessionTitleChangeListener;

public class ModificationAwareSessionTitle {
    private List<ModificationAwareSessionTitleChangeListener> _listeners = new ArrayList<ModificationAwareSessionTitleChangeListener>();
    private String _title;
    private boolean _titleWasChangedByUser;

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String newTitle) {
        this.setTitle(newTitle, false);
    }

    public void setTitle(String newTitle, boolean changedByUser) {
        if (Objects.equals(this._title, newTitle)) {
            return;
        }
        if (changedByUser) {
            this._titleWasChangedByUser = true;
        } else if (this._titleWasChangedByUser) {
            return;
        }
        String oldVal = this._title;
        this._title = newTitle;
        ModificationAwareSessionTitleChangeListener[] buf = this._listeners.toArray(new ModificationAwareSessionTitleChangeListener[0]);
        for (int i = 0; i < buf.length; ++i) {
            buf[i].titleChanged(oldVal, this._title);
        }
    }

    public void addListener(ModificationAwareSessionTitleChangeListener listener) {
        this._listeners.remove(listener);
        this._listeners.add(listener);
    }

    public void removeListener(ModificationAwareSessionTitleChangeListener titleChangeListener) {
        this._listeners.remove(titleChangeListener);
    }
}

