/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import javax.swing.text.JTextComponent;

public class SQLEntryPanelUtil {
    public static int[] getWordBoundsAtCursor(JTextComponent textComponent, boolean qualified) {
        String text = textComponent.getText();
        int caretPos = textComponent.getCaretPosition();
        int[] beginAndEndPos = new int[2];
        int lastIndexOfText = Math.max(0, text.length() - 1);
        beginAndEndPos[0] = Math.min(caretPos, lastIndexOfText);
        while (0 < beginAndEndPos[0] && !SQLEntryPanelUtil.isParseStop(text.charAt(beginAndEndPos[0] - 1), false == qualified)) {
            beginAndEndPos[0] = beginAndEndPos[0] - 1;
        }
        beginAndEndPos[1] = caretPos;
        while (beginAndEndPos[1] < text.length() && !SQLEntryPanelUtil.isParseStop(text.charAt(beginAndEndPos[1]), true)) {
            beginAndEndPos[1] = beginAndEndPos[1] + 1;
        }
        return beginAndEndPos;
    }

    public static int[] getLineBoundsAtCursor(JTextComponent textComponent) {
        String text = textComponent.getText();
        int caretPos = textComponent.getCaretPosition();
        if (0 == text.length()) {
            return new int[]{0, 0};
        }
        int beg = SQLEntryPanelUtil.getPrevNewLineOrTextBegin(caretPos, text);
        int end = SQLEntryPanelUtil.getNextNewLineOrTextEnd(caretPos, text);
        return new int[]{beg, end};
    }

    private static int getNextNewLineOrTextEnd(int caretPos, String text) {
        if (caretPos == text.length()) {
            return text.length();
        }
        if ('\n' == text.charAt(caretPos)) {
            return caretPos + 1;
        }
        int nextNL = text.indexOf(10, caretPos);
        if (-1 == nextNL) {
            return text.length();
        }
        return nextNL + 1;
    }

    private static int getPrevNewLineOrTextBegin(int caretPos, String text) {
        if (caretPos == 0) {
            return 0;
        }
        int pos = caretPos;
        if (caretPos == text.length() || '\n' == text.charAt(caretPos)) {
            pos = caretPos - 1;
        }
        int i = pos;
        while (i > 0) {
            if ('\n' == text.charAt(i)) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    private static boolean isParseStop(char c, boolean treatDotAsStop) {
        return '(' == c || ')' == c || ',' == c || ';' == c || '=' == c || '>' == c || '<' == c || '\'' == c || Character.isWhitespace(c) || treatDotAsStop && '.' == c;
    }
}

