/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.session.ToolsPopupController;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFilePathHandler;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.client.session.action.ConvertToStringBuilderAction;
import net.sourceforge.squirrel_sql.client.session.action.CopySqlAction;
import net.sourceforge.squirrel_sql.client.session.action.CutSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.DeleteCurrentLineAction;
import net.sourceforge.squirrel_sql.client.session.action.DeleteSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.EscapeDateAction;
import net.sourceforge.squirrel_sql.client.session.action.ExecuteSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.FormatSQLAction;
import net.sourceforge.squirrel_sql.client.session.action.InQuotesAction;
import net.sourceforge.squirrel_sql.client.session.action.PasteFromHistoryAction;
import net.sourceforge.squirrel_sql.client.session.action.PasteFromHistoryAltAcceleratorAction;
import net.sourceforge.squirrel_sql.client.session.action.RemoveNewLinesAction;
import net.sourceforge.squirrel_sql.client.session.action.RemoveQuotesAction;
import net.sourceforge.squirrel_sql.client.session.action.ToggleMinimizeResultsAction;
import net.sourceforge.squirrel_sql.client.session.action.ToolsPopupAction;
import net.sourceforge.squirrel_sql.client.session.action.UndoRedoActionContext;
import net.sourceforge.squirrel_sql.client.session.action.ViewObjectAtCursorInObjectTreeAction;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.actions.CompareToClipboardAction;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.SQLScriptMenuFactory;
import net.sourceforge.squirrel_sql.client.session.event.ISQLExecutionListener;
import net.sourceforge.squirrel_sql.client.session.event.ISQLPanelListener;
import net.sourceforge.squirrel_sql.client.session.event.ISQLResultExecuterTabListener;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileHandler;
import net.sourceforge.squirrel_sql.client.session.filemanager.SQLPanelSelectionHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ISQLResultExecutor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistoryItem;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanelPosition;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTracker;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.SQLPanelSplitter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SQLPanelAPI
implements ISQLPanelAPI {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLPanelAPI.class);
    private SQLPanel _panel;
    private ToolsPopupController _toolsPopupController;
    private FileHandler _fileHandler;

    public SQLPanelAPI(SQLPanel panel, TitleFilePathHandler titleFileHandler) {
        this._panel = panel;
        this._fileHandler = new FileHandler(this, titleFileHandler);
        this._panel.getSQLEntryPanel().addUndoableEditListener(this._fileHandler.createEditListener());
        this.initToolsPopUp();
        this.createStandardEntryAreaMenuItems();
    }

    private void initToolsPopUp() {
        this._toolsPopupController = new ToolsPopupController(this.getSession(), this._panel.getSQLEntryPanel());
        ActionCollection ac = this.getSession().getApplication().getActionCollection();
        Main.getApplication().getActionRegistry().registerToolsPopupActions(ac, this._toolsPopupController, this._panel, this.isInMainSessionWindow());
    }

    @Override
    public boolean isInMainSessionWindow() {
        return SQLPanelPosition.MAIN_TAB_IN_SESSION_WINDOW == this._panel.getSQLPanelPosition() || SQLPanelPosition.ADDITIONAL_TAB_IN_SESSION_WINDOW == this._panel.getSQLPanelPosition();
    }

    private void createStandardEntryAreaMenuItems() {
        SquirrelResources resources = this.getSession().getApplication().getResources();
        ActionCollection ac = this._panel.getSession().getApplication().getActionCollection();
        Action executeSqlAction = ac.get(ExecuteSqlAction.class);
        JMenuItem item = this.getSQLEntryPanel().addToSQLEntryAreaMenu(executeSqlAction);
        resources.configureMenuItem(executeSqlAction, item);
        this.getSQLEntryPanel().addSeparatorToSQLEntryAreaMenu();
        Action toolsPopupAction = ac.get(ToolsPopupAction.class);
        item = this.getSQLEntryPanel().addToSQLEntryAreaMenu(toolsPopupAction);
        resources.configureMenuItem(toolsPopupAction, item);
        if (this.isInMainSessionWindow()) {
            Action vioAction = ac.get(ViewObjectAtCursorInObjectTreeAction.class);
            item = this.getSQLEntryPanel().addToSQLEntryAreaMenu(vioAction);
            resources.configureMenuItem(vioAction, item);
        }
        Action formatSqlAction = ac.get(FormatSQLAction.class);
        item = this.getSQLEntryPanel().addToSQLEntryAreaMenu(formatSqlAction);
        resources.configureMenuItem(formatSqlAction, item);
        Action compareToClipboardAction = ac.get(CompareToClipboardAction.class);
        item = this.getSQLEntryPanel().addToSQLEntryAreaMenu(compareToClipboardAction);
        resources.configureMenuItem(compareToClipboardAction, item);
        this.getSQLEntryPanel().addSeparatorToSQLEntryAreaMenu();
        item = this.getSQLEntryPanel().addToSQLEntryAreaMenu(ac.get(InQuotesAction.class));
        resources.configureMenuItem(ac.get(InQuotesAction.class), item);
        item = this.getSQLEntryPanel().addToSQLEntryAreaMenu(ac.get(RemoveQuotesAction.class));
        resources.configureMenuItem(ac.get(RemoveQuotesAction.class), item);
        this.getSQLEntryPanel().addToSQLEntryAreaMenu(ac.get(ConvertToStringBuilderAction.class));
        this.getSQLEntryPanel().addSeparatorToSQLEntryAreaMenu();
        item = this.getSQLEntryPanel().addToSQLEntryAreaMenu(ac.get(DeleteCurrentLineAction.class));
        resources.configureMenuItem(ac.get(DeleteCurrentLineAction.class), item);
        item = this.getSQLEntryPanel().addToSQLEntryAreaMenu(ac.get(RemoveNewLinesAction.class));
        resources.configureMenuItem(ac.get(RemoveNewLinesAction.class), item);
        this.getSQLEntryPanel().addToSQLEntryAreaMenu(ac.get(EscapeDateAction.class));
        item = this.getSQLEntryPanel().addToSQLEntryAreaMenu(ac.get(CutSqlAction.class));
        resources.configureMenuItem(ac.get(CutSqlAction.class), item);
        item = this.getSQLEntryPanel().addToSQLEntryAreaMenu(ac.get(CopySqlAction.class));
        resources.configureMenuItem(ac.get(CopySqlAction.class), item);
        item = this.getSQLEntryPanel().addToSQLEntryAreaMenu(ac.get(DeleteSqlAction.class));
        resources.configureMenuItem(ac.get(DeleteSqlAction.class), item);
        item = this.getSQLEntryPanel().addToSQLEntryAreaMenu(ac.get(PasteFromHistoryAction.class));
        resources.configureMenuItem(ac.get(PasteFromHistoryAction.class), item);
        item = this.getSQLEntryPanel().addToSQLEntryAreaMenu(ac.get(PasteFromHistoryAltAcceleratorAction.class));
        resources.configureMenuItem(ac.get(PasteFromHistoryAltAcceleratorAction.class), item);
        item = this.getSQLEntryPanel().addToSQLEntryAreaMenu(ac.get(ToggleMinimizeResultsAction.class));
        resources.configureMenuItem(ac.get(ToggleMinimizeResultsAction.class), item);
        this.getSQLEntryPanel().addSeparatorToSQLEntryAreaMenu();
        SQLScriptMenuFactory.addMenuItemsToSQLPanelApi(this);
        this.getSQLEntryPanel().addSeparatorToSQLEntryAreaMenu();
    }

    @Override
    public void addToToolsPopUp(String selectionString, Action action) {
        this._toolsPopupController.addAction(selectionString, action);
    }

    @Override
    public void showToolsPopup() {
        this._toolsPopupController.showToolsPopup();
    }

    @Override
    public void addExecutor(ISQLResultExecutor exec) {
        this._panel.addExecutor(exec);
    }

    @Override
    public void removeExecutor(ISQLResultExecutor exec) {
        this._panel.removeExecutor(exec);
    }

    @Override
    public synchronized void addSQLExecutionListener(ISQLExecutionListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("null ISQLExecutionListener passed");
        }
        this._panel.addSQLExecutionListener(lis);
    }

    @Override
    public synchronized void removeSQLExecutionListener(ISQLExecutionListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("null ISQLExecutionListener passed");
        }
        this._panel.removeSQLExecutionListener(lis);
    }

    @Override
    public void addExecuterTabListener(ISQLResultExecuterTabListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("ISQLResultExecuterTabListener == null");
        }
        this._panel.addExecuterTabListener(lis);
    }

    @Override
    public void removeExecuterTabListener(ISQLResultExecuterTabListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("ISQLResultExecuterTabListener == null");
        }
        this._panel.removeExecuterTabListener(lis);
    }

    @Override
    public synchronized void addSQLPanelListener(ISQLPanelListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("ISQLPanelListener == null");
        }
        this._panel.addSQLPanelListener(lis);
    }

    @Override
    public synchronized void removeSQLPanelListener(ISQLPanelListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("ISQLPanelListener == null");
        }
        this._panel.removeSQLPanelListener(lis);
    }

    @Override
    public ISQLEntryPanel getSQLEntryPanel() {
        return this._panel.getSQLEntryPanel();
    }

    @Override
    public ISQLResultExecutor getSQLResultExecuter() {
        return this._panel.getSQLExecPanel();
    }

    @Override
    public String getEntireSQLScript() {
        return this._panel.getSQLEntryPanel().getText();
    }

    @Override
    public String getSelectedSQLScript() {
        return this._panel.getSQLEntryPanel().getSelectedText();
    }

    @Override
    public String getSQLScriptToBeExecuted() {
        return this._panel.getSQLEntryPanel().getSQLToBeExecuted();
    }

    @Override
    public void appendSQLScript(String sqlScript) {
        this._panel.getSQLEntryPanel().appendText(sqlScript);
    }

    @Override
    public void appendSQLScript(String sqlScript, boolean select) {
        this._panel.getSQLEntryPanel().appendText(sqlScript, select);
    }

    @Override
    public void setEntireSQLScript(String sqlScript) {
        this._panel.getSQLEntryPanel().setText(sqlScript);
    }

    @Override
    public void setEntireSQLScript(String sqlScript, boolean select) {
        this._panel.getSQLEntryPanel().setText(sqlScript, select);
    }

    @Override
    public void replaceSelectedSQLScript(String sqlScript, boolean select) {
        if (sqlScript == null) {
            sqlScript = "";
        }
        ISQLEntryPanel pnl = this._panel.getSQLEntryPanel();
        int selStart = -1;
        if (select) {
            selStart = pnl.getSelectionStart();
        }
        pnl.replaceSelection(sqlScript);
        if (select) {
            int selEnd;
            int entireLen = this.getEntireSQLScript().length();
            if (selStart == -1) {
                selStart = 0;
            }
            if ((selEnd = selStart + sqlScript.length() - 1) > entireLen - 1) {
                selEnd = entireLen - 1;
            }
            if (selStart <= selEnd) {
                pnl.setSelectionStart(selStart);
                pnl.setSelectionEnd(selEnd);
            }
        }
    }

    @Override
    public int getSQLScriptSelectionStart() {
        return this._panel.getSQLEntryPanel().getSelectionStart();
    }

    @Override
    public int getSQLScriptSelectionEnd() {
        return this._panel.getSQLEntryPanel().getSelectionEnd();
    }

    @Override
    public void setSQLScriptSelectionStart(int start) {
        this._panel.getSQLEntryPanel().setSelectionStart(start);
    }

    @Override
    public void setSQLScriptSelectionEnd(int end) {
        this._panel.getSQLEntryPanel().setSelectionEnd(end);
    }

    @Override
    public void executeCurrentSQL() {
        this._panel.runCurrentExecuter();
    }

    @Override
    public void executeAllSQLs() {
        this._panel.runAllSqlsExecuter();
    }

    @Override
    public void closeAllSQLResultTabs() {
        this._panel.getSQLExecPanel().closeAllSQLResultTabs();
    }

    @Override
    public void closeAllSQLResultTabs(boolean isMemoryCleanUp) {
        this._panel.getSQLExecPanel().closeAllSQLResultTabs(isMemoryCleanUp);
    }

    @Override
    public void closeAllButCurrentResultTabs() {
        this._panel.getSQLExecPanel().closeAllButCurrentResultTabs();
    }

    @Override
    public void closeAllToResultTabs(boolean left) {
        this._panel.getSQLExecPanel().closeAllToResultTabs(left);
    }

    @Override
    public void closeCurrentResultTab() {
        this._panel.getSQLExecPanel().closeCurrentResultTab();
    }

    @Override
    public void toggleCurrentSQLResultTabSticky() {
        this._panel.getSQLExecPanel().toggleCurrentSQLResultTabSticky();
    }

    @Override
    public void toggleCurrentSQLResultTabAnchored() {
        this._panel.getSQLExecPanel().toggleCurrentSQLResultTabAnchored();
    }

    @Override
    public void closeAllSQLResultFrames() {
        this._panel.getSQLExecPanel().closeAllSQLResultFrames();
    }

    @Override
    public synchronized void gotoNextResultsTab() {
        this._panel.getSQLExecPanel().gotoNextResultsTab();
    }

    @Override
    public void gotoPreviousResultsTab() {
        this._panel.getSQLExecPanel().gotoPreviousResultsTab();
    }

    @Override
    public void addToSQLEntryAreaMenu(JMenu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("Menu == null");
        }
        this._panel.addToSQLEntryAreaMenu(menu);
    }

    @Override
    public JMenuItem addToSQLEntryAreaMenu(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Action == null");
        }
        return this._panel.addToSQLEntryAreaMenu(action);
    }

    @Override
    public void addSeparatorToSQLEntryAreaMenu() {
        this._panel.addSeparatorToSQLEntryAreaMenu();
    }

    @Override
    public ISession getSession() {
        return this._panel.getSession();
    }

    @Override
    public boolean confirmClose() {
        if (!this._panel.getSQLExecPanel().confirmClose()) {
            return false;
        }
        return false != this._fileHandler.showConfirmCloseIfNecessary();
    }

    @Override
    public ArrayList<SQLHistoryItem> getSQLHistoryItems() {
        return this._panel.getSQLHistoryItems();
    }

    @Override
    public void toggleMinimizeResults() {
        this._panel.toggleMinimizeResults();
    }

    @Override
    public void resetUnsavedEdits() {
        this._fileHandler.resetUnsavedEdits();
    }

    @Override
    public SQLPanelSplitter getSQLPanelSplitter() {
        return this._panel.getSqlPanelSplitter();
    }

    @Override
    public ChangeTracker getChangeTracker() {
        return this._panel.getChangeTracker();
    }

    @Override
    public void selectWidgetOrTab() {
        SQLPanelSelectionHandler.selectSqlPanel(this);
    }

    @Override
    public Frame getOwningFrame() {
        return SessionUtils.getOwningFrame(this);
    }

    @Override
    public int getCaretPosition() {
        return this._panel.getSQLEntryPanel().getCaretPosition();
    }

    @Override
    public void setCaretPosition(int caretPos) {
        this._panel.getSQLEntryPanel().setCaretPosition(caretPos);
    }

    @Override
    public JTextArea getTextComponent() {
        return this._panel.getSQLEntryPanel().getTextComponent();
    }

    @Override
    public FileHandler getFileHandler() {
        return this._fileHandler;
    }

    @Override
    public ISQLPanelAPI getSQLPanelAPIOrNull() {
        return this;
    }

    @Override
    public byte[] getBytesForSave() {
        return this._fileHandler.getBytesForSave();
    }

    @Override
    public UndoRedoActionContext getUndoRedoActionContext() {
        return this._panel.getUndoHandlerImpl().getUndoRedoActionContext();
    }

    @Override
    public SQLPanelPosition getSQLPanelPosition() {
        return this._panel.getSQLPanelPosition();
    }
}

