/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAliasConnectionProperties;
import net.sourceforge.squirrel_sql.client.gui.db.encryption.AliasPasswordHandler;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.ISessionWidget;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrame;
import net.sourceforge.squirrel_sql.client.gui.session.CurrentSchemaModel;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SessionPanel;
import net.sourceforge.squirrel_sql.client.mainframe.action.openconnection.OpenConnectionCommand;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.JdbcConnectionData;
import net.sourceforge.squirrel_sql.client.session.ModificationAwareSessionTitle;
import net.sourceforge.squirrel_sql.client.session.SessionConnectionKeepAlive;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.client.session.SimpleSessionListenerManager;
import net.sourceforge.squirrel_sql.client.session.action.reconnect.ReconnectInfo;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionJsonBean;
import net.sourceforge.squirrel_sql.client.session.connectionpool.SessionConnectionPool;
import net.sourceforge.squirrel_sql.client.session.event.SimpleSessionListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IMainPanelTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanel;
import net.sourceforge.squirrel_sql.client.session.parser.IParserEventsProcessor;
import net.sourceforge.squirrel_sql.client.session.parser.ParserEventsProcessor;
import net.sourceforge.squirrel_sql.client.session.parser.ParserEventsProcessorDummy;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SchemaInfo;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnectionState;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.QueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.TokenizerSessPropsInteractions;
import net.sourceforge.squirrel_sql.fw.util.DefaultExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.ExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.NullMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

class Session
implements ISession {
    private static final ILogger s_log = LoggerController.createLogger(Session.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(Session.class);
    private String _title = "";
    private SessionPanel _sessionSheet;
    private final IIdentifier _id;
    private IApplication _app;
    private SessionConnectionPool _sessionConnectionPool;
    private ISQLDriver _driver;
    private SQLAlias _alias;
    private String _user;
    private String _password;
    private SessionProperties _props;
    private final Map<String, Map<String, Object>> _pluginObjects = new HashMap<String, Map<String, Object>>();
    private IMessageHandler _msgHandler = NullMessageHandler.getInstance();
    private final SchemaInfo _schemaInfo;
    private boolean _closed;
    private SQLConnectionListener _connLis = null;
    private ISessionWidget _activeActiveSessionWindow;
    private SessionInternalFrame _sessionInternalFrame;
    private Hashtable<IIdentifier, IParserEventsProcessor> _parserEventsProcessorsByEntryPanelIdentifier = new Hashtable();
    private volatile boolean _finishedLoading = false;
    private volatile boolean _pluginsFinishedLoading = false;
    private boolean customTokenizerInstalled = false;
    private IQueryTokenizer tokenizer = null;
    private DefaultExceptionFormatter formatter = new DefaultExceptionFormatter();
    private SessionConnectionKeepAlive _sessionConnectionKeepAlive = null;
    private SimpleSessionListenerManager _simpleSessionListenerManager;
    private HashMap<Object, Object> _sessionLocales = new HashMap();
    private SavedSessionJsonBean _savedSession;
    private CurrentSchemaModel _currentSchemaModel;
    private ModificationAwareSessionTitle _modificationAwareSessionTitle = new ModificationAwareSessionTitle();

    public Session(IApplication app, ISQLDriver driver, SQLAlias alias, SQLConnection conn, String user, String password, IIdentifier sessionId) {
        if (app == null) {
            throw new IllegalArgumentException("null IApplication passed");
        }
        if (driver == null) {
            throw new IllegalArgumentException("null ISQLDriver passed");
        }
        if (alias == null) {
            throw new IllegalArgumentException("null SQLAlias passed");
        }
        if (conn == null) {
            throw new IllegalArgumentException("null SQLConnection passed");
        }
        if (sessionId == null) {
            throw new IllegalArgumentException("sessionId == null");
        }
        this._schemaInfo = new SchemaInfo(app);
        this._app = app;
        this._driver = driver;
        this._alias = new SQLAlias();
        this._alias.assignFrom(alias, true);
        this._props = (SessionProperties)this._app.getSquirrelPreferences().getSessionProperties().clone();
        this._user = user;
        this._password = password;
        this._id = sessionId;
        this._sessionConnectionPool = this.createConnectionPool(conn);
        this.setupTitle();
        this._connLis = new SQLConnectionListener();
        this._sessionConnectionPool.getMasterSQLConnection().addPropertyChangeListener(this._connLis);
        this.checkDriverVersion();
        this._app.getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                Session.this._schemaInfo.initialLoad(Session.this);
                Session.this._finishedLoading = true;
            }
        });
        this.startKeepAliveTaskIfNecessary();
        this._simpleSessionListenerManager = new SimpleSessionListenerManager(app, this);
        this._currentSchemaModel = new CurrentSchemaModel(this);
    }

    private SessionConnectionPool createConnectionPool(SQLConnection conn) {
        return new SessionConnectionPool(conn, this._alias, this._user, this._password, this._props, () -> this._msgHandler, () -> this._sessionSheet.getSelectedCatalogFromCatalogsComboBox());
    }

    private void startKeepAliveTaskIfNecessary() {
        SQLAliasConnectionProperties connProps = this._alias.getConnectionProperties();
        if (connProps.isEnableConnectionKeepAlive()) {
            String keepAliveSql = connProps.getKeepAliveSqlStatement();
            long sleepMillis = connProps.getKeepAliveSleepTimeSeconds() * 1000;
            if (StringUtilities.isEmpty(keepAliveSql, true)) {
                String msg = s_stringMgr.getString("alias.properties.no.keepAliveSql");
                this.getApplication().getMessageHandler().showErrorMessage(msg);
                s_log.error(msg);
                return;
            }
            this._sessionConnectionKeepAlive = new SessionConnectionKeepAlive(this._sessionConnectionPool, sleepMillis, keepAliveSql, this._alias.getName());
            this._app.getThreadPool().addTask(this._sessionConnectionKeepAlive, "Session Connection Keep-Alive (" + this._alias.getName() + ")");
        }
    }

    private void stopKeepAliveTaskIfNecessary() {
        if (this._sessionConnectionKeepAlive != null) {
            this._sessionConnectionKeepAlive.setStopped(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (!this._closed) {
            this.stopKeepAliveTaskIfNecessary();
            if (null != this._sessionConnectionPool) {
                this._sessionConnectionPool.getMasterSQLConnection().removePropertyChangeListener(this._connLis);
            }
            this._connLis = null;
            IParserEventsProcessor[] procs = this._parserEventsProcessorsByEntryPanelIdentifier.values().toArray(new IParserEventsProcessor[0]);
            for (int i = 0; i < procs.length; ++i) {
                try {
                    if (!(procs[i] instanceof ParserEventsProcessor)) continue;
                    ((ParserEventsProcessor)procs[i]).endProcessing();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this._schemaInfo.dispose();
            try {
                this.closeConnectionPool();
            }
            finally {
                this._closed = true;
                if (this._sessionSheet != null) {
                    this._sessionSheet.sessionHasClosed();
                    this._sessionSheet = null;
                }
                if (this._sessionInternalFrame != null) {
                    this._sessionInternalFrame.getMainSQLPanelAPI().closeAllSQLResultTabs(true);
                }
            }
        }
    }

    @Override
    public synchronized void commit() {
        try {
            this.getSQLConnection().commit();
            String msg = s_stringMgr.getString("Session.commit");
            this._msgHandler.showMessage(msg);
        }
        catch (Throwable ex) {
            this._msgHandler.showErrorMessage(ex, this.formatter);
        }
    }

    @Override
    public synchronized void rollback() {
        try {
            this.getSQLConnection().rollback();
            String msg = s_stringMgr.getString("Session.rollback");
            this._msgHandler.showMessage(msg);
        }
        catch (Exception ex) {
            this._msgHandler.showErrorMessage(ex, this.formatter);
        }
    }

    @Override
    public IIdentifier getIdentifier() {
        return this._id;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public IApplication getApplication() {
        return this._app;
    }

    @Override
    public ISQLConnection getSQLConnection() {
        this.checkConnectionPool();
        return this._sessionConnectionPool.getMasterSQLConnection();
    }

    @Override
    public ISQLConnection checkOutUserQuerySQLConnection() {
        this.checkConnectionPool();
        return this._sessionConnectionPool.checkOutUserQuerySQLConnection();
    }

    @Override
    public void returnUserQuerySQLConnection(ISQLConnection conn) {
        if (null != this._sessionConnectionPool) {
            this._sessionConnectionPool.returnUserQuerySQLConnection(conn);
        }
    }

    @Override
    public ISQLDriver getDriver() {
        return this._driver;
    }

    @Override
    public SQLAlias getAlias() {
        return this._alias;
    }

    @Override
    public SessionProperties getProperties() {
        return this._props;
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return this._schemaInfo;
    }

    @Override
    public synchronized Object getPluginObject(IPlugin plugin, String key) {
        if (plugin == null) {
            throw new IllegalArgumentException("Null IPlugin passed");
        }
        if (key == null) {
            throw new IllegalArgumentException("Null key passed");
        }
        Map<String, Object> map = this._pluginObjects.get(plugin.getInternalName());
        if (map == null) {
            map = new HashMap<String, Object>();
            this._pluginObjects.put(plugin.getInternalName(), map);
        }
        return map.get(key);
    }

    @Override
    public void addToToolbar(Action action) {
        this._sessionSheet.addToToolbar(action);
    }

    @Override
    public void addSeparatorToToolbar() {
        this._sessionSheet.addSeparatorToToolbar();
    }

    @Override
    public synchronized Object putPluginObject(IPlugin plugin, String key, Object value) {
        if (plugin == null) {
            throw new IllegalArgumentException("Null IPlugin passed");
        }
        if (key == null) {
            throw new IllegalArgumentException("Null key passed");
        }
        Map<String, Object> map = this._pluginObjects.get(plugin.getInternalName());
        if (map == null) {
            map = new HashMap<String, Object>();
            this._pluginObjects.put(plugin.getInternalName(), map);
        }
        return map.put(key, value);
    }

    @Override
    public synchronized void removePluginObject(IPlugin plugin, String key) {
        if (plugin == null) {
            throw new IllegalArgumentException("Null IPlugin passed");
        }
        if (key == null) {
            throw new IllegalArgumentException("Null key passed");
        }
        Map<String, Object> map = this._pluginObjects.get(plugin.getInternalName());
        if (map != null) {
            map.remove(key);
        }
    }

    private synchronized void closeConnectionPool() throws SQLException {
        if (this._sessionConnectionPool != null) {
            this.stopKeepAliveTaskIfNecessary();
            try {
                this._sessionConnectionPool.close();
            }
            finally {
                this._sessionConnectionPool = null;
            }
        }
    }

    @Override
    public JdbcConnectionData getJdbcData() {
        IIdentifier driverID = this._alias.getDriverIdentifier();
        ISQLDriver sqlDriver = this._app.getAliasesAndDriversManager().getDriver(driverID);
        return new JdbcConnectionData(sqlDriver.getDriverClassName(), this._alias.getUrl(), this._user, this._password);
    }

    @Override
    public void reconnect(ReconnectInfo reconnectInfo) {
        String msg;
        SQLConnectionState connState = new SQLConnectionState();
        try {
            if (null != this._sessionConnectionPool) {
                connState.saveState(this._sessionConnectionPool.getMasterSQLConnection(), this.getProperties(), this._msgHandler, this._sessionSheet.getSelectedCatalogFromCatalogsComboBox());
            } else {
                connState.saveState(null, this.getProperties(), this._msgHandler, this._sessionSheet.getSelectedCatalogFromCatalogsComboBox());
            }
        }
        catch (Exception e) {
            s_log.error("Failed to save connection state", e);
        }
        OpenConnectionCommand cmd = new OpenConnectionCommand(this._alias, this._user, this._password, connState.getConnectionProperties(), reconnectInfo);
        try {
            this.closeConnectionPool();
            this._app.getSessionManager().fireConnectionClosedForReconnect(this);
        }
        catch (SQLException ex) {
            msg = s_stringMgr.getString("Session.error.connclose");
            s_log.error(msg, ex);
            this._msgHandler.showErrorMessage(msg);
            this._msgHandler.showErrorMessage(ex, this.getExceptionFormatter());
        }
        try {
            cmd.executeConnectAndWaitForResultInBackground(t -> this.reconnectDone(connState, cmd, t, reconnectInfo));
        }
        catch (Throwable t2) {
            msg = s_stringMgr.getString("Session.reconnError", this._alias.getName());
            this._msgHandler.showErrorMessage(msg + "\n" + t2.toString());
            s_log.error(msg, t2);
            this._app.getSessionManager().fireReconnectFailed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnectDone(SQLConnectionState connState, OpenConnectionCommand cmd, Throwable t, ReconnectInfo reconnectInfo) {
        try {
            if (null != t) {
                throw t;
            }
            if (!StringUtilities.isEmpty(reconnectInfo.getUrl())) {
                this._alias.setUrl(reconnectInfo.getUrl());
            }
            if (!StringUtilities.isEmpty(reconnectInfo.getUser())) {
                this._user = reconnectInfo.getUser();
                this._alias.setUserName(this._user);
            }
            if (!StringUtilities.isEmpty(reconnectInfo.getPassword())) {
                this._password = reconnectInfo.getPassword();
                AliasPasswordHandler.setPassword(this._alias, this._password);
            }
            if (reconnectInfo.isSkipOpeningNewConnection()) {
                String usrRequestedNoRecoonectMsg = s_stringMgr.getString("Session.reconn.skiped.on.user.request");
                throw new RuntimeException(usrRequestedNoRecoonectMsg);
            }
            SQLConnection conn = cmd.getSQLConnection();
            try {
                if (connState != null) {
                    connState.restoreState(conn, this._msgHandler);
                }
            }
            finally {
                this._sessionConnectionPool = this.createConnectionPool(conn);
            }
            if (connState != null) {
                this._props.setAutoCommit(connState.getAutoCommit());
            }
            String msg = s_stringMgr.getString("Session.reconn", this._alias.getName());
            this._msgHandler.showMessage(msg);
            this._app.getSessionManager().fireReconnected(this);
            this.startKeepAliveTaskIfNecessary();
        }
        catch (Throwable th) {
            String msg = s_stringMgr.getString("Session.reconnError", this._alias.getName());
            this._msgHandler.showErrorMessage(msg + "\n" + th.toString());
            s_log.error(msg, th);
            this._app.getSessionManager().fireReconnectFailed(this);
        }
    }

    @Override
    public void setMessageHandler(IMessageHandler handler) {
        this._msgHandler = handler != null ? handler : NullMessageHandler.getInstance();
    }

    @Override
    public void setSessionInternalFrame(SessionInternalFrame sif) {
        this._sessionInternalFrame = sif;
        this._activeActiveSessionWindow = sif;
        this._sessionSheet = sif.getSessionPanel();
    }

    @Override
    public synchronized SessionInternalFrame getSessionInternalFrame() {
        return this._sessionInternalFrame;
    }

    @Override
    public synchronized SessionPanel getSessionPanel() {
        return this._sessionSheet;
    }

    @Override
    public void selectMainTab(int tabIndex) {
        this._sessionSheet.selectMainTab(tabIndex);
    }

    @Override
    public int getMainPanelTabIndex(IMainPanelTab mainPanelTab) {
        return this._sessionSheet.getMainPanelTabIndex(mainPanelTab);
    }

    @Override
    public int getSelectedMainTabIndex() {
        return this._sessionSheet.getSelectedMainTabIndex();
    }

    @Override
    public IMainPanelTab getSelectedMainTab() {
        return this._sessionSheet.getSelectedMainTab();
    }

    @Override
    public int addMainTab(IMainPanelTab tab) {
        return this._sessionSheet.addMainTab(tab);
    }

    @Override
    public String getTitle() {
        return this.getTitleModificationAware().getTitle();
    }

    @Override
    public ModificationAwareSessionTitle getTitleModificationAware() {
        return this._modificationAwareSessionTitle;
    }

    @Override
    public void setUserChangedTitle(String newTitle) {
        this._modificationAwareSessionTitle.setTitle(newTitle, true);
    }

    public String toString() {
        return this.getTitle();
    }

    private void setupTitle() {
        String user;
        Object catalog = null;
        try {
            catalog = this.getSQLConnection().getCatalog();
        }
        catch (SQLException ex) {
            s_log.error("Error occurred retrieving current catalog from Connection", ex);
        }
        catalog = catalog == null ? "" : "(" + (String)catalog + ")";
        String title = null;
        String string = user = this._user != null ? this._user : "";
        if (this.getApplication().getSquirrelPreferences().getUseShortSessionTitle()) {
            title = this.getAlias().getName();
        } else if (user.length() > 0) {
            String[] args = new String[]{this.getAlias().getName(), catalog, user};
            title = s_stringMgr.getString("Session.title1", args);
        } else {
            String[] args = new String[]{this.getAlias().getName(), catalog};
            title = s_stringMgr.getString("Session.title0", args);
        }
        this._modificationAwareSessionTitle.setTitle(this._id + " - " + title);
    }

    @Override
    public IParserEventsProcessor getParserEventsProcessor(IIdentifier entryPanelIdentifier) {
        IParserEventsProcessor pep = this._parserEventsProcessorsByEntryPanelIdentifier.get(entryPanelIdentifier);
        if (null == pep) {
            ISQLPanelAPI panelAPI = SessionUtils.getSqlPanelApi(entryPanelIdentifier, this.getIdentifier());
            pep = null != panelAPI ? new ParserEventsProcessor(panelAPI, this) : new ParserEventsProcessorDummy();
            this._parserEventsProcessorsByEntryPanelIdentifier.put(entryPanelIdentifier, pep);
        }
        return pep;
    }

    @Override
    public void setActiveSessionWindow(ISessionWidget activeActiveSessionWindow) {
        this._activeActiveSessionWindow = activeActiveSessionWindow;
    }

    @Override
    public ISessionWidget getActiveSessionWindow() {
        return this._activeActiveSessionWindow;
    }

    @Override
    public ISQLPanelAPI getSQLPanelAPIOfActiveSessionWindow() {
        return this.getSQLPanelAPIOfActiveSessionWindow(false);
    }

    @Override
    public ISQLPanelAPI getSQLPanelAPIOfActiveSessionWindow(boolean allowReturnNull) {
        ISQLPanelAPI sqlPanelAPI = null;
        if (this.isSessionWidgetActive()) {
            sqlPanelAPI = ((SessionInternalFrame)this._activeActiveSessionWindow).getSelectedOrMainSQLPanelAPI();
        } else if (this._activeActiveSessionWindow instanceof SQLInternalFrame) {
            sqlPanelAPI = ((SQLInternalFrame)this._activeActiveSessionWindow).getMainSQLPanelAPI();
        } else if (!allowReturnNull) {
            throw new IllegalStateException("SQLPanelApi can only be provided for SessionInternalFrame or SQLInternalFrame");
        }
        return sqlPanelAPI;
    }

    @Override
    public boolean isSessionWidgetActive() {
        return this._activeActiveSessionWindow instanceof SessionInternalFrame;
    }

    @Override
    public IObjectTreeAPI getObjectTreeAPIOfActiveSessionWindow() {
        IObjectTreeAPI objectTreeAPI;
        if (this.isSessionWidgetActive()) {
            objectTreeAPI = ((SessionInternalFrame)this._activeActiveSessionWindow).getObjectTreeAPI();
        } else if (this._activeActiveSessionWindow instanceof ObjectTreeInternalFrame) {
            objectTreeAPI = ((ObjectTreeInternalFrame)this._activeActiveSessionWindow).getObjectTreeAPI();
        } else {
            throw new IllegalStateException("ObjectTreeApi can only be provided for SessionInternalFrame or ObjectTreeInternalFrame");
        }
        return objectTreeAPI;
    }

    private void checkDriverVersion() {
        if (!this._app.getSquirrelPreferences().getWarnJreJdbcMismatch()) {
            return;
        }
        boolean driverIs21Compliant = true;
        SQLDatabaseMetaData md = this._sessionConnectionPool.getMasterSQLConnection().getSQLMetaData();
        try {
            md.supportsResultSetType(1003);
        }
        catch (Throwable e) {
            driverIs21Compliant = false;
        }
        if (!driverIs21Compliant) {
            String msg = s_stringMgr.getString("Session.driverCompliance", this._alias.getName());
            String title = s_stringMgr.getString("Session.driverComplianceTitle");
            this.showMessageDialog(msg, title, 2);
            s_log.info(msg);
            return;
        }
        boolean driverIs30Compliant = true;
        try {
            md.supportsSavepoints();
        }
        catch (Throwable e) {
            driverIs30Compliant = false;
        }
        if (!driverIs30Compliant) {
            String msg = s_stringMgr.getString("Session.driverCompliance3.0", this._alias.getName());
            String title = s_stringMgr.getString("Session.driverComplianceTitle");
            this.showMessageDialog(msg, title, 2);
            if (s_log.isInfoEnabled()) {
                s_log.info(msg);
            }
        }
    }

    private void showMessageDialog(final String message, final String title, final int messageType) {
        final MainFrame f = this._app.getMainFrame();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(f, message, title, messageType);
            }
        });
    }

    protected void finalize() {
        this._app.getSessionManager().fireSessionFinalized(this._id);
    }

    @Override
    public void setPluginsfinishedLoading(boolean pluginsFinishedLoading) {
        this._pluginsFinishedLoading = pluginsFinishedLoading;
    }

    @Override
    public boolean isfinishedLoading() {
        return this._finishedLoading && this._pluginsFinishedLoading;
    }

    @Override
    public boolean confirmClose() {
        ISessionWidget[] frames = this.getApplication().getWindowManager().getAllFramesOfSession(this.getIdentifier());
        for (ISessionWidget frame : frames) {
            if (!(frame instanceof SQLInternalFrame) || ((SQLInternalFrame)frame).getMainSQLPanelAPI().confirmClose()) continue;
            frame.moveToFront();
            return false;
        }
        for (SQLPanel sqlPanel : this.getSessionInternalFrame().getSessionPanel().getAllSQLPanels()) {
            if (sqlPanel.getSQLPanelAPI().confirmClose()) continue;
            return false;
        }
        return true;
    }

    @Override
    public IQueryTokenizer getQueryTokenizer() {
        if (this.tokenizer == null || !this.customTokenizerInstalled) {
            this.tokenizer = new QueryTokenizer(this._props.getSQLStatementSeparator(), this._props.getStartOfLineComment(), this._props.getRemoveMultiLineComment(), this._props.getRemoveLineComment());
        }
        return this.tokenizer;
    }

    @Override
    public void setQueryTokenizer(IQueryTokenizer aTokenizer) {
        if (aTokenizer == null) {
            throw new IllegalArgumentException("aTokenizer arg cannot be null");
        }
        if (this.customTokenizerInstalled) {
            String currentTokenizer = this.tokenizer.getClass().getName();
            String newTokenizer = this.tokenizer.getClass().getName();
            throw new IllegalStateException("Only one custom query tokenizer can be installed.  Current tokenizer is " + currentTokenizer + ". New tokenizer is " + newTokenizer);
        }
        this.customTokenizerInstalled = true;
        this.tokenizer = aTokenizer;
        TokenizerSessPropsInteractions tep = this.tokenizer.getTokenizerSessPropsInteractions();
        if (tep.isTokenizerDefinesStatementSeparator()) {
            this._props.setSQLStatementSeparator(aTokenizer.getSQLStatementSeparator());
        }
        if (tep.isTokenizerDefinesStartOfLineComment()) {
            this._props.setStartOfLineComment(aTokenizer.getLineCommentBegin());
        }
        if (tep.isTokenizerDefinesRemoveMultiLineComment()) {
            this._props.setRemoveMultiLineComment(aTokenizer.isRemoveMultiLineComment());
        }
        if (tep.isTokenizerDefinesRemoveLineComment()) {
            this._props.setRemoveMultiLineComment(aTokenizer.isRemoveLineComment());
        }
    }

    @Override
    public ISQLDatabaseMetaData getMetaData() {
        if (this._sessionConnectionPool != null) {
            return this._sessionConnectionPool.getMasterSQLConnection().getSQLMetaData();
        }
        return null;
    }

    @Override
    public void setExceptionFormatter(ExceptionFormatter formatter) {
        this.formatter.setCustomExceptionFormatter(formatter);
    }

    @Override
    public ExceptionFormatter getExceptionFormatter() {
        return this.formatter;
    }

    @Override
    public String formatException(Throwable th) {
        return this.formatter.format(th);
    }

    @Override
    public void showErrorMessage(String msg) {
        this._msgHandler.showErrorMessage(msg);
    }

    @Override
    public void showErrorMessage(Throwable th) {
        this._msgHandler.showErrorMessage(th, this.formatter);
    }

    @Override
    public void showMessage(String msg) {
        this._msgHandler.showMessage(msg);
    }

    @Override
    public void showMessage(Throwable th) {
        this._msgHandler.showMessage(th, this.formatter);
    }

    @Override
    public void showWarningMessage(String msg) {
        this._msgHandler.showWarningMessage(msg);
    }

    @Override
    public void showWarningMessage(Throwable th) {
        this._msgHandler.showWarningMessage(th, this.formatter);
    }

    @Override
    public SQLConnection createUnmanagedConnection() {
        try {
            SQLConnectionState connState = new SQLConnectionState();
            OpenConnectionCommand cmd = new OpenConnectionCommand(this._alias, this._user, this._password, connState.getConnectionProperties());
            cmd.executeAndWait();
            return cmd.getSQLConnection();
        }
        catch (Exception e) {
            s_log.error(e);
            this.showErrorMessage(e);
            return null;
        }
    }

    @Override
    public void addSimpleSessionListener(SimpleSessionListener simpleSessionListener) {
        this._simpleSessionListenerManager.addListener(simpleSessionListener);
    }

    @Override
    public void removeSimpleSessionListener(SimpleSessionListener simpleSessionListener) {
        this._simpleSessionListenerManager.removeListener(simpleSessionListener);
    }

    @Override
    public void putSessionLocal(Object key, Object value) {
        this._sessionLocales.put(key, value);
    }

    @Override
    public Object getSessionLocal(Object key) {
        return this._sessionLocales.get(key);
    }

    @Override
    public SessionConnectionPool getConnectionPool() {
        this.checkConnectionPool();
        return this._sessionConnectionPool;
    }

    private void checkConnectionPool() {
        if (null == this._sessionConnectionPool) {
            if (0 == this._props.getQueryConnectionPoolSize()) {
                throw new IllegalStateException("No Connection instance. This may happen when reconnect (Ctrl+T) failed.");
            }
            throw new IllegalStateException("No ConnectionPool instance. This may happen when reconnect (Ctrl+T) failed.");
        }
    }

    @Override
    public SavedSessionJsonBean getSavedSession() {
        return this._savedSession;
    }

    @Override
    public void setSavedSession(SavedSessionJsonBean savedSession) {
        this._savedSession = savedSession;
    }

    @Override
    public CurrentSchemaModel getCurrentSchemaModel() {
        return this._currentSchemaModel;
    }

    private class SQLConnectionListener
    implements PropertyChangeListener {
        private SQLConnectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName == null || "catalog".equalsIgnoreCase(propName)) {
                GUIUtils.processOnSwingEventThread(() -> Session.this.setupTitle());
            }
        }
    }
}

