/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.sql.Statement;
import java.util.Iterator;
import net.sourceforge.squirrel_sql.client.session.connectionpool.SessionConnectionPool;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SessionConnectionKeepAlive
implements Runnable {
    private static final ILogger s_log = LoggerController.createLogger(SessionConnectionKeepAlive.class);
    private final long _sleepMillis;
    private final SessionConnectionPool _sessionConnectionPool;
    private final String _sql;
    private volatile boolean _isStopped = false;
    private final String _aliasName;

    public SessionConnectionKeepAlive(SessionConnectionPool sessionConnectionPool, long sleepMillis, String sql, String aliasName) {
        if (sleepMillis < 1000L) {
            throw new IllegalArgumentException("Sleep time must be at least 1000ms(1 second)");
        }
        this._sleepMillis = sleepMillis;
        Utilities.checkNull("SessionConnectionKeepAlive", "sessionConnectionPool", sessionConnectionPool, "sql", sql);
        this._sessionConnectionPool = sessionConnectionPool;
        this._sql = sql;
        this._aliasName = aliasName;
    }

    public void setStopped(boolean isStopped) {
        this._isStopped = isStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block5: while (true) {
            Iterator<ISQLConnection> iterator = this._sessionConnectionPool.getAllSQLConnections().iterator();
            while (true) {
                if (!iterator.hasNext()) continue block5;
                ISQLConnection con = iterator.next();
                if (this._isStopped) {
                    return;
                }
                Statement stmt = null;
                try {
                    stmt = con.createStatement();
                    s_log.info("SessionConnectionKeepAlive (" + this._aliasName + ") running SQL: " + this._sql);
                    stmt.executeQuery(this._sql);
                }
                catch (Throwable t) {
                    s_log.error("run: unexpected exception while executing sql (" + this._sql + "): " + t.getMessage(), t);
                }
                finally {
                    SQLUtilities.closeStatement(stmt);
                }
                Utilities.sleep(this._sleepMillis);
            }
            break;
        }
    }
}

