/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.awt.Window;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.session.IAllowedSchemaChecker;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.Session;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.client.session.event.ISessionListener;
import net.sourceforge.squirrel_sql.client.session.event.SessionEvent;
import net.sourceforge.squirrel_sql.fw.gui.DontShowAgainDialog;
import net.sourceforge.squirrel_sql.fw.gui.DontShowAgainResult;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IntegerIdentifierFactory;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SessionManager {
    private static final ILogger s_log = LoggerController.createLogger(SessionManager.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SessionManager.class);
    private ISession _activeSession;
    private final ArrayList<ISession> _sessionsList = new ArrayList();
    private final Map<IIdentifier, ISession> _sessionsById = new HashMap<IIdentifier, ISession>();
    private EventListenerList listenerList = new EventListenerList();
    private final IntegerIdentifierFactory _idFactory = new IntegerIdentifierFactory(1);
    private ArrayList<IAllowedSchemaChecker> _allowedSchemaCheckers = new ArrayList();
    private Hashtable<IIdentifier, String[]> _allowedSchemasBySessionID = new Hashtable();
    private Hashtable<IIdentifier, String[]> _allSchemasBySessionID = new Hashtable();
    private HashSet<IIdentifier> _inCloseSession = new HashSet();
    private Set<IIdentifier> _inCreateSession = Collections.synchronizedSet(new HashSet());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ISession createSession(IApplication app, ISQLDriver driver, SQLAlias alias, SQLConnection conn, String user, String password) {
        IIdentifier sessionId = this._idFactory.createIdentifier();
        try {
            this._inCreateSession.add(sessionId);
            Session sess = new Session(app, driver, alias, conn, user, password, sessionId);
            this._sessionsList.add(sess);
            this._sessionsById.put(sess.getIdentifier(), sess);
            this.fireSessionAdded(sess);
            this.setActiveSession(sess, false);
            Session session = sess;
            return session;
        }
        finally {
            this._inCreateSession.remove(sessionId);
        }
    }

    public boolean isInCreateSession() {
        return 0 < this._inCreateSession.size();
    }

    public void setActiveSession(ISession session, boolean force) {
        if (session != this._activeSession || force) {
            this._activeSession = session;
            this.fireSessionActivated(session);
        }
    }

    public List<ISession> getOpenSessions() {
        return new ArrayList<ISession>(this._sessionsList);
    }

    public ISession getActiveSession() {
        return this._activeSession;
    }

    public ISession getSession(IIdentifier sessionID) {
        return this._sessionsById.get(sessionID);
    }

    public boolean closeSession(ISession session) {
        return this.closeSession(session, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeSession(ISession session, boolean doNothingAndReturnTrueWhenInClosing) {
        block15: {
            if (this.isInCloseSession(session)) {
                return doNothingAndReturnTrueWhenInClosing;
            }
            try {
                this._inCloseSession.add(session.getIdentifier());
                if (!this.confirmClose(session)) break block15;
                session.getApplication().getPluginManager().sessionEnding(session);
                this.fireSessionClosing(session);
                try {
                    session.close();
                }
                catch (SQLException sqle) {
                    s_log.error("Error closing Session", sqle);
                    session.showErrorMessage(s_stringMgr.getString("SessionManager.ErrorClosingSession", sqle));
                }
                this.fireSessionClosed(session);
                IIdentifier sessionId = session.getIdentifier();
                if (!this._sessionsList.remove(session)) {
                    s_log.error("SessionManager.closeSession()-> Session " + sessionId + " not found in _sessionsList when trying to remove it.");
                }
                if (this._sessionsById.remove(sessionId) == null) {
                    s_log.error("SessionManager.closeSession()-> Session " + sessionId + " not found in _sessionsById when trying to remove it.");
                }
                if (this._sessionsList.isEmpty()) {
                    this.fireAllSessionsClosed();
                }
                if (session == this._activeSession) {
                    if (!this._sessionsList.isEmpty()) {
                        this.setActiveSession(this._sessionsList.get(this._sessionsList.size() - 1), false);
                    } else {
                        this._activeSession = null;
                    }
                } else {
                    this.setActiveSession(this._activeSession, true);
                }
                this._allowedSchemasBySessionID.remove(session.getIdentifier());
                this._allSchemasBySessionID.remove(session.getIdentifier());
                boolean bl = true;
                return bl;
            }
            catch (Throwable ex) {
                s_log.error("Error closing Session", ex);
                session.showErrorMessage(s_stringMgr.getString("SessionManager.ErrorClosingSession", ex));
            }
            finally {
                this._inCloseSession.remove(session.getIdentifier());
            }
        }
        return false;
    }

    public boolean isInCloseSession(ISession session) {
        return this._inCloseSession.contains(session.getIdentifier());
    }

    public boolean closeAllSessions() {
        List<ISession> sessions = this.getOpenSessions();
        for (ISession session : sessions) {
            if (this.closeSession(session)) continue;
            return false;
        }
        return true;
    }

    public boolean closeAllButCurrentSessions() {
        ISession activeSession = this.getActiveSession();
        List<ISession> sessions = this.getOpenSessions();
        for (int i = sessions.size() - 1; i >= 0; --i) {
            if (sessions.get(i) == activeSession || this.closeSession(sessions.get(i))) continue;
            return false;
        }
        return true;
    }

    public void addSessionListener(ISessionListener lis) {
        if (lis != null) {
            this.listenerList.add(ISessionListener.class, lis);
        } else {
            s_log.error("Attempted to add null listener: SessionManager.addSessionListener");
        }
    }

    public void removeSessionListener(ISessionListener lis) {
        if (lis != null) {
            this.listenerList.remove(ISessionListener.class, lis);
        } else {
            s_log.error("Attempted to remove null listener: SessionManager.addSessionListener");
        }
    }

    private void fireSessionAdded(ISession session) {
        Object[] listeners = this.listenerList.getListenerList();
        SessionEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISessionListener.class) continue;
            if (evt == null) {
                evt = new SessionEvent(session);
            }
            ((ISessionListener)listeners[i + 1]).sessionConnected(evt);
        }
    }

    private void fireSessionClosed(ISession session) {
        Object[] listeners = this.listenerList.getListenerList();
        SessionEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISessionListener.class) continue;
            if (evt == null) {
                evt = new SessionEvent(session);
            }
            ((ISessionListener)listeners[i + 1]).sessionClosed(evt);
        }
    }

    private void fireSessionClosing(ISession session) {
        Object[] listeners = this.listenerList.getListenerList();
        SessionEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISessionListener.class) continue;
            if (evt == null) {
                evt = new SessionEvent(session);
            }
            ((ISessionListener)listeners[i + 1]).sessionClosing(evt);
        }
    }

    private void fireAllSessionsClosed() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISessionListener.class) continue;
            ((ISessionListener)listeners[i + 1]).allSessionsClosed();
        }
    }

    private void fireSessionActivated(ISession session) {
        Object[] listeners = this.listenerList.getListenerList();
        SessionEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISessionListener.class) continue;
            if (evt == null) {
                evt = new SessionEvent(session);
            }
            ((ISessionListener)listeners[i + 1]).sessionActivated(evt);
        }
    }

    private boolean confirmClose(ISession session) {
        if (!Main.getApplication().getSquirrelPreferences().getConfirmSessionClose()) {
            return session.confirmClose();
        }
        String msg = s_stringMgr.getString("SessionManager.confirmClose", session.getTitle());
        String switchOnHowTo = s_stringMgr.getString("SessionManager.confirmClose.switchOnHowTo", session.getTitle());
        DontShowAgainDialog confirmCloseDialog = new DontShowAgainDialog((Window)SessionUtils.getOwningFrame(session), msg, switchOnHowTo);
        confirmCloseDialog.setTitle(s_stringMgr.getString("SessionManager.confirmClose.title"));
        DontShowAgainResult result = confirmCloseDialog.showAndGetResult("SessionManagerDontShowAgainId", 380, 150);
        if (result.isDontShowAgain()) {
            Main.getApplication().getSquirrelPreferences().setConfirmSessionClose(false);
        }
        if (!result.isYes()) {
            return false;
        }
        return session.confirmClose();
    }

    void fireConnectionClosedForReconnect(Session session) {
        Object[] listeners = this.listenerList.getListenerList();
        SessionEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISessionListener.class) continue;
            if (evt == null) {
                evt = new SessionEvent(session);
            }
            ((ISessionListener)listeners[i + 1]).connectionClosedForReconnect(evt);
        }
    }

    void fireReconnected(Session session) {
        Object[] listeners = this.listenerList.getListenerList();
        SessionEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISessionListener.class) continue;
            if (evt == null) {
                evt = new SessionEvent(session);
            }
            ((ISessionListener)listeners[i + 1]).reconnected(evt);
        }
    }

    void fireReconnectFailed(Session session) {
        Object[] listeners = this.listenerList.getListenerList();
        SessionEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISessionListener.class) continue;
            if (evt == null) {
                evt = new SessionEvent(session);
            }
            ((ISessionListener)listeners[i + 1]).reconnectFailed(evt);
        }
    }

    void fireSessionFinalized(final IIdentifier sessionIdentifier) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object[] listeners = SessionManager.this.listenerList.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != ISessionListener.class) continue;
                    ((ISessionListener)listeners[i + 1]).sessionFinalized(sessionIdentifier);
                }
            }
        });
    }

    public void addAllowedSchemaChecker(IAllowedSchemaChecker allowedSchemaChecker) {
        this._allowedSchemaCheckers.add(allowedSchemaChecker);
    }

    public boolean areAllSchemasAllowed(ISession session) {
        try {
            String[] allowedSchemas = this.getAllowedSchemas(session);
            String[] schemas = this.getAllSchemas(session.getSQLConnection(), session.getIdentifier());
            return allowedSchemas.length == schemas.length;
        }
        catch (SQLException e) {
            s_log.error("Failed to check allowed Schemas", e);
            return true;
        }
    }

    public String[] getAllowedSchemas(ISession session) {
        String[] allowedSchemas = this._allowedSchemasBySessionID.get(session.getIdentifier());
        if (null == allowedSchemas) {
            allowedSchemas = this.getAllowedSchemas(session.getSQLConnection(), session.getAlias(), session.getIdentifier());
            this._allowedSchemasBySessionID.put(session.getIdentifier(), allowedSchemas);
        }
        return allowedSchemas;
    }

    public String[] getAllowedSchemas(ISQLConnection con, SQLAlias alias, IIdentifier sessionIdentifierOrNull) {
        try {
            HashMap<String, Object> uniqueAllowedSchemas = null;
            for (int i = 0; i < this._allowedSchemaCheckers.size(); ++i) {
                String[] allowedSchemas = null;
                try {
                    allowedSchemas = this._allowedSchemaCheckers.get(i).getAllowedSchemas(con, alias);
                }
                catch (Exception e) {
                    s_log.error("Failed to get allowed Schemas from Plugin", e);
                }
                if (null == allowedSchemas) continue;
                if (null == uniqueAllowedSchemas) {
                    uniqueAllowedSchemas = new HashMap<String, Object>();
                }
                for (int j = 0; j < allowedSchemas.length; ++j) {
                    uniqueAllowedSchemas.put(allowedSchemas[j], null);
                }
            }
            if (null == uniqueAllowedSchemas) {
                return this.getAllSchemas(con, sessionIdentifierOrNull);
            }
            ArrayList list = new ArrayList(uniqueAllowedSchemas.keySet());
            Collections.sort(list);
            return list.toArray(new String[list.size()]);
        }
        catch (Exception e) {
            s_log.error("Failed to get allowed Schemas", e);
            return new String[0];
        }
    }

    public String[] getAllSchemas(ISession session) throws SQLException {
        return this.getAllSchemas(session.getSQLConnection(), session.getIdentifier());
    }

    private String[] getAllSchemas(ISQLConnection con, IIdentifier sessionIdentifierOrNull) throws SQLException {
        if (null == sessionIdentifierOrNull) {
            return con.getSQLMetaData().getSchemas();
        }
        String[] ret = this._allSchemasBySessionID.get(sessionIdentifierOrNull);
        if (null == ret) {
            ret = con.getSQLMetaData().getSchemas();
            this._allSchemasBySessionID.put(sessionIdentifierOrNull, ret);
        }
        return ret;
    }

    public void clearSchemaCache(ISession session) {
        this._allowedSchemasBySessionID.remove(session.getIdentifier());
        this._allSchemasBySessionID.remove(session.getIdentifier());
    }
}

