/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.awt.Frame;
import java.beans.PropertyVetoException;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.ISessionWidget;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SessionPanel;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.filemanager.IFileEditorAPI;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IMainPanelTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SessionUtils {
    private static final ILogger s_log = LoggerController.createLogger(SessionUtils.class);

    public static Frame getOwningFrame(ISession destSession) {
        Frame owningFrame = destSession.getActiveSessionWindow().hasSQLPanelAPI() ? GUIUtils.getOwningFrame(destSession.getSQLPanelAPIOfActiveSessionWindow().getSQLEntryPanel().getTextComponent()) : GUIUtils.getOwningFrame(destSession.getObjectTreeAPIOfActiveSessionWindow().getDetailTabComp());
        return owningFrame;
    }

    public static Frame getOwningFrame(ISQLPanelAPI sqlPanelAPI) {
        return GUIUtils.getOwningFrame(sqlPanelAPI.getSQLEntryPanel().getTextComponent());
    }

    static ISQLPanelAPI getSqlPanelApi(IIdentifier entryPanelIdentifier, IIdentifier sessionIdentifier) {
        ISessionWidget[] frames = Main.getApplication().getWindowManager().getAllFramesOfSession(sessionIdentifier);
        for (int i = 0; i < frames.length; ++i) {
            IObjectTreeAPI objectTreeApi;
            IIdentifier findEditorID;
            if (frames[i] instanceof SQLInternalFrame) {
                ISQLPanelAPI sqlPanelAPI = ((SQLInternalFrame)frames[i]).getMainSQLPanelAPI();
                IIdentifier id = sqlPanelAPI.getSQLEntryPanel().getIdentifier();
                if (id.equals(entryPanelIdentifier)) {
                    return sqlPanelAPI;
                }
                if (Utilities.equalsRespectNull(sqlPanelAPI.getSQLPanelSplitter().getFindEntryPanelIdentifier(), entryPanelIdentifier)) {
                    return null;
                }
            }
            if (frames[i] instanceof SessionInternalFrame) {
                ISQLPanelAPI sqlPanelAPI = ((SessionInternalFrame)frames[i]).getMainSQLPanelAPI();
                IIdentifier sqlEditorID = sqlPanelAPI.getSQLEntryPanel().getIdentifier();
                if (sqlEditorID.equals(entryPanelIdentifier)) {
                    return sqlPanelAPI;
                }
                if (Utilities.equalsRespectNull(sqlPanelAPI.getSQLPanelSplitter().getFindEntryPanelIdentifier(), entryPanelIdentifier)) {
                    return null;
                }
                IObjectTreeAPI objectTreeApi2 = ((SessionInternalFrame)frames[i]).getObjectTreeAPI();
                SessionPanel sessionPanel = ((SessionInternalFrame)frames[i]).getSessionPanel();
                for (int j = 0; j < sessionPanel.getTabCount(); ++j) {
                    if (!(sessionPanel.getMainPanelTabAt(j) instanceof AdditionalSQLTab)) continue;
                    sqlPanelAPI = ((AdditionalSQLTab)sessionPanel.getMainPanelTabAt(j)).getSQLPanel().getSQLPanelAPI();
                    sqlEditorID = sqlPanelAPI.getSQLEntryPanel().getIdentifier();
                    if (sqlEditorID.equals(entryPanelIdentifier)) {
                        return sqlPanelAPI;
                    }
                    if (!Utilities.equalsRespectNull(sqlPanelAPI.getSQLPanelSplitter().getFindEntryPanelIdentifier(), entryPanelIdentifier)) continue;
                    return null;
                }
                IIdentifier findEditorID2 = objectTreeApi2.getFindController().getFindEntryPanel().getIdentifier();
                if (findEditorID2.equals(entryPanelIdentifier)) {
                    return null;
                }
            }
            if (!(frames[i] instanceof ObjectTreeInternalFrame) || !(findEditorID = (objectTreeApi = ((ObjectTreeInternalFrame)frames[i]).getObjectTreeAPI()).getFindController().getFindEntryPanel().getIdentifier()).equals(entryPanelIdentifier)) continue;
            return null;
        }
        throw new IllegalStateException("Session has no entry panel for ID=" + entryPanelIdentifier);
    }

    public static IMainPanelTab getOwningIMainPanelTab(IFileEditorAPI fileEditorAPI) {
        SessionPanel sessionSheet = fileEditorAPI.getSession().getSessionPanel();
        for (int i = 0; i < sessionSheet.getTabCount(); ++i) {
            IMainPanelTab mainPanelTab = sessionSheet.getMainPanelTabAt(i);
            if (mainPanelTab.getActiveFileEditorAPIOrNull() != fileEditorAPI) continue;
            return mainPanelTab;
        }
        return null;
    }

    public static AdditionalSQLTab createSQLTab(ISession session) {
        AdditionalSQLTab additionalSQLTab = new AdditionalSQLTab(session);
        int tabIndex = session.getSessionPanel().addMainTab(additionalSQLTab);
        session.getSessionPanel().selectMainTab(tabIndex);
        Main.getApplication().getPluginManager().additionalSQLTabOpened(additionalSQLTab);
        session.getSessionInternalFrame().moveToFront();
        return additionalSQLTab;
    }

    public static void activateMainSqlTab(SessionInternalFrame sessionInternalFrame, int caretPosition, boolean shouldForceToFocusActiveSqlEditor) {
        try {
            ISQLPanelAPI mainSQLPanelAPI = sessionInternalFrame.getMainSQLPanelAPI();
            sessionInternalFrame.setSelected(true);
            sessionInternalFrame.getSession().selectMainTab(1);
            if (0 <= caretPosition && caretPosition < mainSQLPanelAPI.getEntireSQLScript().length()) {
                SessionUtils.forceFocusAndSetCaret(caretPosition, mainSQLPanelAPI, shouldForceToFocusActiveSqlEditor);
            }
        }
        catch (PropertyVetoException e) {
            s_log.error("Failed to select Mains Session SQL Tab", e);
        }
    }

    public static void activateAdditionalSqlTab(SessionInternalFrame sessionInternalFrame, AdditionalSQLTab sqlTab, int caretPosition, boolean shouldForceToFocusActiveSqlEditor) {
        try {
            sessionInternalFrame.setSelected(true);
            int mainPanelTabIndex = sessionInternalFrame.getSession().getMainPanelTabIndex(sqlTab);
            sessionInternalFrame.getSession().selectMainTab(mainPanelTabIndex);
            if (0 <= caretPosition && caretPosition < sqlTab.getSQLPanelAPI().getEntireSQLScript().length()) {
                SessionUtils.forceFocusAndSetCaret(caretPosition, sqlTab.getSQLPanelAPI(), shouldForceToFocusActiveSqlEditor);
            }
        }
        catch (PropertyVetoException e) {
            s_log.error("Failed to select SQL Tab", e);
        }
    }

    public static void activateSqlInternalFrame(SQLInternalFrame sqlInternalFrame, int caretPosition, boolean shouldForceToFocusActiveSqlEditor) {
        try {
            sqlInternalFrame.setSelected(true);
            SessionUtils.forceFocusAndSetCaret(caretPosition, sqlInternalFrame.getMainSQLPanelAPI(), shouldForceToFocusActiveSqlEditor);
        }
        catch (PropertyVetoException e) {
            s_log.error("Failed to select SQL Worksheet", e);
        }
    }

    private static void forceFocusAndSetCaret(int caretPosition, ISQLPanelAPI sqlPanelAPI, boolean shouldForceToFocusActiveSqlEditor) {
        if (shouldForceToFocusActiveSqlEditor) {
            GUIUtils.forceFocus(sqlPanelAPI.getSQLEntryPanel().getTextComponent(), () -> sqlPanelAPI.setCaretPosition(caretPosition), "SessionUtils.forceFocusAndSetCaret");
        } else {
            sqlPanelAPI.setCaretPosition(caretPosition);
        }
    }
}

