/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.gui.session.IToolsPopupDescription;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.action.ISQLPanelAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackActionUpdateListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackTypeEnum;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ChangeTrackAction
extends SquirrelAction
implements ISQLPanelAction,
IToolsPopupDescription {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ChangeTrackAction.class);
    private ISQLPanelAPI _panel;
    private ArrayList<ChangeTrackActionUpdateListener> _changeTrackActionUpdateListeners = new ArrayList();

    public ChangeTrackAction(IApplication app) {
        super(app);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (ChangeTrackTypeEnum.getPreference() == ChangeTrackTypeEnum.FILE) {
            return;
        }
        this._panel.getChangeTracker().rebaseChangeTrackingOnToolbarButtonOrMenuClicked();
    }

    @Override
    public void setSQLPanel(ISQLPanelAPI panel) {
        this._panel = panel;
        boolean enabled = null != this._panel && this._panel.getChangeTracker().isEnabled();
        this.setEnabled(enabled);
        for (ChangeTrackActionUpdateListener l : this._changeTrackActionUpdateListeners.toArray(new ChangeTrackActionUpdateListener[0])) {
            if (null != this._panel && this._panel.getChangeTracker().isEnabled()) {
                l.activeSqlPanelApiChanged(this._panel.getChangeTracker().getChangeTrackType());
                continue;
            }
            l.activeSqlPanelApiChanged(null);
        }
    }

    public void changeTrackTypeChangedForCurrentSqlPanel(ChangeTrackTypeEnum selectedType) {
        this._panel.getChangeTracker().changeTrackTypeChanged(selectedType);
    }

    public void addChangeTrackActionUpdateListener(ChangeTrackActionUpdateListener changeTrackActionUpdateListener) {
        this._changeTrackActionUpdateListeners.remove(changeTrackActionUpdateListener);
        this._changeTrackActionUpdateListeners.add(changeTrackActionUpdateListener);
    }

    public void removeSQLPanelApiChangedListener(ChangeTrackActionUpdateListener changeTrackActionUpdateListener) {
        this._changeTrackActionUpdateListeners.remove(changeTrackActionUpdateListener);
    }

    @Override
    public String getToolsPopupDescription() {
        return s_stringMgr.getString("ChangeTrackAction.tools.popup.description");
    }

    public void setChangeTrackTypeForCurrentSqlPanel(ChangeTrackTypeEnum type) {
        if (null == this._panel) {
            return;
        }
        for (ChangeTrackActionUpdateListener l : this._changeTrackActionUpdateListeners.toArray(new ChangeTrackActionUpdateListener[0])) {
            l.externallySetChangeTrackType(type);
        }
    }
}

