/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action;

import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.FrameWorkAcessor;
import net.sourceforge.squirrel_sql.client.session.action.ISQLPanelAction;
import net.sourceforge.squirrel_sql.client.session.action.InQuotesCommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ConvertToStringBuilderAction
extends SquirrelAction
implements ISQLPanelAction {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ConvertToStringBuilderAction.class);
    private static final ILogger s_log = LoggerController.createLogger(ConvertToStringBuilderAction.class);
    private ISession _session;

    public ConvertToStringBuilderAction(IApplication app) {
        super(app, app.getResources());
    }

    @Override
    public void setSQLPanel(ISQLPanelAPI panel) {
        this._session = null != panel ? panel.getSession() : null;
        this.setEnabled(null != this._session);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this._session != null) {
            try {
                new InQuotesCommand(FrameWorkAcessor.getSQLPanelAPI(this._session), true).execute();
            }
            catch (Throwable ex) {
                String msg = s_stringMgr.getString("editextras.convertStringBufErr", ex);
                this._session.showErrorMessage(msg);
                s_log.error(msg, ex);
            }
        }
    }
}

