/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import net.sourceforge.squirrel_sql.client.session.action.EscapeDateFrame;
import net.sourceforge.squirrel_sql.client.session.action.EscapeDateListener;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;

public class EscapeDateController {
    private EscapeDateFrame _frame;
    private EscapeDateListener _escapeDateListener;

    public EscapeDateController(Window parent, EscapeDateListener escapeDateListener, boolean modal) {
        this._escapeDateListener = escapeDateListener;
        this._frame = new EscapeDateFrame(parent);
        this._frame.setModal(modal);
        this._frame.btnTimestamp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EscapeDateController.this.onTimeStamp();
            }
        });
        this._frame.btnDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EscapeDateController.this.onDate();
            }
        });
        this._frame.btnTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EscapeDateController.this.onTime();
            }
        });
        Calendar cal = Calendar.getInstance();
        this._frame.txtYear.setText("" + cal.get(1));
        this._frame.txtMonth.setText("" + (cal.get(2) + 1));
        this._frame.txtDay.setText("" + cal.get(5));
        this._frame.txtHour.setText("" + cal.get(11));
        this._frame.txtMinute.setText("" + cal.get(12));
        this._frame.txtSecond.setText("" + cal.get(13));
        GUIUtils.centerWithinParent(this._frame);
        this._frame.setVisible(true);
        this._frame.txtYear.requestFocus();
    }

    private String prefixNulls(String toPrefix, int digitCount) {
        String ret = toPrefix;
        while (ret.length() < digitCount) {
            ret = "0" + ret;
        }
        return ret;
    }

    private void onTime() {
        String esc = "{t '" + this.prefixNulls(this._frame.txtHour.getText(), 2) + ":" + this.prefixNulls(this._frame.txtMinute.getText(), 2) + ":" + this.prefixNulls(this._frame.txtSecond.getText(), 2) + "'}";
        this._escapeDateListener.setDateString(esc);
        this._frame.setVisible(false);
        this._frame.dispose();
    }

    private void onDate() {
        String esc = "{d '" + this.prefixNulls(this._frame.txtYear.getText(), 4) + "-" + this.prefixNulls(this._frame.txtMonth.getText(), 2) + "-" + this.prefixNulls(this._frame.txtDay.getText(), 2) + "'}";
        this._escapeDateListener.setDateString(esc);
        this._frame.setVisible(false);
        this._frame.dispose();
    }

    private void onTimeStamp() {
        String esc = "{ts '" + this.prefixNulls(this._frame.txtYear.getText(), 4) + "-" + this.prefixNulls(this._frame.txtMonth.getText(), 2) + "-" + this.prefixNulls(this._frame.txtDay.getText(), 2) + " " + this.prefixNulls(this._frame.txtHour.getText(), 2) + ":" + this.prefixNulls(this._frame.txtMinute.getText(), 2) + ":" + this.prefixNulls(this._frame.txtSecond.getText(), 2) + "'}";
        this._escapeDateListener.setDateString(esc);
        this._frame.setVisible(false);
        this._frame.dispose();
    }
}

