/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action;

import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.ISessionWidget;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.fw.gui.ResizableTextEditDialog;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class RenameSessionAction
extends SquirrelAction
implements ISessionAction {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RenameSessionAction.class);
    private ISession _session;

    public RenameSessionAction(IApplication app) {
        super(app);
    }

    @Override
    public void setSession(ISession session) {
        this._session = session;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.setSession(this._app.getSessionManager().getActiveSession());
        String oldTitle = !this._session.getActiveSessionWindow().equals(this._app.getWindowManager().getAllFramesOfSession(this._session.getIdentifier())[0]) ? this._session.getActiveSessionWindow().getTitle() : this._session.getTitle();
        ResizableTextEditDialog textEditDialog = new ResizableTextEditDialog(this._app.getMainFrame(), this.getClass().getName(), s_stringMgr.getString("RenameSessionAction.title"), s_stringMgr.getString("RenameSessionAction.label"), oldTitle, null);
        if (!textEditDialog.isOk()) {
            return;
        }
        if (!this._session.getActiveSessionWindow().equals(this._app.getWindowManager().getAllFramesOfSession(this._session.getIdentifier())[0])) {
            this._session.getActiveSessionWindow().setTitle(textEditDialog.getEditedText());
        } else {
            this._session.setUserChangedTitle(textEditDialog.getEditedText());
            this.updateGui();
        }
    }

    private void updateGui() {
        this._app.getMainFrame().repaint();
        ISessionWidget[] sessionSheets = this._app.getWindowManager().getAllFramesOfSession(this._session.getIdentifier());
        if (sessionSheets.length == 0) {
            return;
        }
        sessionSheets[0].setTitle(this._session.getTitle());
        for (int i = 1; i < sessionSheets.length; ++i) {
            sessionSheets[i].setTitle(this._session.getTitle() + " (" + (i + 1) + ")");
        }
    }
}

